/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

public interface AxisOrdinal {
    public String name();

    public int logicalOrdinal();

    public boolean isFilter();

    public static enum StandardAxisOrdinal implements AxisOrdinal
    {
        NONE,
        SLICER,
        COLUMNS,
        ROWS,
        PAGES,
        CHAPTERS,
        SECTIONS;


        public static AxisOrdinal forLogicalOrdinal(final int ordinal) {
            if (ordinal + 2 > SECTIONS.ordinal()) {
                return new AxisOrdinal(){

                    @Override
                    public String name() {
                        return "AXIS(" + ordinal + ")";
                    }

                    @Override
                    public int logicalOrdinal() {
                        return ordinal;
                    }

                    @Override
                    public boolean isFilter() {
                        return false;
                    }
                };
            }
            return StandardAxisOrdinal.values()[ordinal + 2];
        }

        @Override
        public int logicalOrdinal() {
            return this.ordinal() - 2;
        }

        @Override
        public boolean isFilter() {
            return this == SLICER;
        }
    }
}

