/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mondrian.olap.EnumeratedValues;
import mondrian.spi.PropertyFormatter;

public class Property
extends EnumeratedValues.BasicValue {
    private static final Map<String, Property> synonyms = new HashMap<String, Property>();
    public static final Map<String, Property> mapUpperNameToProperties = new HashMap<String, Property>();
    public static final int FORMAT_EXP_PARSED_ORDINAL = 0;
    public static final Property FORMAT_EXP_PARSED = new Property("$format_exp", Datatype.TYPE_OTHER, 0, true, false, false, null);
    public static final int AGGREGATION_TYPE_ORDINAL = 1;
    public static final Property AGGREGATION_TYPE = new Property("$aggregation_type", Datatype.TYPE_OTHER, 1, true, false, false, null);
    public static final int NAME_ORDINAL = 2;
    public static final Property NAME = new Property("$name", Datatype.TYPE_STRING, 2, true, false, false, null);
    public static final int CAPTION_ORDINAL = 3;
    public static final Property CAPTION = new Property("$caption", Datatype.TYPE_STRING, 3, true, false, false, null);
    public static final int CONTRIBUTING_CHILDREN_ORDINAL = 4;
    public static final Property CONTRIBUTING_CHILDREN = new Property("$contributingChildren", Datatype.TYPE_OTHER, 4, true, false, false, null);
    public static final int FORMULA_ORDINAL = 5;
    public static final Property FORMULA = new Property("$formula", Datatype.TYPE_OTHER, 5, true, false, false, null);
    public static final int MEMBER_SCOPE_ORDINAL = 6;
    public static final Property MEMBER_SCOPE = new Property("$member_scope", Datatype.TYPE_OTHER, 6, true, true, false, null);
    public static final int CATALOG_NAME_ORDINAL = 10;
    public static final Property CATALOG_NAME = new Property("CATALOG_NAME", Datatype.TYPE_STRING, 10, false, true, false, "Optional. The name of the catalog to which this member belongs. NULL if the provider does not support catalogs.");
    public static final int SCHEMA_NAME_ORDINAL = 11;
    public static final Property SCHEMA_NAME = new Property("SCHEMA_NAME", Datatype.TYPE_STRING, 11, false, true, false, "Optional. The name of the schema to which this member belongs. NULL if the provider does not support schemas.");
    public static final int CUBE_NAME_ORDINAL = 12;
    public static final Property CUBE_NAME = new Property("CUBE_NAME", Datatype.TYPE_STRING, 12, false, true, false, "Required. Name of the cube to which this member belongs.");
    public static final int DIMENSION_UNIQUE_NAME_ORDINAL = 13;
    public static final Property DIMENSION_UNIQUE_NAME = new Property("DIMENSION_UNIQUE_NAME", Datatype.TYPE_STRING, 13, false, true, false, "Required. Unique name of the dimension to which this member belongs. For providers that generate unique names by qualification, each component of this name is delimited.");
    public static final int HIERARCHY_UNIQUE_NAME_ORDINAL = 14;
    public static final Property HIERARCHY_UNIQUE_NAME = new Property("HIERARCHY_UNIQUE_NAME", Datatype.TYPE_STRING, 14, false, true, false, "Required. Unique name of the hierarchy. If the member belongs to more than one hierarchy, there is one row for each hierarchy to which it belongs. For providers that generate unique names by qualification, each component of this name is delimited.");
    public static final int LEVEL_UNIQUE_NAME_ORDINAL = 15;
    public static final Property LEVEL_UNIQUE_NAME = new Property("LEVEL_UNIQUE_NAME", Datatype.TYPE_STRING, 15, false, true, false, "Required. Unique name of the level to which the member belongs. For providers that generate unique names by qualification, each component of this name is delimited.");
    public static final int LEVEL_NUMBER_ORDINAL = 16;
    public static final Property LEVEL_NUMBER = new Property("LEVEL_NUMBER", Datatype.TYPE_STRING, 16, false, true, false, "Required. The distance of the member from the root of the hierarchy. The root level is zero.");
    public static final int MEMBER_ORDINAL_ORDINAL = 17;
    public static final Property MEMBER_ORDINAL = new Property("MEMBER_ORDINAL", Datatype.TYPE_NUMERIC, 17, false, true, false, "Required. Ordinal number of the member. Sort rank of the member when members of this dimension are sorted in their natural sort order. If providers do not have the concept of natural ordering, this should be the rank when sorted by MEMBER_NAME.");
    public static final int MEMBER_NAME_ORDINAL = 18;
    public static final Property MEMBER_NAME = new Property("MEMBER_NAME", Datatype.TYPE_STRING, 18, false, true, false, "Required. Name of the member.");
    public static final int MEMBER_UNIQUE_NAME_ORDINAL = 19;
    public static final Property MEMBER_UNIQUE_NAME = new Property("MEMBER_UNIQUE_NAME", Datatype.TYPE_STRING, 19, false, true, false, "Required. Unique name of the member. For providers that generate unique names by qualification, each component of this name is delimited.");
    public static final int MEMBER_TYPE_ORDINAL = 20;
    public static final Property MEMBER_TYPE = new Property("MEMBER_TYPE", Datatype.TYPE_NUMERIC, 20, false, true, false, "Required. Type of the member. Can be one of the following values: MDMEMBER_TYPE_REGULAR, MDMEMBER_TYPE_ALL, MDMEMBER_TYPE_FORMULA, MDMEMBER_TYPE_MEASURE, MDMEMBER_TYPE_UNKNOWN. MDMEMBER_TYPE_FORMULA takes precedence over MDMEMBER_TYPE_MEASURE. Therefore, if there is a formula (calculated) member on the Measures dimension, it is listed as MDMEMBER_TYPE_FORMULA.");
    public static final int MEMBER_GUID_ORDINAL = 21;
    public static final Property MEMBER_GUID = new Property("MEMBER_GUID", Datatype.TYPE_STRING, 21, false, true, false, "Optional. Member GUID. NULL if no GUID exists.");
    public static final int MEMBER_CAPTION_ORDINAL = 22;
    public static final Property MEMBER_CAPTION = new Property("MEMBER_CAPTION", Datatype.TYPE_STRING, 22, false, true, false, "Required. A label or caption associated with the member. Used primarily for display purposes. If a caption does not exist, MEMBER_NAME is returned.");
    public static final int CHILDREN_CARDINALITY_ORDINAL = 23;
    public static final Property CHILDREN_CARDINALITY = new Property("CHILDREN_CARDINALITY", Datatype.TYPE_NUMERIC, 23, false, true, false, "Required. Number of children that the member has. This can be an estimate, so consumers should not rely on this to be the exact count. Providers should return the best estimate possible.");
    public static final int PARENT_LEVEL_ORDINAL = 24;
    public static final Property PARENT_LEVEL = new Property("PARENT_LEVEL", Datatype.TYPE_NUMERIC, 24, false, true, false, "Required. The distance of the member's parent from the root level of the hierarchy. The root level is zero.");
    public static final int PARENT_UNIQUE_NAME_ORDINAL = 25;
    public static final Property PARENT_UNIQUE_NAME = new Property("PARENT_UNIQUE_NAME", Datatype.TYPE_STRING, 25, false, true, false, "Required. Unique name of the member's parent. NULL is returned for any members at the root level. For providers that generate unique names by qualification, each component of this name is delimited.");
    public static final int PARENT_COUNT_ORDINAL = 26;
    public static final Property PARENT_COUNT = new Property("PARENT_COUNT", Datatype.TYPE_NUMERIC, 26, false, true, false, "Required. Number of parents that this member has.");
    public static final int DESCRIPTION_ORDINAL = 27;
    public static final Property DESCRIPTION = new Property("DESCRIPTION", Datatype.TYPE_STRING, 27, false, true, false, "Optional. A human-readable description of the member.");
    public static final int VISIBLE_ORDINAL = 28;
    public static final Property VISIBLE = new Property("$visible", Datatype.TYPE_BOOLEAN, 28, true, false, false, null);
    public static final int CELL_FORMATTER_ORDINAL = 29;
    public static final Property CELL_FORMATTER = new Property("CELL_FORMATTER", Datatype.TYPE_STRING, 29, false, true, false, "Name of the class which formats cell values of this member.");
    public static final int CELL_FORMATTER_SCRIPT_LANGUAGE_ORDINAL = 51;
    public static final Property CELL_FORMATTER_SCRIPT_LANGUAGE = new Property("CELL_FORMATTER_SCRIPT_LANGUAGE", Datatype.TYPE_STRING, 51, false, true, false, "Name of the scripting language in which a scripted cell formatteris implemented, e.g. 'JavaScript'.");
    public static final int CELL_FORMATTER_SCRIPT_ORDINAL = 52;
    public static final Property CELL_FORMATTER_SCRIPT = new Property("CELL_FORMATTER_SCRIPT", Datatype.TYPE_STRING, 52, false, true, false, "Name of the class which formats cell values of this member.");
    public static final int BACK_COLOR_ORDINAL = 30;
    public static final Property BACK_COLOR = new Property("BACK_COLOR", Datatype.TYPE_STRING, 30, false, false, true, "The background color for displaying the VALUE or FORMATTED_VALUE property. For more information, see FORE_COLOR and BACK_COLOR Contents.");
    public static final int CELL_EVALUATION_LIST_ORDINAL = 31;
    public static final Property CELL_EVALUATION_LIST = new Property("CELL_EVALUATION_LIST", Datatype.TYPE_STRING, 31, false, false, true, "The semicolon-delimited list of evaluated formulas applicable to the cell, in order from lowest to highest solve order. For more information about solve order, see Understanding Pass Order and Solve Order");
    public static final int CELL_ORDINAL_ORDINAL = 32;
    public static final Property CELL_ORDINAL = new Property("CELL_ORDINAL", Datatype.TYPE_NUMERIC, 32, false, false, true, "The ordinal number of the cell in the dataset.");
    public static final int FORE_COLOR_ORDINAL = 33;
    public static final Property FORE_COLOR = new Property("FORE_COLOR", Datatype.TYPE_STRING, 33, false, false, true, "The foreground color for displaying the VALUE or FORMATTED_VALUE property. For more information, see FORE_COLOR and BACK_COLOR Contents.");
    public static final int FONT_NAME_ORDINAL = 34;
    public static final Property FONT_NAME = new Property("FONT_NAME", Datatype.TYPE_STRING, 34, false, false, true, "The font to be used to display the VALUE or FORMATTED_VALUE property.");
    public static final int FONT_SIZE_ORDINAL = 35;
    public static final Property FONT_SIZE = new Property("FONT_SIZE", Datatype.TYPE_STRING, 35, false, false, true, "Font size to be used to display the VALUE or FORMATTED_VALUE property.");
    public static final int FONT_FLAGS_ORDINAL = 36;
    public static final Property FONT_FLAGS = new Property("FONT_FLAGS", Datatype.TYPE_NUMERIC, 36, false, false, true, "The bitmask detailing effects on the font. The value is the result of a bitwise OR operation of one or more of the following constants: MDFF_BOLD  = 1, MDFF_ITALIC = 2, MDFF_UNDERLINE = 4, MDFF_STRIKEOUT = 8. For example, the value 5 represents the combination of bold (MDFF_BOLD) and underline (MDFF_UNDERLINE) font effects.");
    public static final int FORMATTED_VALUE_ORDINAL = 37;
    public static final Property FORMATTED_VALUE = new Property("FORMATTED_VALUE", Datatype.TYPE_STRING, 37, false, false, true, "The character string that represents a formatted display of the VALUE property.");
    public static final int FORMAT_STRING_ORDINAL = 38;
    public static final Property FORMAT_STRING = new Property("FORMAT_STRING", Datatype.TYPE_STRING, 38, false, false, true, "The format string used to create the FORMATTED_VALUE property value. For more information, see FORMAT_STRING Contents.");
    public static final int NON_EMPTY_BEHAVIOR_ORDINAL = 39;
    public static final Property NON_EMPTY_BEHAVIOR = new Property("NON_EMPTY_BEHAVIOR", Datatype.TYPE_STRING, 39, false, false, true, "The measure used to determine the behavior of calculated members when resolving empty cells.");
    public static final int SOLVE_ORDER_ORDINAL = 40;
    public static final Property SOLVE_ORDER = new Property("SOLVE_ORDER", Datatype.TYPE_NUMERIC, 40, false, false, true, "The solve order of the cell.");
    public static final int VALUE_ORDINAL = 41;
    public static final Property VALUE = new Property("VALUE", Datatype.TYPE_NUMERIC, 41, false, true, true, "The unformatted value of the cell.");
    public static final int DATATYPE_ORDINAL = 42;
    public static final Property DATATYPE = new Property("DATATYPE", Datatype.TYPE_STRING, 42, false, false, true, "The datatype of the cell.");
    public static final int DEPTH_ORDINAL = 43;
    public static final Property DEPTH = new Property("DEPTH", Datatype.TYPE_NUMERIC, 43, true, true, false, "The level depth of a member");
    public static final int DISPLAY_INFO_ORDINAL = 44;
    public static final Property DISPLAY_INFO = new Property("DISPLAY_INFO", Datatype.TYPE_NUMERIC, 44, false, true, false, "Display instruction of a member for XML/A");
    public static final int MEMBER_KEY_ORDINAL = 45;
    public static final Property MEMBER_KEY = new Property("MEMBER_KEY", Datatype.TYPE_STRING, 45, false, true, false, "Member key.");
    public static final int KEY_ORDINAL = 46;
    public static final Property KEY = new Property("KEY", Datatype.TYPE_STRING, 46, false, true, false, "Key.");
    public static final int SCENARIO_ORDINAL = 48;
    public static final Property SCENARIO = new Property("$scenario", Datatype.TYPE_OTHER, 48, true, true, false, null);
    public static final int DISPLAY_FOLDER_ORDINAL = 49;
    public static final Property DISPLAY_FOLDER = new Property("DISPLAY_FOLDER", Datatype.TYPE_STRING, 49, false, true, false, "Folder in which to display a measure");
    public static final int LANGUAGE_ORDINAL = 50;
    public static final Property LANGUAGE = new Property("LANGUAGE", Datatype.TYPE_NUMERIC, 50, false, false, true, "The translation expressed as an LCID. Only valid for property translations.");
    public static final int FORMAT_EXP_ORDINAL = 53;
    public static final Property FORMAT_EXP = new Property("FORMAT_EXP", Datatype.TYPE_STRING, 53, true, true, false, null);
    public static final int ACTION_TYPE_ORDINAL = 54;
    public static final Property ACTION_TYPE = new Property("ACTION_TYPE", Datatype.TYPE_NUMERIC, 54, false, false, true, null);
    public static final int DRILLTHROUGH_COUNT_ORDINAL = 55;
    public static final Property DRILLTHROUGH_COUNT = new Property("DRILLTHROUGH_COUNT", Datatype.TYPE_NUMERIC, 55, false, false, true, "Number of fact rows that contributed to this cell. If the cell is not drillable, value is -1.");
    static final Set<String> FORMAT_PROPERTIES = new HashSet<String>(Arrays.asList("format", "format_string", "FORMAT", Property.FORMAT_STRING.name));
    private final Datatype type;
    private final boolean internal;
    private final boolean member;
    private final boolean cell;
    private static int nextOrdinal = 100;
    public static final EnumeratedValues<Property> enumeration = new EnumeratedValues((EnumeratedValues.Value[])new Property[]{FORMAT_EXP_PARSED, AGGREGATION_TYPE, NAME, CAPTION, CONTRIBUTING_CHILDREN, FORMULA, CATALOG_NAME, SCHEMA_NAME, CUBE_NAME, DIMENSION_UNIQUE_NAME, HIERARCHY_UNIQUE_NAME, LEVEL_UNIQUE_NAME, LEVEL_NUMBER, MEMBER_UNIQUE_NAME, MEMBER_NAME, MEMBER_TYPE, MEMBER_GUID, MEMBER_CAPTION, MEMBER_ORDINAL, CHILDREN_CARDINALITY, PARENT_LEVEL, PARENT_UNIQUE_NAME, PARENT_COUNT, DESCRIPTION, VISIBLE, CELL_FORMATTER, CELL_FORMATTER_SCRIPT, CELL_FORMATTER_SCRIPT_LANGUAGE, BACK_COLOR, CELL_EVALUATION_LIST, CELL_ORDINAL, FORE_COLOR, FONT_NAME, FONT_SIZE, FONT_FLAGS, FORMAT_STRING, FORMATTED_VALUE, NON_EMPTY_BEHAVIOR, SOLVE_ORDER, VALUE, DATATYPE, MEMBER_KEY, KEY, SCENARIO, DISPLAY_FOLDER, FORMAT_EXP, ACTION_TYPE, DRILLTHROUGH_COUNT});
    private static final int MAX_ORDINAL = 56;

    protected Property(String name, Datatype type, int ordinal, boolean internal, boolean member, boolean cell, String description) {
        int n;
        if (ordinal < 0) {
            int n2 = nextOrdinal;
            n = n2;
            nextOrdinal = n2 + 1;
        } else {
            n = ordinal;
        }
        super(name, n, description);
        this.type = type;
        this.internal = internal;
        this.member = member;
        this.cell = cell;
    }

    public Datatype getType() {
        return this.type;
    }

    public PropertyFormatter getFormatter() {
        return null;
    }

    public String getCaption() {
        return this.name;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isMemberProperty() {
        return this.member;
    }

    public boolean isCellProperty() {
        return this.cell && this.isStandard();
    }

    public boolean isStandard() {
        return this.ordinal < 56;
    }

    public static Property lookup(int ordinal) {
        return enumeration.getValue(ordinal);
    }

    public static Property lookup(String name, boolean matchCase) {
        if (matchCase) {
            Property property = enumeration.getValue(name, false);
            if (property != null) {
                return property;
            }
            return synonyms.get(name);
        }
        return mapUpperNameToProperties.get(name.toUpperCase());
    }

    static {
        synonyms.put("CAPTION", MEMBER_CAPTION);
        synonyms.put("FORMAT", FORMAT_STRING);
        for (String propertyName : enumeration.getNames()) {
            Property property = enumeration.getValue(propertyName, true);
            mapUpperNameToProperties.put(propertyName.toUpperCase(), property);
            assert (property.getOrdinal() < 56);
        }
        for (Map.Entry entry : synonyms.entrySet()) {
            mapUpperNameToProperties.put(((String)entry.getKey()).toUpperCase(), (Property)entry.getValue());
        }
    }

    public static enum Datatype {
        TYPE_STRING,
        TYPE_NUMERIC,
        TYPE_BOOLEAN,
        TYPE_DATE,
        TYPE_TIME,
        TYPE_TIMESTAMP,
        TYPE_OTHER;

    }
}

