/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import java.util.List;
import mondrian.olap.Id;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;

class ChildByNameConstraint
extends DefaultMemberChildrenConstraint {
    private final String[] childNames;
    private final Object cacheKey;

    public ChildByNameConstraint(Id.NameSegment childName) {
        this.childNames = new String[]{childName.name};
        this.cacheKey = Arrays.asList(ChildByNameConstraint.class, childName);
    }

    public ChildByNameConstraint(List<Id.NameSegment> childNames) {
        this.childNames = new String[childNames.size()];
        int i = 0;
        for (Id.NameSegment name : childNames) {
            this.childNames[i++] = name.name;
        }
        this.cacheKey = Arrays.asList(ChildByNameConstraint.class, this.childNames);
    }

    public int hashCode() {
        return this.getCacheKey().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ChildByNameConstraint && this.getCacheKey().equals(((ChildByNameConstraint)obj).getCacheKey());
    }

    @Override
    public void addLevelConstraint(SqlQuery query, RolapCube baseCube, AggStar aggStar, RolapLevel level) {
        super.addLevelConstraint(query, baseCube, aggStar, level);
        query.addWhere(SqlConstraintUtils.constrainLevel(level, query, baseCube, aggStar, this.childNames, true));
    }

    @Override
    public String toString() {
        return "ChildByNameConstraint(" + Arrays.toString(this.childNames) + ")";
    }

    @Override
    public Object getCacheKey() {
        return this.cacheKey;
    }

    public List<String> getChildNames() {
        return Arrays.asList(this.childNames);
    }
}

