/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import mondrian.olap.Util;
import mondrian.spi.CellFormatter;
import mondrian.spi.DataSourceChangeListener;
import mondrian.spi.DataSourceResolver;
import mondrian.spi.DynamicSchemaProcessor;
import mondrian.spi.MemberFormatter;
import mondrian.spi.PropertyFormatter;
import mondrian.spi.UserDefinedFunction;

public class Scripts {
    public static PropertyFormatter propertyFormatter(String scriptText, String scriptLanguage) {
        return Scripts.create(PropertyFormatter.class, scriptText, scriptLanguage, "formatProperty(member,propertyName,propertyValue)");
    }

    public static MemberFormatter memberFormatter(String scriptText, String scriptLanguage) {
        return Scripts.create(MemberFormatter.class, scriptText, scriptLanguage, "formatMember(member)");
    }

    public static CellFormatter cellFormatter(String scriptText, String scriptLanguage) {
        return Scripts.create(CellFormatter.class, scriptText, scriptLanguage, "formatCell(value)");
    }

    public static DataSourceChangeListener dataSourceChangeListener(ScriptDefinition script) {
        String code;
        switch (script.language) {
            case JAVASCRIPT: {
                code = "function isHierarchyChanged(hierarchy) {\n  return false;\n}\nfunction isAggregationChanged(aggregation) {\n  return false;\n}\n";
                break;
            }
            default: {
                throw Util.unexpected(script.language);
            }
        }
        return Scripts.create(script, DataSourceChangeListener.class, code);
    }

    public static DataSourceResolver dataSourceResolver(ScriptDefinition script) {
        return Scripts.create(script, DataSourceResolver.class, Scripts.simple(script, "lookup(dataSourceName)"));
    }

    public static DynamicSchemaProcessor dynamicSchemaProcessor(ScriptDefinition script) {
        return Scripts.create(script, DynamicSchemaProcessor.class, Scripts.simple(script, "processSchema(schemaUrl, connectInfo)"));
    }

    public static UserDefinedFunction userDefinedFunction(ScriptDefinition script, String name) {
        String code;
        switch (script.language) {
            case JAVASCRIPT: {
                code = "var mondrian = Packages.mondrian;\nfunction getName() {\n  return " + Util.quoteJavaString(name) + ";\n}\nfunction getDescription() {\n  return this.getName();\n}\nfunction getSyntax() {\n  return mondrian.olap.Syntax.Function;\n}\nfunction getParameterTypes() {\n  return new Array();\n}\nfunction getReturnType(parameterTypes) {\n  return new mondrian.olap.type.ScalarType();\n}\nfunction getReservedWords() {\n  return null;\n}\nfunction execute(evaluator, arguments) {\n  return null;\n}\n" + script.script;
                break;
            }
            default: {
                throw Util.unexpected(script.language);
            }
        }
        return Scripts.create(script, UserDefinedFunction.class, code);
    }

    private static ScriptDefinition toScriptDef(String script, String language) {
        ScriptLanguage scriptLanguage = ScriptLanguage.lookup(language);
        if (scriptLanguage == null) {
            throw Util.newError("Invalid script language '" + language + "'");
        }
        return new ScriptDefinition(script, scriptLanguage);
    }

    private static <T> T create(ScriptDefinition script, Class<T> iface, String script2) {
        String engineName = script.language.engineName;
        return Util.compileScript(iface, script2, engineName);
    }

    private static <T> T create(Class<T> iface, String scriptText, String scriptLanguage, String functionSignature) {
        ScriptDefinition scriptDef = Scripts.toScriptDef(scriptText, scriptLanguage);
        String script = Scripts.simple(scriptDef, functionSignature);
        return Scripts.create(scriptDef, iface, script);
    }

    private static String simple(ScriptDefinition script, String decl) {
        switch (script.language) {
            case JAVASCRIPT: {
                return "function " + decl + " { " + script.script + " }";
            }
        }
        throw Util.unexpected(script.language);
    }

    public static enum ScriptLanguage {
        JAVASCRIPT("JavaScript");

        final String engineName;

        private ScriptLanguage(String engineName) {
            this.engineName = engineName;
        }

        public static ScriptLanguage lookup(String languageName) {
            for (ScriptLanguage scriptLanguage : ScriptLanguage.values()) {
                if (!scriptLanguage.engineName.equals(languageName)) continue;
                return scriptLanguage;
            }
            return null;
        }
    }

    public static class ScriptDefinition {
        public final String script;
        public final ScriptLanguage language;

        public ScriptDefinition(String script, ScriptLanguage language) {
            this.script = script;
            this.language = language;
            assert (script != null);
            assert (language != null);
        }
    }
}

