/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class VerticaDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(VerticaDialect.class, Dialect.DatabaseProduct.VERTICA);
    private static final Map<Integer, SqlStatement.Type> VERTICA_TYPE_MAP;

    public VerticaDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return true;
    }

    @Override
    public boolean allowsFromQuery() {
        return true;
    }

    @Override
    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.VERTICA;
    }

    @Override
    public boolean allowsMultipleCountDistinct() {
        return false;
    }

    @Override
    public boolean allowsCountDistinctWithOtherAggs() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public SqlStatement.Type getType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int columnType = metaData.getColumnType(columnIndex + 1);
        SqlStatement.Type internalType = null;
        if (columnType == 2 || columnType == 3) {
            int precision = metaData.getPrecision(columnIndex + 1);
            int scale = metaData.getScale(columnIndex + 1);
            internalType = scale == 0 && precision <= 9 ? SqlStatement.Type.INT : (scale == 0 && precision <= 19 ? SqlStatement.Type.LONG : SqlStatement.Type.DOUBLE);
        } else {
            internalType = VERTICA_TYPE_MAP.get(columnType);
            if (internalType == null) {
                internalType = SqlStatement.Type.OBJECT;
            }
        }
        this.logTypeInfo(metaData, columnIndex, internalType);
        return internalType;
    }

    @Override
    public boolean supportsMultiValueInExpr() {
        return true;
    }

    static {
        HashMap<Integer, SqlStatement.Type> typeMapInitial = new HashMap<Integer, SqlStatement.Type>();
        typeMapInitial.put(5, SqlStatement.Type.LONG);
        typeMapInitial.put(-6, SqlStatement.Type.LONG);
        typeMapInitial.put(4, SqlStatement.Type.LONG);
        typeMapInitial.put(16, SqlStatement.Type.INT);
        typeMapInitial.put(8, SqlStatement.Type.DOUBLE);
        typeMapInitial.put(6, SqlStatement.Type.DOUBLE);
        typeMapInitial.put(-5, SqlStatement.Type.LONG);
        VERTICA_TYPE_MAP = Collections.unmodifiableMap(typeMapInitial);
    }
}

