/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.Timer;
import java.util.UUID;
import java.util.regex.Pattern;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapUtil;
import mondrian.util.UtilCompatible;
import org.apache.log4j.Logger;

public class UtilCompatibleJdk15
implements UtilCompatible {
    private static final Logger LOGGER = Logger.getLogger(Util.class);

    @Override
    public BigDecimal makeBigDecimalFromDouble(double d) {
        return new BigDecimal(d, MathContext.DECIMAL64);
    }

    @Override
    public String quotePattern(String s) {
        return Pattern.quote(s);
    }

    @Override
    public <T> T getAnnotation(Method method, String annotationClassName, T defaultValue) {
        try {
            Class<?> annotationClass = Class.forName(annotationClassName);
            if (method.isAnnotationPresent(annotationClass)) {
                Object annotation = method.getAnnotation(annotationClass);
                Method method1 = annotation.getClass().getMethod("value", new Class[0]);
                return (T)method1.invoke(annotation, new Object[0]);
            }
        }
        catch (IllegalAccessException e) {
            return defaultValue;
        }
        catch (InvocationTargetException e) {
            return defaultValue;
        }
        catch (NoSuchMethodException e) {
            return defaultValue;
        }
        catch (ClassNotFoundException e) {
            return defaultValue;
        }
        return defaultValue;
    }

    @Override
    public String generateUuidString() {
        return UUID.randomUUID().toString();
    }

    @Override
    public <T> T compileScript(Class<T> iface, String script, String engineName) {
        throw new UnsupportedOperationException("Scripting not supported until Java 1.6");
    }

    @Override
    public <T> void threadLocalRemove(ThreadLocal<T> threadLocal) {
        threadLocal.remove();
    }

    @Override
    public Util.MemoryInfo getMemoryInfo() {
        return new Util.MemoryInfo(){
            protected final MemoryPoolMXBean TENURED_POOL = UtilCompatibleJdk15.access$000();

            @Override
            public Util.MemoryInfo.Usage get() {
                final MemoryUsage memoryUsage = this.TENURED_POOL.getUsage();
                return new Util.MemoryInfo.Usage(){

                    @Override
                    public long getUsed() {
                        return memoryUsage.getUsed();
                    }

                    @Override
                    public long getCommitted() {
                        return memoryUsage.getCommitted();
                    }

                    @Override
                    public long getMax() {
                        return memoryUsage.getMax();
                    }
                };
            }
        };
    }

    @Override
    public Timer newTimer(String name, boolean isDaemon) {
        return new Timer(name, isDaemon);
    }

    private static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP) continue;
            return pool;
        }
        throw new AssertionError((Object)"Could not find tenured space");
    }

    @Override
    public void cancelStatement(Statement stmt) {
        block3: {
            try {
                stmt.cancel();
            }
            catch (Throwable t) {
                if (t.getMessage().equals("org.apache.commons.dbcp.DelegatingStatement is closed.")) {
                    return;
                }
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug((Object)MondrianResource.instance().ExecutionStatementCleanupException.ex(t.getMessage(), t), t);
            }
        }
    }

    @Override
    public <T> Set<T> newIdentityHashSet() {
        return Util.newIdentityHashSetFake();
    }

    @Override
    public <T extends Comparable<T>> int binarySearch(T[] ts, int start, int end, T t) {
        int i = Collections.binarySearch(Arrays.asList(ts).subList(start, end), t, RolapUtil.ROLAP_COMPARATOR);
        return i < 0 ? i - start : i + start;
    }

    static /* synthetic */ MemoryPoolMXBean access$000() {
        return UtilCompatibleJdk15.findTenuredGenPool();
    }
}

