/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.sqoop.ui;

import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.kettle.plugins.hdfs.vfs.HadoopVfsFileChooserDialog;
import org.pentaho.big.data.kettle.plugins.job.AbstractJobEntryController;
import org.pentaho.big.data.kettle.plugins.job.JobEntryMode;
import org.pentaho.big.data.kettle.plugins.job.PropertyEntry;
import org.pentaho.big.data.kettle.plugins.sqoop.AbstractSqoopJobEntry;
import org.pentaho.big.data.kettle.plugins.sqoop.ArgumentWrapper;
import org.pentaho.big.data.kettle.plugins.sqoop.DatabaseItem;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopConfig;
import org.pentaho.big.data.kettle.plugins.sqoop.SqoopUtils;
import org.pentaho.big.data.plugins.common.ui.HadoopClusterDelegateImpl;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.util.AbstractModelList;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public abstract class AbstractSqoopJobEntryController<S extends SqoopConfig, E extends AbstractSqoopJobEntry<S>>
extends AbstractJobEntryController<S, E> {
    public static final String SELECTED_DATABASE_CONNECTION = "selectedDatabaseConnection";
    public static final String MODE_TOGGLE_LABEL = "modeToggleLabel";
    protected static Class<?> PKG = AbstractSqoopJobEntry.class;
    private final String[] MODE_I18N_STRINGS = new String[]{"Sqoop.JobEntry.AdvancedOptions.Button.Text", "Sqoop.JobEntry.QuickSetup.Button.Text"};
    public static final String VALUE = "value";
    protected DatabaseItem NO_DATABASE = new DatabaseItem("@@none@@", "Choose Available");
    protected DatabaseItem USE_ADVANCED_OPTIONS = new DatabaseItem("@@advanced@@", "Use Advanced Options");
    private NamedCluster CHOOSE_AVAILABLE_CLUSTER;
    private NamedCluster USE_ADVANCED_OPTIONS_CLUSTER;
    protected AbstractModelList<ArgumentWrapper> advancedArguments;
    private AbstractModelList<DatabaseItem> databaseConnections;
    private AbstractModelList<NamedCluster> namedClusters;
    private DatabaseItem selectedDatabaseConnection;
    private DatabaseDialog databaseDialog;
    protected NamedCluster selectedNamedCluster;
    protected boolean suppressEventHandling = false;
    protected final HadoopClusterDelegateImpl ncDelegate;
    private String modeToggleLabel;
    private AdvancedButton selectedAdvancedButton = AdvancedButton.LIST;

    public AbstractSqoopJobEntryController(JobMeta jobMeta, XulDomContainer container, E jobEntry, BindingFactory bindingFactory) {
        super(jobMeta, container, jobEntry, bindingFactory);
        this.config = ((SqoopConfig)jobEntry.getJobConfig()).clone();
        NamedClusterService namedClusterService = ((AbstractSqoopJobEntry)jobEntry).getNamedClusterService();
        this.advancedArguments = new AbstractModelList();
        this.databaseConnections = new AbstractModelList();
        this.namedClusters = new AbstractModelList();
        this.ncDelegate = new HadoopClusterDelegateImpl(Spoon.getInstance(), namedClusterService, ((AbstractSqoopJobEntry)jobEntry).getRuntimeTestActionService(), ((AbstractSqoopJobEntry)jobEntry).getRuntimeTester());
        this.CHOOSE_AVAILABLE_CLUSTER = namedClusterService.getClusterTemplate();
        this.CHOOSE_AVAILABLE_CLUSTER.setName(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"DatabaseName.ChooseAvailable", (String[])new String[0]));
        this.CHOOSE_AVAILABLE_CLUSTER.setVariable("valid", "false");
        this.USE_ADVANCED_OPTIONS_CLUSTER = namedClusterService.getClusterTemplate();
        this.USE_ADVANCED_OPTIONS_CLUSTER.setName(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"DatabaseName.UseAdvancedOptions", (String[])new String[0]));
        this.USE_ADVANCED_OPTIONS_CLUSTER.setVariable("valid", "false");
    }

    public abstract String getDialogElementId();

    protected void createBindings(S config, XulDomContainer container, BindingFactory bindingFactory, Collection<Binding> bindings) {
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindings.add(bindingFactory.createBinding(config, "jobEntryName", "jobEntryName", VALUE, new BindingConvertor[0]));
        bindings.add(bindingFactory.createBinding(config, "table", "table", VALUE, new BindingConvertor[0]));
        bindings.add(bindingFactory.createBinding(config, "commandLine", "commandLine", VALUE, new BindingConvertor[0]));
        bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        bindings.add(bindingFactory.createBinding((Object)this, MODE_TOGGLE_LABEL, this.getModeToggleLabelElementId(), VALUE, new BindingConvertor[0]));
        bindings.add(bindingFactory.createBinding(this.databaseConnections, "children", "connection", "elements", new BindingConvertor[0]));
        bindings.add(bindingFactory.createBinding(this.namedClusters, "children", "named-clusters", "elements", new BindingConvertor[0]));
        XulTree variablesTree = (XulTree)container.getDocumentRoot().getElementById("advanced-table");
        bindings.add(bindingFactory.createBinding(this.advancedArguments, "children", (Object)variablesTree, "elements", new BindingConvertor[0]));
        XulTree customVariablesTree = (XulTree)container.getDocumentRoot().getElementById("custom-table");
        bindings.add(bindingFactory.createBinding(((SqoopConfig)config).getCustomArguments(), "children", (Object)customVariablesTree, "elements", new BindingConvertor[0]));
        bindingFactory.createBinding(config, "connect", (Object)this, "connectChanged", new BindingConvertor[0]);
        bindingFactory.createBinding(config, "username", (Object)this, "usernameChanged", new BindingConvertor[0]);
        bindingFactory.createBinding(config, "password", (Object)this, "passwordChanged", new BindingConvertor[0]);
        bindingFactory.createBinding(config, "namenodeHost", (Object)this, "advancedNamedConfiguration", new BindingConvertor[0]);
        bindingFactory.createBinding(config, "namenodePort", (Object)this, "advancedNamedConfiguration", new BindingConvertor[0]);
        bindingFactory.createBinding(config, "jobtrackerHost", (Object)this, "advancedNamedConfiguration", new BindingConvertor[0]);
        bindingFactory.createBinding(config, "jobtrackerPort", (Object)this, "advancedNamedConfiguration", new BindingConvertor[0]);
        bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        bindings.add(bindingFactory.createBinding((Object)this, SELECTED_DATABASE_CONNECTION, "connection", "selectedItem", new BindingConvertor[0]));
        bindings.add(bindingFactory.createBinding("named-clusters", "selectedIndex", (Object)this, "selectedNamedCluster", new BindingConvertor[]{new BindingConvertor<Integer, NamedCluster>(){

            public NamedCluster sourceToTarget(Integer index) {
                if (index == -1) {
                    return null;
                }
                return (NamedCluster)AbstractSqoopJobEntryController.this.namedClusters.get(index.intValue());
            }

            public Integer targetToSource(NamedCluster namedCluster) {
                return AbstractSqoopJobEntryController.this.namedClusters.indexOf((Object)namedCluster);
            }
        }}));
    }

    protected void initializeNamedClusterSelection() {
        XulMenuList namedClusterMenu = (XulMenuList)this.container.getDocumentRoot().getElementById("named-clusters");
        try {
            String cn = ((SqoopConfig)this.config).getClusterName();
            if (cn != null) {
                NamedCluster namedCluster = ((AbstractSqoopJobEntry)this.jobEntry).getNamedClusterService().read(cn, this.getMetaStore());
                namedClusterMenu.setSelectedItem((Object)namedCluster);
                this.setSelectedNamedCluster(namedCluster);
            } else if (((SqoopConfig)this.config).isAdvancedClusterConfigSet()) {
                this.setSelectedNamedCluster(this.USE_ADVANCED_OPTIONS_CLUSTER);
            } else {
                this.setSelectedNamedCluster(this.CHOOSE_AVAILABLE_CLUSTER);
            }
        }
        catch (MetaStoreException e) {
            ((AbstractSqoopJobEntry)this.jobEntry).logError(e.getMessage());
        }
    }

    public AbstractModelList<NamedCluster> getNamedClusters() {
        return this.namedClusters;
    }

    public void setNamedClusters(AbstractModelList<NamedCluster> namedClusters) {
        this.namedClusters = namedClusters;
    }

    public void setSelectedNamedCluster(NamedCluster namedCluster) {
        this.selectedNamedCluster = namedCluster;
        if (!this.suppressEventHandling) {
            if (this.CHOOSE_AVAILABLE_CLUSTER.equals(namedCluster)) {
                ((SqoopConfig)this.config).setNamedCluster(null);
            } else if (this.USE_ADVANCED_OPTIONS_CLUSTER.equals(namedCluster) || namedCluster == null) {
                ((SqoopConfig)this.config).setClusterName(null);
            } else {
                ((SqoopConfig)this.config).setNamedCluster(namedCluster);
            }
            this.suppressEventHandling = true;
            try {
                this.firePropertyChange("selectedNamedCluster", null, this.selectedNamedCluster);
            }
            finally {
                this.suppressEventHandling = false;
            }
        }
    }

    private void updateDeleteButton() {
        boolean disabled = ((SqoopConfig)this.config).getCustomArguments().size() == 0;
        XulComponent delete = this.getXulDomContainer().getDocumentRoot().getElementById("delete-button");
        delete.setDisabled(disabled);
    }

    public boolean isSelectedNamedCluster() {
        return this.selectedNamedCluster != null;
    }

    protected String getModeDeckElementId() {
        return "modeDeck";
    }

    protected void beforeInit() {
        this.NO_DATABASE = new DatabaseItem("@@none@@", BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"DatabaseName.ChooseAvailable", (String[])new String[0]));
        this.USE_ADVANCED_OPTIONS = new DatabaseItem("@@advanced@@", BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"DatabaseName.UseAdvancedOptions", (String[])new String[0]));
        this.suppressEventHandling = true;
        this.populateDatabases();
        this.populateNamedClusters();
        this.setModeToggleLabel(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)this.MODE_I18N_STRINGS[0], (String[])new String[0]));
    }

    protected void afterInit() {
        this.setUiMode(this.getConfig().getModeAsEnum());
        this.suppressEventHandling = false;
        this.setSelectedDatabaseConnection(this.createDatabaseItem(this.getConfig().getDatabase()));
        this.initializeNamedClusterSelection();
        this.updateDeleteButton();
    }

    protected String getAdvancedModeDeckElementId() {
        return "advancedModeDeck";
    }

    protected void syncModel() {
        this.advancedArguments.clear();
        this.advancedArguments.addAll(((SqoopConfig)this.config).getAdvancedArgumentsList());
    }

    protected void populateDatabases() {
        this.databaseConnections.clear();
        for (DatabaseMeta dbMeta : this.jobMeta.getDatabases()) {
            if (!((AbstractSqoopJobEntry)this.jobEntry).isDatabaseSupported(dbMeta.getDatabaseInterface().getClass())) continue;
            this.databaseConnections.add((Object)new DatabaseItem(dbMeta.getName()));
        }
        this.updateDatabaseItemsList();
    }

    protected void populateNamedClusters() {
        this.namedClusters.clear();
        try {
            this.namedClusters.addAll((Collection)((AbstractSqoopJobEntry)this.jobEntry).getNamedClusterService().list(this.getMetaStore()));
        }
        catch (MetaStoreException e) {
            ((AbstractSqoopJobEntry)this.jobEntry).logError(e.getMessage(), e);
        }
        this.namedClusters.add((Object)this.CHOOSE_AVAILABLE_CLUSTER);
        this.namedClusters.add((Object)this.USE_ADVANCED_OPTIONS_CLUSTER);
    }

    public void setConnectChanged(String connect) {
        if (!this.suppressEventHandling) {
            if (connect != null) {
                ((SqoopConfig)this.config).copyConnectionInfoToAdvanced();
                this.setSelectedDatabaseConnection(this.USE_ADVANCED_OPTIONS);
            } else {
                this.setSelectedDatabaseConnection(this.NO_DATABASE);
            }
        }
    }

    public void setAdvancedNamedConfiguration(String value) {
        if (!this.suppressEventHandling && value != null) {
            this.setSelectedNamedCluster(this.USE_ADVANCED_OPTIONS_CLUSTER);
        }
    }

    public void setUsernameChanged(String username) {
        if (!this.suppressEventHandling) {
            ((SqoopConfig)this.config).copyConnectionInfoToAdvanced();
            this.setSelectedDatabaseConnection(this.USE_ADVANCED_OPTIONS);
        }
    }

    public void setPasswordChanged(String password) {
        if (!this.suppressEventHandling) {
            ((SqoopConfig)this.config).copyConnectionInfoToAdvanced();
            this.setSelectedDatabaseConnection(this.USE_ADVANCED_OPTIONS);
        }
    }

    public AbstractModelList<DatabaseItem> getDatabaseConnections() {
        return this.databaseConnections;
    }

    public DatabaseItem getSelectedDatabaseConnection() {
        return this.selectedDatabaseConnection;
    }

    protected DatabaseItem createDatabaseItem(String database) {
        return database == null ? (this.getConfig().getConnect() != null ? this.USE_ADVANCED_OPTIONS : this.NO_DATABASE) : new DatabaseItem(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedDatabaseConnection(DatabaseItem selectedDatabaseConnection) {
        if (!this.suppressEventHandling) {
            this.selectedDatabaseConnection = selectedDatabaseConnection;
            DatabaseMeta databaseMeta = this.selectedDatabaseConnection == null ? null : this.jobMeta.findDatabase(this.selectedDatabaseConnection.getName());
            ((AbstractSqoopJobEntry)this.jobEntry).setUsedDbConnection(databaseMeta);
            boolean validDatabaseSelected = databaseMeta != null;
            this.setDatabaseInteractionButtonsDisabled(!validDatabaseSelected);
            this.suppressEventHandling = true;
            try {
                this.updateDatabaseItemsList();
            }
            finally {
                this.suppressEventHandling = false;
            }
            if (validDatabaseSelected) {
                try {
                    this.getConfig().setConnectionInfo(databaseMeta.getName(), databaseMeta.getURL(), databaseMeta.getUsername(), databaseMeta.getPassword());
                }
                catch (KettleDatabaseException ex) {
                    ((AbstractSqoopJobEntry)this.jobEntry).logError(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorConfiguringDatabaseConnection", (String[])new String[0]), ex);
                }
            } else {
                this.getConfig().copyConnectionInfoFromAdvanced();
            }
            this.suppressEventHandling = true;
            try {
                this.firePropertyChange(SELECTED_DATABASE_CONNECTION, null, this.selectedDatabaseConnection);
            }
            finally {
                this.suppressEventHandling = false;
            }
        }
    }

    protected void updateDatabaseItemsList() {
        if (this.selectedDatabaseConnection == null || this.NO_DATABASE.equals(this.selectedDatabaseConnection)) {
            if (!this.databaseConnections.contains((Object)this.NO_DATABASE)) {
                this.databaseConnections.add((Object)this.NO_DATABASE);
            }
        } else if (this.databaseConnections.contains((Object)this.NO_DATABASE)) {
            this.databaseConnections.remove((Object)this.NO_DATABASE);
        }
        if (this.getConfig().getConnectFromAdvanced() != null || this.getConfig().getUsernameFromAdvanced() != null || this.getConfig().getPasswordFromAdvanced() != null) {
            if (!this.databaseConnections.contains((Object)this.USE_ADVANCED_OPTIONS)) {
                this.databaseConnections.add((Object)this.USE_ADVANCED_OPTIONS);
            }
        } else if (this.databaseConnections.contains((Object)this.USE_ADVANCED_OPTIONS)) {
            this.databaseConnections.remove((Object)this.USE_ADVANCED_OPTIONS);
        }
    }

    protected void setDatabaseInteractionButtonsDisabled(boolean b) {
        this.document.getElementById(this.getEditConnectionButtonId()).setDisabled(b);
        this.document.getElementById(this.getBrowseTableButtonId()).setDisabled(b);
    }

    public String getModeToggleLabel() {
        return this.modeToggleLabel;
    }

    public void setModeToggleLabel(String modeToggleLabel) {
        String old = this.modeToggleLabel;
        this.modeToggleLabel = modeToggleLabel;
        this.firePropertyChange(MODE_TOGGLE_LABEL, old, this.modeToggleLabel);
    }

    protected void setModeToggleLabel(JobEntryMode mode) {
        this.setModeToggleLabel(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)this.MODE_I18N_STRINGS[mode.ordinal()], (String[])new String[0]));
    }

    protected DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog == null) {
            this.databaseDialog = new DatabaseDialog(this.getShell());
        }
        return this.databaseDialog;
    }

    public void editConnection() {
        DatabaseMeta current = this.jobMeta.findDatabase(((SqoopConfig)this.config).getDatabase());
        if (current == null) {
            return;
        }
        this.editDatabaseMeta(current, false);
    }

    public void newConnection() {
        this.editDatabaseMeta(new DatabaseMeta(), true);
    }

    protected void editDatabaseMeta(DatabaseMeta database, boolean isNew) {
        database.shareVariablesWith((VariableSpace)this.jobMeta);
        this.getDatabaseDialog().setDatabaseMeta(database);
        if (this.getDatabaseDialog().open() != null) {
            if (isNew) {
                this.jobMeta.addDatabase(this.getDatabaseDialog().getDatabaseMeta());
            }
            this.suppressEventHandling = true;
            try {
                this.populateDatabases();
            }
            finally {
                this.suppressEventHandling = false;
            }
            this.setSelectedDatabaseConnection(this.createDatabaseItem(this.getDatabaseDialog().getDatabaseMeta().getName()));
            ((AbstractSqoopJobEntry)this.jobEntry).setUsedDbConnection(database);
        }
    }

    public String getName() {
        return "controller";
    }

    public String getEditConnectionButtonId() {
        return "editConnectionButton";
    }

    public String getBrowseTableButtonId() {
        return "browseTableButton";
    }

    public String getBrowseSchemaButtonId() {
        return "browseSchemaButton";
    }

    public String getModeToggleLabelElementId() {
        return "mode-toggle-label";
    }

    public String getAdvancedListButtonElementId() {
        return "advanced-list-button";
    }

    public String getAdvancedCommandLineButtonElementId() {
        return "advanced-command-line-button";
    }

    public S getConfig() {
        return (S)((SqoopConfig)this.config);
    }

    public void testSettings() {
        List<String> warnings = ((AbstractSqoopJobEntry)this.jobEntry).getValidationWarnings((SqoopConfig)this.getConfig());
        if (!warnings.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String warning : warnings) {
                sb.append(warning).append("\n");
            }
            this.showErrorDialog(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ValidationError.Dialog.Title", (String[])new String[0]), sb.toString());
            return;
        }
        this.showErrorDialog("Error", "Not Implemented");
    }

    public void toggleMode() {
        XulDeck deck = this.getModeDeck();
        this.setUiMode(deck.getSelectedIndex() == 1 ? JobEntryMode.QUICK_SETUP : this.selectedAdvancedButton.getMode());
    }

    protected void toggleQuickMode(boolean quickMode) {
        XulDeck deck = this.getModeDeck();
        deck.setSelectedIndex(quickMode ? 0 : 1);
        this.setModeToggleLabel(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)this.MODE_I18N_STRINGS[deck.getSelectedIndex()], (String[])new String[0]));
        JobEntryMode oldMode = deck.getSelectedIndex() == 0 ? this.selectedAdvancedButton.getMode() : JobEntryMode.QUICK_SETUP;
        JobEntryMode newMode = JobEntryMode.QUICK_SETUP == oldMode ? this.selectedAdvancedButton.getMode() : JobEntryMode.QUICK_SETUP;
        this.updateUiMode(oldMode, newMode);
    }

    protected void setUiMode(JobEntryMode mode) {
        switch (mode) {
            case QUICK_SETUP: {
                if (this.selectedNamedCluster != null && !this.selectedNamedCluster.equals(this.USE_ADVANCED_OPTIONS_CLUSTER) && !this.suppressEventHandling) {
                    ((SqoopConfig)this.config).setNamedCluster(this.selectedNamedCluster);
                }
                this.toggleQuickMode(true);
                break;
            }
            case ADVANCED_LIST: {
                this.setSelectedAdvancedButton(AdvancedButton.LIST);
                this.toggleQuickMode(false);
                break;
            }
            case ADVANCED_COMMAND_LINE: {
                this.setSelectedAdvancedButton(AdvancedButton.COMMAND_LINE);
                this.toggleQuickMode(false);
                break;
            }
            default: {
                throw new RuntimeException("unsupported mode: " + mode);
            }
        }
    }

    protected void updateUiMode(JobEntryMode oldMode, JobEntryMode newMode) {
        if (this.suppressEventHandling) {
            return;
        }
        if (JobEntryMode.ADVANCED_COMMAND_LINE.equals((Object)oldMode)) {
            if (!this.syncCommandLineToConfig()) {
                this.suppressEventHandling = true;
                try {
                    this.setUiMode(JobEntryMode.ADVANCED_COMMAND_LINE);
                }
                finally {
                    this.suppressEventHandling = false;
                }
                return;
            }
        } else if (JobEntryMode.ADVANCED_COMMAND_LINE.equals((Object)newMode)) {
            this.getConfig().setCommandLine(SqoopUtils.generateCommandLineString((SqoopConfig)this.getConfig(), null));
        }
        if (JobEntryMode.ADVANCED_LIST.equals((Object)newMode)) {
            this.syncModel();
        }
        this.getConfig().setMode(this.getMode().name());
    }

    private JobEntryMode getMode() {
        XulDeck modeDeck = this.getModeDeck();
        XulDeck advancedModeDeck = this.getAdvancedModeDeck();
        if (modeDeck.getSelectedIndex() == 0) {
            return JobEntryMode.QUICK_SETUP;
        }
        for (AdvancedButton b : AdvancedButton.values()) {
            if (b.getDeckIndex() != advancedModeDeck.getSelectedIndex()) continue;
            return b.getMode();
        }
        throw new RuntimeException("unknown UI mode");
    }

    protected boolean syncCommandLineToConfig() {
        try {
            SqoopUtils.configureFromCommandLine((SqoopConfig)this.getConfig(), this.getConfig().getCommandLine(), null);
            return true;
        }
        catch (Exception ex) {
            this.showErrorDialog(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorConfiguringFromCommandLine", (String[])new String[0]), ex);
            return false;
        }
    }

    public void setSelectedAdvancedButton(AdvancedButton button) {
        AdvancedButton old = this.selectedAdvancedButton;
        this.selectedAdvancedButton = button;
        switch (button) {
            case LIST: {
                XulButton advancedList = this.getAdvancedListButton();
                advancedList.setSelected(true);
                this.getAdvancedCommandLineButton().setSelected(false);
                break;
            }
            case COMMAND_LINE: {
                this.getAdvancedListButton().setSelected(false);
                this.getAdvancedCommandLineButton().setSelected(true);
                break;
            }
            default: {
                throw new RuntimeException("Unknown button type: " + (Object)((Object)button));
            }
        }
        this.toggleAdvancedMode(button);
        this.updateUiMode(old == null ? null : old.getMode(), button.getMode());
    }

    protected void toggleAdvancedMode(AdvancedButton button) {
        this.getAdvancedModeDeck().setSelectedIndex(button.getDeckIndex());
    }

    public XulButton getAdvancedListButton() {
        return this.getButton(this.getAdvancedListButtonElementId());
    }

    public XulButton getAdvancedCommandLineButton() {
        return this.getButton(this.getAdvancedCommandLineButtonElementId());
    }

    protected XulDeck getModeDeck() {
        return (XulDeck)this.getXulDomContainer().getDocumentRoot().getElementById(this.getModeDeckElementId());
    }

    protected XulDeck getAdvancedModeDeck() {
        return (XulDeck)this.getXulDomContainer().getDocumentRoot().getElementById(this.getAdvancedModeDeckElementId());
    }

    protected XulButton getButton(String elementId) {
        return (XulButton)this.getXulDomContainer().getDocumentRoot().getElementById(elementId);
    }

    public void advancedListButtonClicked() {
        this.setSelectedAdvancedButton(AdvancedButton.LIST);
    }

    public void advancedCommandLineButtonClicked() {
        this.setSelectedAdvancedButton(AdvancedButton.COMMAND_LINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browseSchema() {
        DatabaseMeta databaseMeta = this.jobMeta.findDatabase(this.getConfig().getDatabase());
        Database database = new Database(this.jobMeta.getParent(), databaseMeta);
        try {
            database.connect();
            String[] schemas = database.getSchemas();
            if (null != schemas && schemas.length > 0) {
                schemas = Const.sortStrings((String[])schemas);
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.getShell(), schemas, BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"AvailableSchemas.Title", (String[])new String[0]), BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"AvailableSchemas.Message", (String[])new String[0]));
                String schema = dialog.open();
                if (schema != null) {
                    this.getConfig().setSchema(schema);
                }
            } else {
                this.showErrorDialog(BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"NoSchema.Error", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            this.showErrorDialog(BaseMessages.getString((String)BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"System.Dialog.Error.Title", (String[])new String[0])), BaseMessages.getString((String)BaseMessages.getString(AbstractSqoopJobEntry.class, (String)"ErrorRetrievingSchemas", (String[])new String[0])), e);
        }
        finally {
            database.disconnect();
        }
    }

    public void browseTable() {
        DatabaseMeta databaseMeta = this.jobMeta.findDatabase(this.getConfig().getDatabase());
        DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.getShell(), 0, databaseMeta, this.jobMeta.getDatabases());
        std.setSelectedSchemaAndTable(this.getConfig().getSchema(), this.getConfig().getTable());
        if (std.open()) {
            this.getConfig().setSchema(std.getSchemaName());
            this.getConfig().setTable(std.getTableName());
        }
    }

    protected FileObject getInitialFile(String path) throws FileSystemException {
        String fileName;
        NamedCluster namedCluster;
        if (Const.isEmpty((String)path)) {
            path = "/";
        }
        if ((namedCluster = ((AbstractSqoopJobEntry)this.jobEntry).getNamedClusterService().getNamedClusterByName(this.selectedNamedCluster.getName(), this.getMetaStore())) == null) {
            return null;
        }
        path = namedCluster.processURLsubstitution(path, this.getMetaStore(), (VariableSpace)this.jobEntry);
        FileObject initialFile = null;
        if (path != null && (fileName = ((AbstractSqoopJobEntry)this.jobEntry).environmentSubstitute(path)) != null && !fileName.equals("")) {
            try {
                initialFile = KettleVFS.getFileObject((String)fileName);
                if (namedCluster.isMapr() ? !initialFile.getName().getScheme().startsWith("maprfs") : !initialFile.getName().getScheme().startsWith("hdfs")) {
                    return null;
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return initialFile;
    }

    private IMetaStore getMetaStore() {
        return Spoon.getInstance().getMetaStore();
    }

    protected void extractNamedClusterFromVfsFileChooser() {
        VfsFileChooserDialog dialog = Spoon.getInstance().getVfsFileChooserDialog(null, null);
        CustomVfsUiPanel currentPanel = dialog.getCurrentPanel();
        if (currentPanel != null && currentPanel instanceof HadoopVfsFileChooserDialog) {
            HadoopVfsFileChooserDialog hadoopVfsFileChooserDialog = (HadoopVfsFileChooserDialog)currentPanel;
            this.selectedNamedCluster = hadoopVfsFileChooserDialog.getNamedClusterWidget().getSelectedNamedCluster();
        }
        if (this.selectedNamedCluster != null) {
            this.setSelectedNamedCluster(this.selectedNamedCluster);
        }
    }

    public void newCustomArgument() {
        ((SqoopConfig)this.config).getCustomArguments().add((Object)new PropertyEntry());
        this.updateDeleteButton();
    }

    public void deleteCustomArgument() {
        XulTree customVariablesTree = (XulTree)this.container.getDocumentRoot().getElementById("custom-table");
        Collection selectedItems = customVariablesTree.getSelectedItems();
        for (PropertyEntry pe : selectedItems) {
            try {
                this.getConfig().getCustomArguments().remove((Object)pe);
            }
            catch (Exception e) {
                customVariablesTree.setElements(this.getConfig().getCustomArguments());
            }
        }
        this.updateDeleteButton();
    }

    public void newNamedCluster(String stepName) {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(stepName);
        Shell shell = (Shell)xulDialog.getRootObject();
        String newNamedCluster = this.ncDelegate.newNamedCluster((VariableSpace)this.jobMeta, null, shell);
        if (newNamedCluster != null) {
            this.populateNamedClusters();
            this.selectNamedCluster(newNamedCluster);
        }
    }

    public void editNamedCluster(String stepName) {
        XulDialog xulDialog;
        Shell shell;
        String clusterName;
        if (this.isSelectedNamedCluster() && (clusterName = this.ncDelegate.editNamedCluster(null, this.selectedNamedCluster, shell = (Shell)(xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(stepName)).getRootObject())) != null) {
            this.populateNamedClusters();
            this.selectNamedCluster(clusterName);
        }
    }

    public void selectNamedCluster(String configName) {
        XulMenuList namedConfigMenu = (XulMenuList)this.container.getDocumentRoot().getElementById("named-clusters");
        for (NamedCluster nc : this.getNamedClusters()) {
            if (configName == null || !configName.equals(nc.getName())) continue;
            namedConfigMenu.setSelectedItem((Object)nc);
        }
    }

    protected static enum AdvancedButton {
        LIST(0, JobEntryMode.ADVANCED_LIST),
        COMMAND_LINE(1, JobEntryMode.ADVANCED_COMMAND_LINE);

        private int deckIndex;
        private JobEntryMode mode;

        private AdvancedButton(int deckIndex, JobEntryMode mode) {
            this.deckIndex = deckIndex;
            this.mode = mode;
        }

        public int getDeckIndex() {
            return this.deckIndex;
        }

        public JobEntryMode getMode() {
            return this.mode;
        }
    }
}

