/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.mapr.AbstractHTable;
import org.apache.hadoop.hbase.client.mapr.AbstractMapRClusterConnection;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HRegionLocator
implements RegionLocator {
    private static final Log LOG = LogFactory.getLog(HRegionLocator.class);
    private final TableName tableName;
    private final ClusterConnection connection;
    private AbstractHTable maprTable_ = null;

    public HRegionLocator(TableName tableName, ClusterConnection connection) {
        this.connection = connection;
        this.tableName = tableName;
        if (BaseTableMappingRules.isInHBaseService()) {
            return;
        }
        if (connection instanceof AbstractMapRClusterConnection) {
            AbstractMapRClusterConnection cfr_ignored_0 = (AbstractMapRClusterConnection)connection;
            this.maprTable_ = AbstractMapRClusterConnection.createAbstractMapRTable(connection.getConfiguration(), tableName);
            if (this.maprTable_ == null) {
                throw new IllegalArgumentException("Could not find table " + this.tableName + " through MapRClusterConnection.");
            }
            return;
        }
        if (connection instanceof ConnectionManager.HConnectionImplementation) {
            BaseTableMappingRules tableMappingRule = null;
            try {
                tableMappingRule = TableMappingRulesFactory.create(connection.getConfiguration());
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Could not get tableMappingRule for table " + this.tableName + " through HConnection. Reason:" + e.getStackTrace());
            }
            if (tableMappingRule != null && tableMappingRule.isMapRTable(tableName)) {
                this.maprTable_ = HTable.createMapRTable(connection.getConfiguration(), tableName);
            }
            return;
        }
        LOG.warn((Object)("Unknown connection type " + connection.getClass().getName()));
    }

    @Override
    public void close() throws IOException {
        if (this.maprTable_ != null) {
            this.maprTable_.close();
            this.maprTable_ = null;
            return;
        }
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        if (this.maprTable_ != null) {
            return this.maprTable_.getRegionLocation(row);
        }
        return this.connection.getRegionLocation(this.tableName, row, false);
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        if (this.maprTable_ != null) {
            return this.maprTable_.getRegionLocation(row, reload);
        }
        return this.connection.getRegionLocation(this.tableName, row, reload);
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        NavigableMap<HRegionInfo, ServerName> locations = null;
        locations = this.maprTable_ != null ? this.maprTable_.getRegionLocations() : MetaScanner.allTableRegions(this.connection, this.getName());
        ArrayList<HRegionLocation> regions = new ArrayList<HRegionLocation>(locations.size());
        for (Map.Entry entry : locations.entrySet()) {
            regions.add(new HRegionLocation((HRegionInfo)entry.getKey(), (ServerName)entry.getValue()));
        }
        return regions;
    }

    @Override
    public byte[][] getStartKeys() throws IOException {
        if (this.maprTable_ != null) {
            return this.maprTable_.getStartKeys();
        }
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    @Override
    public byte[][] getEndKeys() throws IOException {
        if (this.maprTable_ != null) {
            return this.maprTable_.getEndKeys();
        }
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    @Override
    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        if (this.maprTable_ != null) {
            return this.maprTable_.getStartEndKeys();
        }
        return this.getStartEndKeys(this.listRegionLocations());
    }

    @VisibleForTesting
    Pair<byte[][], byte[][]> getStartEndKeys(List<RegionLocations> regions) {
        if (this.maprTable_ != null) {
            throw new UnsupportedOperationException("This is not a public API, and should not be called for MapRDB");
        }
        byte[][] startKeyList = new byte[regions.size()][];
        byte[][] endKeyList = new byte[regions.size()][];
        for (int i = 0; i < regions.size(); ++i) {
            HRegionInfo region = regions.get(i).getRegionLocation().getRegionInfo();
            startKeyList[i] = region.getStartKey();
            endKeyList[i] = region.getEndKey();
        }
        return new Pair((Object)startKeyList, (Object)endKeyList);
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @VisibleForTesting
    List<RegionLocations> listRegionLocations() throws IOException {
        if (this.maprTable_ != null) {
            throw new UnsupportedOperationException("This is not a public API, and should not be called for MapRDB");
        }
        return MetaScanner.listTableRegionLocations(this.getConfiguration(), this.connection, this.getName());
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    @Override
    public boolean isMapRTable() {
        return this.maprTable_ != null;
    }
}

