/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.mapr;

import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Pair;

public abstract class AbstractHBaseAdmin
implements Closeable {
    private static final Log LOG = LogFactory.getLog(AbstractHBaseAdmin.class);

    public void setUser(User user) {
        LOG.debug((Object)"setUser() called with MapR Table without impersonation support.");
    }

    @Deprecated
    public boolean isMasterRunning() {
        LOG.warn((Object)"isMasterRunning() called for a MapR Table, returning true.");
        return true;
    }

    public abstract boolean tableExists(String var1) throws IOException;

    public abstract HTableDescriptor[] listTables() throws IOException;

    public abstract TableName[] listTableNames() throws IOException;

    public abstract HTableDescriptor[] listTables(String var1) throws IOException;

    public String[] getTableNames() throws IOException {
        return this.getTableNames((String)null);
    }

    public String[] getTableNames(Pattern pattern) throws IOException {
        return this.getTableNames(pattern.pattern());
    }

    public String[] getTableNames(String regex) throws IOException {
        ArrayList<String> tables = new ArrayList<String>();
        for (HTableDescriptor desc : this.listTables(regex)) {
            tables.add(desc.getNameAsString());
        }
        return tables.toArray(new String[tables.size()]);
    }

    public abstract HTableDescriptor getTableDescriptor(String var1) throws TableNotFoundException, IOException;

    public abstract void createTable(HTableDescriptor var1, byte[][] var2) throws IOException;

    public abstract void deleteTable(String var1) throws IOException;

    public abstract HTableDescriptor[] deleteTables(String var1) throws IOException;

    public abstract void enableTable(String var1) throws IOException;

    public abstract HTableDescriptor[] enableTables(String var1) throws IOException;

    public abstract void disableTable(String var1) throws IOException;

    public abstract HTableDescriptor[] disableTables(String var1) throws IOException;

    public abstract boolean isTableEnabled(String var1) throws IOException;

    public abstract boolean isTableDisabled(String var1) throws IOException;

    public abstract boolean isTableAvailable(String var1) throws IOException;

    public abstract boolean isTableAvailable(String var1, byte[][] var2) throws IOException;

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        LOG.warn((Object)"getAlterStatus() called for a MapR Table, return Pair(0,0).");
        return new Pair((Object)0, (Object)0);
    }

    public abstract void addColumn(String var1, HColumnDescriptor var2) throws IOException;

    public abstract void deleteColumn(String var1, String var2) throws IOException;

    public abstract void modifyColumn(String var1, HColumnDescriptor var2) throws IOException;

    public abstract void modifyTable(String var1, HTableDescriptor var2) throws IOException;

    public abstract List<HRegionInfo> getTableRegions(byte[] var1) throws IOException;

    @Override
    public abstract void close() throws IOException;

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        LOG.warn((Object)"closeRegion() called for a MapR Table, silently ignoring.");
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        throw new UnsupportedOperationException("closeRegionWithEncodedRegionName for MapR is unsupported.");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        LOG.warn((Object)"closeRegion() called for a MapR Table, silently ignoring.");
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        throw new UnsupportedOperationException("getOnlineRegions for MapR is unsupported.");
    }

    public void flush(byte[] tableNameOrRegionName) throws IOException {
        LOG.warn((Object)"flush() called for a MapR Table, silently ignoring.");
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        throw new UnsupportedOperationException("createNamespace for a MapR is unsupported.");
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        throw new UnsupportedOperationException("modifyNamespace for a MapR is unsupported.");
    }

    public void deleteNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("deleteNamespace for a MapR is unsupported.");
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws IOException {
        throw new UnsupportedOperationException("getNamespaceDescriptor for a MapR is unsupported.");
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        throw new UnsupportedOperationException("listNamespaceDescriptors for a MapR is unsupported.");
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("listTableDescriptorsByNamespace for a MapR is unsupported.");
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        throw new UnsupportedOperationException("listTableNamesByNamespace for a MapR is unsupported.");
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily, boolean major) throws IOException {
        LOG.warn((Object)"compact() called for a MapR Table, silently ignoring.");
    }

    public void compact(ServerName sn, HRegionInfo hri, boolean major, byte[] family) throws IOException {
        LOG.warn((Object)"compact() called for a MapR Table, silently ignoring.");
    }

    public void move(byte[] encodedRegionName, byte[] destServerName) throws UnknownRegionException, MasterNotRunningException, ZooKeeperConnectionException {
        LOG.warn((Object)"move() called for a MapR Table, silently ignoring.");
    }

    public void offline(byte[] regionName) throws ZooKeeperConnectionException {
        LOG.warn((Object)"offline() called for a MapR Table, silently ignoring.");
    }

    public boolean enableCatalogJanitor(boolean enable) throws ServiceException, MasterNotRunningException {
        LOG.warn((Object)"enableCatalogJanitor() called for MapR, silently ignoring.");
        return false;
    }

    public int runCatalogScan() throws ServiceException, MasterNotRunningException {
        LOG.warn((Object)"runCatalogScan() called for MapR, silently ignoring.");
        return 0;
    }

    public boolean isCatalogJanitorEnabled() throws ServiceException, MasterNotRunningException {
        LOG.warn((Object)"isCatalogJanitorEnabled() called for MapR, silently ignoring.");
        return false;
    }

    public void assign(byte[] regionName) throws IOException {
        LOG.warn((Object)"assign() called for a MapR Table, silently ignoring.");
    }

    public void unassign(byte[] regionName, boolean force) throws IOException {
        LOG.warn((Object)"unassign() called for a MapR Table, silently ignoring.");
    }

    public void mergeRegions(byte[] encodedNameOfRegionA, byte[] encodedNameOfRegionB, boolean forcible) throws IOException {
        throw new UnsupportedOperationException("mergeRegions for a MapR is unsupported.");
    }

    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        LOG.warn((Object)"split() called for a MapR Table, silently ignoring.");
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        byte[][] splitKeys = null;
        if (preserveSplits) {
            List<HRegionInfo> regions = this.getTableRegions(tableName.getQualifier());
            Collections.sort(regions);
            ArrayList<byte[]> splitKeyList = new ArrayList<byte[]>(regions.size());
            for (HRegionInfo region : regions) {
                if (region.getEndKey() == null || region.getEndKey().length == 0) continue;
                splitKeyList.add(region.getEndKey());
            }
            splitKeys = (byte[][])splitKeyList.toArray((T[])new byte[splitKeyList.size()][]);
        }
        String tablePath = tableName.getAliasAsString();
        HTableDescriptor htd = this.getTableDescriptor(tablePath);
        this.deleteTable(tablePath);
        htd.remove("DISABLED");
        this.createTable(htd, splitKeys);
    }

    public abstract TableName[] listTableNames(String var1) throws IOException;

    public synchronized void shutdown() throws IOException {
        LOG.warn((Object)"shutdown() called for a MapR cluster, silently ignoring.");
    }

    public synchronized void stopMaster() throws IOException {
        LOG.warn((Object)"stopMaster() called for a MapR cluster, silently ignoring.");
    }

    public synchronized void stopRegionServer(String hostnamePort) throws IOException {
        LOG.warn((Object)"stopRegionServer() called for a MapR cluster, silently ignoring.");
    }

    public ClusterStatus getClusterStatus() throws IOException {
        LOG.warn((Object)"getClusterStatus() called for a MapR cluster, return null.");
        return null;
    }

    @Deprecated
    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        LOG.warn((Object)"rollHLogWriter() called for a MapR cluster, returning null.");
        return null;
    }

    public synchronized void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        LOG.warn((Object)"rollHLogWriter() called for a MapR cluster, silently ignoring.");
    }

    public String[] getMasterCoprocessors() {
        LOG.warn((Object)"getMasterCoprocessors() called for a MapR cluster, returning empty.");
        return new String[0];
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        LOG.warn((Object)"getCompactionState() called for a MapR cluster, returning CompactionState.NONE.");
        return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        LOG.warn((Object)"getCompactionStateForRegion() called for a MapR cluster, returning CompactionState.NONE.");
        return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
    }

    public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot for a MapR is unsupported.");
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot for a MapR is unsupported.");
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        throw new UnsupportedOperationException("takeSnapshotAsync for a MapR is unsupported.");
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        throw new UnsupportedOperationException("isSnapshotFinished for a MapR is unsupported.");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        throw new UnsupportedOperationException("cloneSnapshot for a MapR is unsupported.");
    }

    public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet for a MapR is unsupported.");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("execProcedure for a MapR is unsupported.");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        throw new UnsupportedOperationException("isProcedureFinished for a MapR is unsupported.");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        throw new UnsupportedOperationException("listSnapshots for a MapR is unsupported.");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("listSnapshots for a MapR is unsupported.");
    }

    public void deleteSnapshot(String snapshotName) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshot for a MapR is unsupported.");
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("deleteSnapshot for a MapR is unsupported.");
    }

    public void setQuota(QuotaSettings quota) throws IOException {
        throw new UnsupportedOperationException("setQuota is not supported for MapR.");
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
        throw new UnsupportedOperationException("getQuotaRetriever is not supported for MapR.");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService is not supported for MapR.");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName sn) {
        throw new UnsupportedOperationException("coprocessorService is not supported for MapR.");
    }

    public void updateConfiguration(ServerName server) throws IOException {
        LOG.warn((Object)"updateConfiguration() called for a MapR Table, silently ignoring.");
    }

    public void updateConfiguration() throws IOException {
        LOG.warn((Object)"updateConfiguration() called for a MapR Table, silently ignoring.");
    }

    public int getMasterInfoPort() throws IOException {
        LOG.warn((Object)"getMasterInfoPort() called for a MapR Table, return 0.");
        return 0;
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) throws IOException {
        LOG.warn((Object)"getMasterInfoPort() called for a MapR Table, return 0.");
        return 0L;
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        LOG.warn((Object)"getMasterInfoPort() called for a MapR Table, return 0.");
        return 0L;
    }
}

