/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;

@InterfaceAudience.Private
public class FSMapRUtils
extends FSUtils {
    private static final Log LOG = LogFactory.getLog(FSMapRUtils.class);
    private static Class<?> MapRFileSystemClass;

    @Override
    public boolean isSameFileSystem(Configuration conf, FileSystem srcFs, FileSystem desFs) {
        boolean desIsMapRFs;
        boolean srcIsMapRFs = MapRFileSystemClass != null && MapRFileSystemClass.isAssignableFrom(srcFs.getClass());
        boolean bl = desIsMapRFs = MapRFileSystemClass != null && MapRFileSystemClass.isAssignableFrom(desFs.getClass());
        if (srcIsMapRFs && desIsMapRFs) {
            LOG.info((Object)("srcFs " + srcFs.getUri() + " is maprfs and desFs " + desFs.getUri() + " is maprfs."));
            return true;
        }
        if (srcIsMapRFs && !desIsMapRFs) {
            LOG.warn((Object)("srcFs " + srcFs.getUri() + " is maprfs but desFs " + desFs.getUri() + " is NOT maprfs."));
            return false;
        }
        if (!srcIsMapRFs && desIsMapRFs) {
            LOG.warn((Object)("srcFs " + srcFs.getUri() + " is NOT maprfs but desFs " + desFs.getUri() + " is maprfs."));
            return false;
        }
        LOG.error((Object)("This should NOT happen. both srcFs " + srcFs.getUri() + " and desFs " + desFs.getUri() + " are NOT maprfs."));
        return false;
    }

    @Override
    public void recoverFileLease(FileSystem fs, Path p, Configuration conf, CancelableProgressable reporter) throws IOException {
        LOG.info((Object)("Recovering file " + p.toString() + " by changing permission to readonly"));
        FsPermission roPerm = new FsPermission(292);
        fs.setPermission(p, roPerm);
    }

    static {
        try {
            MapRFileSystemClass = Class.forName("com.mapr.fs.MapRFileSystem");
        }
        catch (ClassNotFoundException e) {
            MapRFileSystemClass = null;
        }
    }
}

