/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.OperationType;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.Operation;
import org.apache.hive.service.cli.session.HiveSession;

public abstract class MetadataOperation
extends Operation {
    protected static final String DEFAULT_HIVE_CATALOG = "";
    protected static TableSchema RESULT_SET_SCHEMA;
    private static final char SEARCH_STRING_ESCAPE = '\\';

    protected MetadataOperation(HiveSession parentSession, OperationType opType) {
        super(parentSession, opType, false);
        this.setHasResultSet(true);
    }

    @Override
    public void close() throws HiveSQLException {
        this.setState(OperationState.CLOSED);
        this.cleanupOperationLog();
    }

    protected String convertIdentifierPattern(String pattern, boolean datanucleusFormat) {
        if (pattern == null) {
            return this.convertPattern("%", true);
        }
        return this.convertPattern(pattern, datanucleusFormat);
    }

    protected String convertSchemaPattern(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return this.convertPattern("%", true);
        }
        return this.convertPattern(pattern, true);
    }

    private String convertPattern(String pattern, boolean datanucleusFormat) {
        String wStr = datanucleusFormat ? "*" : ".*";
        pattern = this.replaceAll(pattern, "([^\\\\])%", "$1" + wStr);
        pattern = this.replaceAll(pattern, "\\\\%", "%");
        pattern = this.replaceAll(pattern, "^%", wStr);
        pattern = this.replaceAll(pattern, "([^\\\\])_", "$1.");
        pattern = this.replaceAll(pattern, "\\\\_", "_");
        pattern = this.replaceAll(pattern, "^_", ".");
        return pattern;
    }

    private String replaceAll(String input, String pattern, String replace) {
        String replaced;
        while (!(replaced = input.replaceAll(pattern, replace)).equals(input)) {
            input = replaced;
        }
        return replaced;
    }

    @Override
    public void cancel(OperationState stateAfterCancel) throws HiveSQLException {
        throw new UnsupportedOperationException("MetadataOperation.cancel()");
    }
}

