/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.pentaho.plugin.jfreereport.reportcharts.StackedCategoricalChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.backport.FormattedCategoryAxis;
import org.pentaho.plugin.jfreereport.reportcharts.backport.StackedAreaRenderer;

public class AreaChartExpression
extends StackedCategoricalChartExpression {
    private static final long serialVersionUID = -2663954070786799503L;
    private boolean renderAsPercentages;

    public boolean isRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean renderAsPercentages) {
        this.renderAsPercentages = renderAsPercentages;
    }

    @Override
    protected JFreeChart computeCategoryChart(CategoryDataset categoryDataset) {
        JFreeChart chart;
        PlotOrientation orientation = this.computePlotOrientation();
        if (this.isStacked()) {
            chart = this.createStackedAreaChart(this.computeTitle(), this.getCategoryAxisLabel(), this.getValueAxisLabel(), categoryDataset, orientation, this.isShowLegend(), false, false);
        } else {
            chart = ChartFactory.createAreaChart((String)this.computeTitle(), (String)this.getCategoryAxisLabel(), (String)this.getValueAxisLabel(), (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)this.isShowLegend(), (boolean)false, (boolean)false);
            chart.getCategoryPlot().setDomainAxis((CategoryAxis)new FormattedCategoryAxis(this.getCategoryAxisLabel(), this.getCategoricalAxisMessageFormat(), this.getRuntime().getResourceBundleFactory().getLocale()));
        }
        this.configureLogarithmicAxis(chart.getCategoryPlot());
        return chart;
    }

    private JFreeChart createStackedAreaChart(String title, String categoryAxisLabel, String valueAxisLabel, CategoryDataset dataset, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        if (orientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        FormattedCategoryAxis categoryAxis = new FormattedCategoryAxis(categoryAxisLabel, this.getCategoricalAxisMessageFormat(), this.getRuntime().getResourceBundleFactory().getLocale());
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        StackedAreaRenderer renderer = new StackedAreaRenderer();
        if (tooltips) {
            renderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        }
        if (urls) {
            renderer.setBaseItemURLGenerator((CategoryURLGenerator)new StandardCategoryURLGenerator());
        }
        CategoryPlot plot = new CategoryPlot(dataset, (CategoryAxis)categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(orientation);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        super.configureChart(chart);
        CategoryPlot cpl = chart.getCategoryPlot();
        cpl.getDomainAxis().setCategoryMargin(0.0);
        CategoryItemRenderer renderer = cpl.getRenderer();
        if (this.isStacked() && this.renderAsPercentages && renderer instanceof StackedAreaRenderer) {
            StackedAreaRenderer sbr = (StackedAreaRenderer)renderer;
            sbr.setRenderAsPercentages(true);
        }
    }
}

