/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.LogarithmicAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.pentaho.plugin.jfreereport.reportcharts.LogCategoryItemLabelGenerator;

public class ScalingLogarithmicAxis
extends LogarithmicAxis {
    private static final long serialVersionUID = 1L;
    private int ticksVertical = -1;

    public ScalingLogarithmicAxis(String label) {
        super(label);
    }

    public void autoAdjustRange() {
        super.autoAdjustRange();
        if (this.getPlot() instanceof ValueAxisPlot) {
            Range range = this.getRange();
            this.setRange(new Range(range.getLowerBound() * 10.0, range.getUpperBound() * 10.0), false, false);
            this.setupSmallLogFlag();
        }
    }

    protected List refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        int iEndCount;
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        double lowerBoundVal = this.getRange().getLowerBound();
        if (this.smallLogFlag && lowerBoundVal < 1.0E-100) {
            lowerBoundVal = 1.0E-100;
        }
        double upperBoundVal = this.getRange().getUpperBound();
        int iBegCount = (int)Math.rint(this.switchedLog10(lowerBoundVal));
        if (iBegCount == (iEndCount = (int)Math.rint(this.switchedLog10(upperBoundVal))) && iBegCount > 0 && Math.pow(10.0, iBegCount) > lowerBoundVal) {
            --iBegCount;
        }
        boolean zeroTickFlag = false;
        int[] intervals = new int[]{10, 10, 10, 10, 10, 5, 5, 5, 3, 3};
        for (int i = iBegCount; i <= iEndCount; ++i) {
            int jEndCount = this.getTicksVertical();
            if (jEndCount == -1) {
                int n = jEndCount = Math.abs(iEndCount - iBegCount) < 10 ? intervals[iEndCount - iBegCount] : 1;
            }
            if (i == iEndCount) {
                jEndCount = 1;
            }
            for (int j = 0; j < jEndCount; ++j) {
                TextAnchor rotationAnchor;
                TextAnchor anchor;
                NumberFormat format;
                String tickLabel;
                double tickVal;
                if (this.smallLogFlag) {
                    tickVal = Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j;
                    if (j == 0) {
                        if (this.log10TickLabelsFlag) {
                            tickLabel = "10^" + i;
                        } else if (this.expTickLabelsFlag) {
                            tickLabel = "1e" + i;
                        } else if (i >= 0) {
                            format = this.getNumberFormatOverride();
                            tickLabel = format != null ? format.format(tickVal) : LogCategoryItemLabelGenerator.formatValue(new Double(tickVal));
                        } else {
                            this.numberFormatterObj.setMaximumFractionDigits(-i);
                            tickLabel = this.numberFormatterObj.format(tickVal);
                        }
                    } else {
                        tickLabel = "";
                    }
                } else {
                    if (zeroTickFlag) {
                        --j;
                    }
                    double d = i >= 0 ? Math.pow(10.0, i) + Math.pow(10.0, i) * (double)j : (tickVal = j == 0 ? -Math.pow(10.0, -i) : -(Math.pow(10.0, -i) - Math.pow(10.0, -i - 1) * (double)(9 - j)));
                    if (j == 0) {
                        if (!zeroTickFlag) {
                            if (i > iBegCount && i < iEndCount && Math.abs(tickVal - 1.0) < 1.0E-4) {
                                tickVal = 0.0;
                                zeroTickFlag = true;
                                tickLabel = "0";
                            } else {
                                tickLabel = this.log10TickLabelsFlag ? (i < 0 ? "-" : "") + "10^" + Math.abs(i) : (this.expTickLabelsFlag ? (i < 0 ? "-" : "") + "1e" + Math.abs(i) : ((format = this.getNumberFormatOverride()) != null ? format.format(tickVal) : LogCategoryItemLabelGenerator.formatValue(new Double(tickVal))));
                            }
                        } else {
                            tickLabel = "";
                            zeroTickFlag = false;
                        }
                    } else {
                        tickLabel = "";
                        zeroTickFlag = false;
                    }
                }
                if (tickVal > upperBoundVal) {
                    return ticks;
                }
                if (!(tickVal >= lowerBoundVal - 1.0E-100)) continue;
                double angle = 0.0;
                if (this.isVerticalTickLabels()) {
                    if (edge == RectangleEdge.LEFT) {
                        anchor = TextAnchor.BOTTOM_CENTER;
                        rotationAnchor = TextAnchor.BOTTOM_CENTER;
                        angle = -1.5707963267948966;
                    } else {
                        anchor = TextAnchor.BOTTOM_CENTER;
                        rotationAnchor = TextAnchor.BOTTOM_CENTER;
                        angle = 1.5707963267948966;
                    }
                } else if (edge == RectangleEdge.LEFT) {
                    anchor = TextAnchor.CENTER_RIGHT;
                    rotationAnchor = TextAnchor.CENTER_RIGHT;
                } else {
                    anchor = TextAnchor.CENTER_LEFT;
                    rotationAnchor = TextAnchor.CENTER_LEFT;
                }
                ticks.add(new NumberTick((Number)new Double(tickVal), tickLabel, anchor, rotationAnchor, angle));
            }
        }
        return ticks;
    }

    public void setTicksVertical(int ticksVertical) {
        this.ticksVertical = ticksVertical;
    }

    public int getTicksVertical() {
        return this.ticksVertical;
    }
}

