/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.backport;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Locale;
import org.jfree.chart.axis.NumberTickUnit;
import org.pentaho.reporting.libraries.formatting.FastDecimalFormat;

public class FastNumberTickUnit
extends NumberTickUnit
implements Serializable {
    private static final long serialVersionUID = 3849459506627654442L;
    private FastDecimalFormat formatter;

    public FastNumberTickUnit(double size) {
        this(size, new FastDecimalFormat(0, Locale.getDefault()));
    }

    public FastNumberTickUnit(double size, FastDecimalFormat formatter) {
        super(size);
        if (formatter == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.formatter = formatter;
    }

    public FastNumberTickUnit(double size, FastDecimalFormat formatter, int minorTickCount) {
        super(size, NumberFormat.getInstance(), minorTickCount);
        if (formatter == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.formatter = formatter;
    }

    public String valueToString(double value) {
        return this.formatter.format((Object)new BigDecimal(value));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FastNumberTickUnit)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        FastNumberTickUnit that = (FastNumberTickUnit)obj;
        return this.formatter.equals((Object)that.formatter);
    }

    public String toString() {
        return "[size=" + this.valueToString(this.getSize()) + "]";
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.formatter != null ? this.formatter.hashCode() : 0);
        return result;
    }
}

