/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jfree.data.general.Dataset;
import org.pentaho.plugin.jfreereport.reportcharts.CollectorFunctionResult;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.states.ReportStateKey;
import org.pentaho.reporting.engine.classic.core.util.Sequence;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public abstract class AbstractCollectorFunction
extends AbstractFunction {
    private ArrayList<String> seriesNames;
    private ArrayList<String> seriesColumns;
    private HashMap<ReportStateKey, Sequence<Dataset>> results = new HashMap();
    private String summaryGroup;
    private String resetGroup;
    private Boolean autoGenerateMissingSeriesNames;
    private transient Sequence<Dataset> result;
    private transient ReportStateKey globalStateKey;
    private transient ReportStateKey groupStateKey;
    private String crosstabFilterGroup;
    private transient int lastGroupSequenceNumber;

    public AbstractCollectorFunction() {
        this.seriesColumns = new ArrayList();
        this.seriesNames = new ArrayList();
    }

    public String getCrosstabFilterGroup() {
        return this.crosstabFilterGroup;
    }

    public void setCrosstabFilterGroup(String crosstabFilterGroup) {
        this.crosstabFilterGroup = crosstabFilterGroup;
    }

    public boolean isSummaryDataSet() {
        return this.summaryGroup != null;
    }

    public void setSeriesName(int index, String field) {
        if (this.seriesNames.size() == index) {
            this.seriesNames.add(field);
        } else {
            this.seriesNames.set(index, field);
        }
    }

    public String getSeriesName(int index) {
        return this.seriesNames.get(index);
    }

    public int getSeriesNameCount() {
        return this.seriesNames.size();
    }

    public String[] getSeriesName() {
        return this.seriesNames.toArray(new String[this.seriesNames.size()]);
    }

    public void setSeriesName(String[] fields) {
        this.seriesNames.clear();
        this.seriesNames.addAll(Arrays.asList(fields));
    }

    public void setSeriesColumn(int index, String field) {
        if (this.seriesColumns.size() == index) {
            this.seriesColumns.add(field);
        } else {
            this.seriesColumns.set(index, field);
        }
    }

    public String getSeriesColumn(int index) {
        return this.seriesColumns.get(index);
    }

    public int getSeriesColumnCount() {
        return this.seriesColumns.size();
    }

    public String[] getSeriesColumn() {
        return this.seriesColumns.toArray(new String[this.seriesColumns.size()]);
    }

    public void setSeriesColumn(String[] fields) {
        this.seriesColumns.clear();
        this.seriesColumns.addAll(Arrays.asList(fields));
    }

    public String getResetGroup() {
        return this.resetGroup;
    }

    public void setResetGroup(String resetGroup) {
        this.resetGroup = resetGroup;
    }

    public String getSummaryGroup() {
        return this.summaryGroup;
    }

    public void setSummaryGroup(String summaryGroup) {
        this.summaryGroup = summaryGroup;
    }

    public final Object getValue() {
        Dataset dataSet = this.getDataSet();
        if (this.groupStateKey != null) {
            return new StaticCollectorFunctionResult(dataSet, new CacheKey(this.groupStateKey, this.lastGroupSequenceNumber));
        }
        if (this.globalStateKey != null) {
            return new StaticCollectorFunctionResult(dataSet, new CacheKey(this.globalStateKey, this.lastGroupSequenceNumber));
        }
        return null;
    }

    public final void reportInitialized(ReportEvent event) {
        this.globalStateKey = event.getState().getProcessKey();
        if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            this.result = new Sequence();
            this.lastGroupSequenceNumber = 0;
            this.results.clear();
            this.results.put(this.globalStateKey, this.result);
        } else {
            this.result = this.results.get(this.globalStateKey);
            this.lastGroupSequenceNumber = 0;
        }
    }

    protected ReportStateKey getStateKey() {
        if (this.groupStateKey == null) {
            return this.globalStateKey;
        }
        return this.groupStateKey;
    }

    protected int getLastGroupSequenceNumber() {
        return this.lastGroupSequenceNumber;
    }

    public final void groupStarted(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup((String)this.getResetGroup(), (ReportEvent)event)) {
            this.groupStateKey = event.getState().getProcessKey();
            if (FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
                this.result = new Sequence();
                this.lastGroupSequenceNumber = 0;
                this.results.put(this.globalStateKey, this.result);
                this.results.put(this.groupStateKey, this.result);
            } else {
                this.result = this.results.get(this.groupStateKey);
            }
        }
        if (FunctionUtilities.isDefinedGroup((String)this.getCrosstabFilterGroup(), (ReportEvent)event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    public final void itemsAdvanced(ReportEvent event) {
        if (this.isSummaryDataSet()) {
            return;
        }
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            return;
        }
        this.buildDataset();
    }

    public final void groupFinished(ReportEvent event) {
        if (!this.isSummaryDataSet()) {
            return;
        }
        if (!FunctionUtilities.isDefinedGroup((String)this.getSummaryGroup(), (ReportEvent)event)) {
            return;
        }
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)event)) {
            return;
        }
        this.buildDataset();
    }

    public void summaryRowSelection(ReportEvent event) {
        if (FunctionUtilities.isDefinedGroup((String)this.getCrosstabFilterGroup(), (ReportEvent)event)) {
            int groupIndex = event.getState().getCurrentGroupIndex();
            this.lastGroupSequenceNumber = (int)event.getState().getCrosstabColumnSequenceCounter(groupIndex);
        }
    }

    protected void buildDataset() {
    }

    protected abstract Dataset createNewDataset();

    protected Dataset getDataSet() {
        if (this.result == null) {
            return null;
        }
        Dataset dataset = (Dataset)this.result.get(this.lastGroupSequenceNumber);
        if (dataset != null) {
            return dataset;
        }
        Dataset created = this.createNewDataset();
        this.result.set(this.lastGroupSequenceNumber, (Object)created);
        return created;
    }

    protected int getMaximumSeriesIndex() {
        return Math.max(this.seriesColumns.size(), this.seriesNames.size());
    }

    public Boolean getAutoGenerateMissingSeriesNames() {
        return this.autoGenerateMissingSeriesNames;
    }

    public void setAutoGenerateMissingSeriesNames(Boolean autoGenerateMissingSeriesNames) {
        this.autoGenerateMissingSeriesNames = autoGenerateMissingSeriesNames;
    }

    protected String generateName(int index) {
        return "Series " + (index + 1);
    }

    protected Comparable querySeriesValue(int index) {
        String retval;
        String seriesColumn;
        if (index < this.getSeriesColumnCount() && !StringUtils.isEmpty((String)(seriesColumn = this.getSeriesColumn(index)))) {
            Object o = this.getDataRow().get(seriesColumn);
            if (o instanceof Comparable) {
                return (Comparable)o;
            }
            if (Boolean.FALSE.equals(this.autoGenerateMissingSeriesNames)) {
                return null;
            }
            return this.generateName(index);
        }
        if (index < this.getSeriesNameCount() && (retval = this.getSeriesName(index)) != null) {
            return retval;
        }
        if (Boolean.FALSE.equals(this.autoGenerateMissingSeriesNames)) {
            return null;
        }
        return this.generateName(index);
    }

    public Expression getInstance() {
        AbstractCollectorFunction expression = (AbstractCollectorFunction)super.getInstance();
        expression.groupStateKey = null;
        expression.globalStateKey = null;
        expression.lastGroupSequenceNumber = -1;
        expression.results = new HashMap();
        expression.seriesColumns = (ArrayList)this.seriesColumns.clone();
        expression.seriesNames = (ArrayList)this.seriesNames.clone();
        return expression;
    }

    private static class StaticCollectorFunctionResult
    implements CollectorFunctionResult {
        private Dataset dataSet;
        private CacheKey cacheKey;

        private StaticCollectorFunctionResult(Dataset dataSet, CacheKey cacheKey) {
            this.dataSet = dataSet;
            this.cacheKey = cacheKey;
        }

        @Override
        public Dataset getDataSet() {
            return this.dataSet;
        }

        @Override
        public Object getCacheKey() {
            return this.cacheKey;
        }
    }

    private static class CacheKey {
        private int index;
        private ReportStateKey stateKey;

        private CacheKey(ReportStateKey stateKey, int index) {
            this.stateKey = stateKey;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.index != cacheKey.index) {
                return false;
            }
            return !(this.stateKey != null ? !this.stateKey.equals((Object)cacheKey.stateKey) : cacheKey.stateKey != null);
        }

        public int hashCode() {
            int result = this.index;
            result = 31 * result + (this.stateKey != null ? this.stateKey.hashCode() : 0);
            return result;
        }
    }
}

