/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.AbstractCollectorFunction;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.CollectorFunctionUtil;

public class PieDataSetCollector
extends AbstractCollectorFunction {
    private String valueColumn;

    public String getValueColumn() {
        return this.valueColumn;
    }

    public void setValueColumn(String valueColumn) {
        this.valueColumn = valueColumn;
    }

    @Override
    protected Dataset createNewDataset() {
        return new DefaultPieDataset();
    }

    @Override
    protected void buildDataset() {
        DefaultPieDataset localPieDataset = (DefaultPieDataset)this.getDataSet();
        Comparable seriesComparable = this.querySeriesValue(0);
        if (seriesComparable == null) {
            return;
        }
        Object valueObject = this.getDataRow().get(this.getValueColumn());
        Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
        Number existingValue = CollectorFunctionUtil.queryExistingValueFromDataSet((PieDataset)localPieDataset, seriesComparable);
        if (existingValue != null) {
            if (value != null) {
                localPieDataset.setValue(seriesComparable, (Number)CollectorFunctionUtil.add(existingValue, value));
            }
        } else {
            localPieDataset.setValue(seriesComparable, value);
        }
    }
}

