/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.data.general.Dataset;
import org.pentaho.plugin.jfreereport.reportcharts.ExtendedXYZDataset;
import org.pentaho.plugin.jfreereport.reportcharts.collectors.AbstractCollectorFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;

public class XYZSeriesCollector
extends AbstractCollectorFunction {
    private ArrayList<String> xValueColumns = new ArrayList();
    private ArrayList<String> yValueColumns = new ArrayList();
    private ArrayList<String> zValueColumns = new ArrayList();

    @Override
    protected Dataset createNewDataset() {
        return new ExtendedXYZDataset();
    }

    public void setXValueColumn(int index, String field) {
        if (this.xValueColumns.size() == index) {
            this.xValueColumns.add(field);
        } else {
            this.xValueColumns.set(index, field);
        }
    }

    public String getXValueColumn(int index) {
        return this.xValueColumns.get(index);
    }

    public int getXValueColumnCount() {
        return this.xValueColumns.size();
    }

    public String[] getXValueColumn() {
        return this.xValueColumns.toArray(new String[this.xValueColumns.size()]);
    }

    public void setXValueColumn(String[] fields) {
        this.xValueColumns.clear();
        this.xValueColumns.addAll(Arrays.asList(fields));
    }

    public void setYValueColumn(int index, String field) {
        if (this.yValueColumns.size() == index) {
            this.yValueColumns.add(field);
        } else {
            this.yValueColumns.set(index, field);
        }
    }

    public String getYValueColumn(int index) {
        return this.yValueColumns.get(index);
    }

    public int getYValueColumnCount() {
        return this.yValueColumns.size();
    }

    public String[] getYValueColumn() {
        return this.yValueColumns.toArray(new String[this.yValueColumns.size()]);
    }

    public void setYValueColumn(String[] fields) {
        this.yValueColumns.clear();
        this.yValueColumns.addAll(Arrays.asList(fields));
    }

    public void setZValueColumn(int index, String field) {
        if (this.zValueColumns.size() == index) {
            this.zValueColumns.add(field);
        } else {
            this.zValueColumns.set(index, field);
        }
    }

    public String getZValueColumn(int index) {
        return this.zValueColumns.get(index);
    }

    public int getZValueColumnCount() {
        return this.zValueColumns.size();
    }

    public String[] getZValueColumn() {
        return this.zValueColumns.toArray(new String[this.zValueColumns.size()]);
    }

    public void setZValueColumn(String[] fields) {
        this.zValueColumns.clear();
        this.zValueColumns.addAll(Arrays.asList(fields));
    }

    @Override
    public Expression getInstance() {
        XYZSeriesCollector expression = (XYZSeriesCollector)super.getInstance();
        expression.xValueColumns = (ArrayList)this.xValueColumns.clone();
        expression.yValueColumns = (ArrayList)this.yValueColumns.clone();
        expression.zValueColumns = (ArrayList)this.zValueColumns.clone();
        return expression;
    }

    @Override
    protected void buildDataset() {
        ExtendedXYZDataset xySeriesDataset = (ExtendedXYZDataset)this.getDataSet();
        int maxIndex = Math.min(this.xValueColumns.size(), Math.min(this.yValueColumns.size(), this.zValueColumns.size()));
        for (int i = 0; i < maxIndex; ++i) {
            Number zValue;
            Comparable seriesName = this.querySeriesValue(i);
            Object xValueObject = this.getDataRow().get(this.xValueColumns.get(i));
            Object yValueObject = this.getDataRow().get(this.yValueColumns.get(i));
            Object zValueObject = this.getDataRow().get(this.zValueColumns.get(i));
            Number xValue = xValueObject instanceof Number ? (Number)((Number)xValueObject) : (Number)null;
            Number yValue = yValueObject instanceof Number ? (Number)((Number)yValueObject) : (Number)null;
            Number number = zValue = zValueObject instanceof Number ? (Number)((Number)zValueObject) : (Number)null;
            if (xValue == null || yValue == null || zValue == null) continue;
            if (zValue.doubleValue() > xySeriesDataset.getMaxZValue()) {
                xySeriesDataset.setMaxZValue(zValue.doubleValue());
            }
            double[][] seriesValues = new double[3][1];
            seriesValues[0][0] = xValue.doubleValue();
            seriesValues[1][0] = yValue.doubleValue();
            seriesValues[2][0] = zValue.doubleValue();
            xySeriesDataset.addSeries(seriesName, seriesValues);
        }
    }
}

