/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PrivilegedOperation {
    public static final char LINUX_FILE_PATH_SEPARATOR = '%';
    public static final String CGROUP_ARG_PREFIX = "cgroups=";
    private final OperationType opType;
    private final List<String> args;

    public PrivilegedOperation(OperationType opType, String arg) {
        this.opType = opType;
        this.args = new ArrayList<String>();
        if (arg != null) {
            this.args.add(arg);
        }
    }

    public PrivilegedOperation(OperationType opType, List<String> args) {
        this.opType = opType;
        this.args = new ArrayList<String>();
        if (args != null) {
            this.args.addAll(args);
        }
    }

    public void appendArgs(String ... args) {
        for (String arg : args) {
            this.args.add(arg);
        }
    }

    public void appendArgs(List<String> args) {
        this.args.addAll(args);
    }

    public OperationType getOperationType() {
        return this.opType;
    }

    public List<String> getArguments() {
        return Collections.unmodifiableList(this.args);
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof PrivilegedOperation)) {
            return false;
        }
        PrivilegedOperation otherOp = (PrivilegedOperation)other;
        return otherOp.opType.equals((Object)this.opType) && otherOp.args.equals(this.args);
    }

    public int hashCode() {
        return this.opType.hashCode() + 97 * this.args.hashCode();
    }

    public static enum OperationType {
        CHECK_SETUP("--checksetup"),
        MOUNT_CGROUPS("--mount-cgroups"),
        INITIALIZE_CONTAINER(""),
        LAUNCH_CONTAINER(""),
        SIGNAL_CONTAINER(""),
        DELETE_AS_USER(""),
        TC_MODIFY_STATE("--tc-modify-state"),
        TC_READ_STATE("--tc-read-state"),
        TC_READ_STATS("--tc-read-stats"),
        ADD_PID_TO_CGROUP("");

        private final String option;

        private OperationType(String option) {
            this.option = option;
        }

        public String getOption() {
            return this.option;
        }
    }
}

