/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperationExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsBlkioResourceHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.DiskResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.OutboundBandwidthResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerChain;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.TrafficControlBandwidthHandlerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.TrafficController;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ResourceHandlerModule {
    private static volatile ResourceHandlerChain resourceHandlerChain;
    private static volatile TrafficControlBandwidthHandlerImpl trafficControlBandwidthHandler;
    private static volatile CGroupsHandler cGroupsHandler;
    private static volatile CGroupsBlkioResourceHandlerImpl cGroupsBlkioResourceHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CGroupsHandler getCGroupsHandler(Configuration conf) throws ResourceHandlerException {
        if (cGroupsHandler != null) return cGroupsHandler;
        Class<CGroupsHandler> clazz = CGroupsHandler.class;
        synchronized (CGroupsHandler.class) {
            if (cGroupsHandler != null) return cGroupsHandler;
            cGroupsHandler = new CGroupsHandlerImpl(conf, PrivilegedOperationExecutor.getInstance(conf));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cGroupsHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TrafficControlBandwidthHandlerImpl getTrafficControlBandwidthHandler(Configuration conf) throws ResourceHandlerException {
        if (!conf.getBoolean("yarn.nodemanager.resource.network.enabled", false)) return null;
        if (trafficControlBandwidthHandler != null) return trafficControlBandwidthHandler;
        Class<OutboundBandwidthResourceHandler> clazz = OutboundBandwidthResourceHandler.class;
        synchronized (OutboundBandwidthResourceHandler.class) {
            if (trafficControlBandwidthHandler != null) return trafficControlBandwidthHandler;
            trafficControlBandwidthHandler = new TrafficControlBandwidthHandlerImpl(PrivilegedOperationExecutor.getInstance(conf), ResourceHandlerModule.getCGroupsHandler(conf), new TrafficController(conf, PrivilegedOperationExecutor.getInstance(conf)));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return trafficControlBandwidthHandler;
        }
    }

    public static OutboundBandwidthResourceHandler getOutboundBandwidthResourceHandler(Configuration conf) throws ResourceHandlerException {
        return ResourceHandlerModule.getTrafficControlBandwidthHandler(conf);
    }

    public static DiskResourceHandler getDiskResourceHandler(Configuration conf) throws ResourceHandlerException {
        if (conf.getBoolean("yarn.nodemanager.resource.disk.enabled", false)) {
            return ResourceHandlerModule.getCgroupsBlkioResourceHandler(conf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CGroupsBlkioResourceHandlerImpl getCgroupsBlkioResourceHandler(Configuration conf) throws ResourceHandlerException {
        if (cGroupsBlkioResourceHandler != null) return cGroupsBlkioResourceHandler;
        Class<DiskResourceHandler> clazz = DiskResourceHandler.class;
        synchronized (DiskResourceHandler.class) {
            if (cGroupsBlkioResourceHandler != null) return cGroupsBlkioResourceHandler;
            cGroupsBlkioResourceHandler = new CGroupsBlkioResourceHandlerImpl(ResourceHandlerModule.getCGroupsHandler(conf));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cGroupsBlkioResourceHandler;
        }
    }

    private static void addHandlerIfNotNull(List<ResourceHandler> handlerList, ResourceHandler handler) {
        if (handler != null) {
            handlerList.add(handler);
        }
    }

    private static void initializeConfiguredResourceHandlerChain(Configuration conf) throws ResourceHandlerException {
        ArrayList<ResourceHandler> handlerList = new ArrayList<ResourceHandler>();
        ResourceHandlerModule.addHandlerIfNotNull(handlerList, ResourceHandlerModule.getOutboundBandwidthResourceHandler(conf));
        ResourceHandlerModule.addHandlerIfNotNull(handlerList, ResourceHandlerModule.getDiskResourceHandler(conf));
        resourceHandlerChain = new ResourceHandlerChain(handlerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ResourceHandlerChain getConfiguredResourceHandlerChain(Configuration conf) throws ResourceHandlerException {
        if (resourceHandlerChain == null) {
            Class<ResourceHandlerModule> clazz = ResourceHandlerModule.class;
            // MONITORENTER : org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerModule.class
            if (resourceHandlerChain == null) {
                ResourceHandlerModule.initializeConfiguredResourceHandlerChain(conf);
            }
            // MONITOREXIT : clazz
        }
        if (resourceHandlerChain.getResourceHandlerList().size() == 0) return null;
        return resourceHandlerChain;
    }

    @VisibleForTesting
    static void nullifyResourceHandlerChain() throws ResourceHandlerException {
        resourceHandlerChain = null;
    }
}

