/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ops4j.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WelcomeFilesFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(WelcomeFilesFilter.class);
    private final String[] welcomeFiles;
    private final boolean redirect;
    private FilterConfig filterConfig;

    WelcomeFilesFilter(String[] welcomeFiles, boolean redirect) {
        NullArgumentException.validateNotNull(welcomeFiles, "Welcome files");
        if (welcomeFiles.length == 0) {
            throw new NullArgumentException("Welcome files is be empty");
        }
        for (String welcomeFile : welcomeFiles) {
            if (welcomeFile == null || welcomeFile.trim().length() == 0) {
                throw new NullArgumentException("Welcome files entry is null or empty");
            }
            if (welcomeFile.startsWith("/")) {
                throw new NullArgumentException("Welcome files entry [" + welcomeFile + "] starts with '/'");
            }
            if (!welcomeFile.endsWith("/")) continue;
            throw new NullArgumentException("Welcome files entry [" + welcomeFile + "] ends with '/'");
        }
        this.welcomeFiles = welcomeFiles;
        this.redirect = redirect;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug("Apply welcome files filter...");
        if (this.welcomeFiles.length > 0 && request instanceof HttpServletRequest) {
            String servletPath = ((HttpServletRequest)request).getServletPath();
            String pathInfo = ((HttpServletRequest)request).getPathInfo();
            LOG.debug("Servlet path: " + servletPath);
            LOG.debug("Path info: " + pathInfo);
            if (pathInfo != null && pathInfo.endsWith("/") || servletPath != null && servletPath.endsWith("/")) {
                ServletContext servletContext = this.filterConfig.getServletContext();
                for (String welcomeFile : this.welcomeFiles) {
                    String welcomePath = WelcomeFilesFilter.addPaths(servletPath, WelcomeFilesFilter.addPaths(pathInfo, welcomeFile));
                    URL welcomeFileUrl = servletContext.getResource(welcomePath);
                    if (welcomeFileUrl == null) continue;
                    if (this.redirect && response instanceof HttpServletResponse) {
                        ((HttpServletResponse)response).sendRedirect(welcomeFile);
                        return;
                    }
                    RequestDispatcher requestDispatcher = request.getRequestDispatcher(welcomePath);
                    if (requestDispatcher == null) continue;
                    requestDispatcher.forward(request, response);
                    return;
                }
            }
        } else {
            if (this.welcomeFiles.length == 0) {
                LOG.debug("Welcome filter not applied as there are no welcome files configured.");
            }
            if (!(request instanceof HttpServletRequest)) {
                LOG.debug("Welcome filter not applied as the request is not an " + HttpServletRequest.class.getSimpleName());
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private static String addPaths(String path1, String path2) {
        if (path1 == null || path1.length() == 0) {
            if (path1 != null && path2 == null) {
                return path1;
            }
            return path2;
        }
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        int split = path1.indexOf(59);
        if (split < 0) {
            split = path1.indexOf(63);
        }
        if (split == 0) {
            return path2 + path1;
        }
        if (split < 0) {
            split = path1.length();
        }
        StringBuffer buf = new StringBuffer(path1.length() + path2.length() + 2);
        buf.append(path1);
        if (buf.charAt(split - 1) == '/') {
            if (path2.startsWith("/")) {
                buf.deleteCharAt(split - 1);
                buf.insert(split - 1, path2);
            } else {
                buf.insert(split, path2);
            }
        } else if (path2.startsWith("/")) {
            buf.insert(split, path2);
        } else {
            buf.insert(split, '/');
            buf.insert(split + 1, path2);
        }
        return buf.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "welcomeFiles=" + Arrays.toString(this.welcomeFiles) + "}";
    }
}

