/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.spi.model.ContextModel;
import org.ops4j.pax.web.service.spi.model.Model;
import org.ops4j.pax.web.service.spi.util.ConversionUtil;
import org.ops4j.pax.web.service.spi.util.Path;

public class ServletModel
extends Model {
    public static final String SERVLET_NAME = "servlet-name";
    private final Class<? extends Servlet> servletClass;
    private final Servlet servlet;
    private final String alias;
    private final String[] urlPatterns;
    private final Map<String, String> initParams;
    private final String name;
    private final Integer loadOnStartup;
    private final Boolean asyncSupported;
    private MultipartConfigElement multipartConfigElement;

    public ServletModel(ContextModel contextModel, Servlet servlet, String alias, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported) {
        this(contextModel, servlet, null, new String[]{ServletModel.aliasAsUrlPattern(alias)}, ServletModel.validateAlias(alias), initParams, loadOnStartup, asyncSupported, null);
    }

    public ServletModel(ContextModel contextModel, Servlet servlet, String alias, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig) {
        this(contextModel, servlet, null, new String[]{ServletModel.aliasAsUrlPattern(alias)}, ServletModel.validateAlias(alias), initParams, loadOnStartup, asyncSupported, multiPartConfig);
    }

    public ServletModel(ContextModel contextModel, Servlet servlet, String servletName, String[] urlPatterns, String alias, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig) {
        this(contextModel, null, servlet, servletName, urlPatterns, alias, initParams, loadOnStartup, asyncSupported, multiPartConfig);
    }

    public ServletModel(ContextModel contextModel, Class<? extends Servlet> servletClass, String servletName, String[] urlPatterns, String alias, Dictionary<String, ?> initParams, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig) {
        this(contextModel, servletClass, null, servletName, urlPatterns, alias, initParams, loadOnStartup, asyncSupported, multiPartConfig);
    }

    private ServletModel(ContextModel contextModel, Class<? extends Servlet> servletClass, Servlet servlet, String servletName, String[] urlPatterns, String alias, Dictionary<String, ?> initParameters, Integer loadOnStartup, Boolean asyncSupported, MultipartConfigElement multiPartConfig) {
        super(contextModel);
        if (servletClass == null) {
            NullArgumentException.validateNotNull(servlet, "Servlet");
        }
        if (servlet == null) {
            NullArgumentException.validateNotNull(servletClass, "ServletClass");
        }
        NullArgumentException.validateNotNull(urlPatterns, "Url patterns");
        if (urlPatterns.length == 0) {
            throw new IllegalArgumentException("Registered servlet must have at least one url pattern");
        }
        this.urlPatterns = Path.normalizePatterns(urlPatterns);
        this.alias = alias;
        this.servletClass = servletClass;
        this.servlet = servlet;
        this.initParams = ConversionUtil.convertToMap(initParameters);
        String name = servletName;
        if (name == null) {
            name = this.initParams.get(SERVLET_NAME);
        }
        if (name == null) {
            name = this.getId();
        }
        this.name = name;
        this.loadOnStartup = loadOnStartup;
        this.asyncSupported = asyncSupported;
        this.multipartConfigElement = multiPartConfig;
    }

    public String getName() {
        return this.name;
    }

    public String[] getUrlPatterns() {
        return this.urlPatterns;
    }

    public String getAlias() {
        return this.alias;
    }

    public Class<? extends Servlet> getServletClass() {
        return this.servletClass;
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public Map<String, String> getInitParams() {
        return this.initParams;
    }

    public Integer getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public Boolean getAsyncSupported() {
        return this.asyncSupported;
    }

    private static String validateAlias(String alias) {
        NullArgumentException.validateNotNull(alias, "Alias");
        if (!alias.startsWith("/")) {
            throw new IllegalArgumentException("Alias does not start with slash (/)");
        }
        if (alias.length() > 1 && alias.endsWith("/")) {
            throw new IllegalArgumentException("Alias ends with slash (/)");
        }
        return alias;
    }

    private static String aliasAsUrlPattern(String alias) {
        String urlPattern = alias;
        if (urlPattern != null && !urlPattern.equals("/") && !urlPattern.contains("*")) {
            urlPattern = urlPattern.endsWith("/") ? urlPattern + "*" : urlPattern + "/*";
        }
        return urlPattern;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + "id=" + this.getId() + ",name=" + this.getName() + ",urlPatterns=" + Arrays.toString(this.urlPatterns) + ",alias=" + this.alias + ",servlet=" + this.servlet + ",initParams=" + this.initParams + ",context=" + this.getContextModel() + "}";
    }

    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfigElement;
    }
}

