/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup;

import java.io.Serializable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.BackupProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BackupStatus
implements Serializable {
    private static final long serialVersionUID = -5968397963548535982L;
    private TableName table;
    private String targetDir;
    private String snapshotName = null;

    public BackupStatus() {
    }

    public BackupStatus(TableName table, String targetRootDir, String backupId) {
        this.table = table;
        this.targetDir = BackupClientUtil.getTableBackupDir(targetRootDir, backupId, table);
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public TableName getTable() {
        return this.table;
    }

    public void setTable(TableName table) {
        this.table = table;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public static BackupStatus convert(BackupProtos.TableBackupStatus proto) {
        BackupStatus bs = new BackupStatus();
        bs.setTable(ProtobufUtil.toTableName(proto.getTable()));
        bs.setTargetDir(proto.getTargetDir());
        if (proto.hasSnapshot()) {
            bs.setSnapshotName(proto.getSnapshot());
        }
        return bs;
    }

    public BackupProtos.TableBackupStatus toProto() {
        BackupProtos.TableBackupStatus.Builder builder = BackupProtos.TableBackupStatus.newBuilder();
        if (this.snapshotName != null) {
            builder.setSnapshot(this.snapshotName);
        }
        builder.setTable(ProtobufUtil.toProtoTableName(this.table));
        builder.setTargetDir(this.targetDir);
        return builder.build();
    }
}

