/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.BackupRequest;
import org.apache.hadoop.hbase.backup.BackupType;
import org.apache.hadoop.hbase.backup.impl.BackupRestoreConstants;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.backup.util.BackupSet;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BackupAdmin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class BackupCommands {
    private static final String USAGE = "Usage: hbase backup COMMAND\nwhere COMMAND is one of:\n  create     create a new backup image\n  cancel     cancel an ongoing backup\n  delete     delete an existing backup image\n  describe   show the detailed information of a backup image\n  history    show history of all successful backups\n  progress   show the progress of the latest backup request\n  set        backup set management\nEnter 'help COMMAND' to see help message for each command\n";
    private static final String CREATE_CMD_USAGE = "Usage: hbase backup create <type> <backup_root_path> [tables] [-s name] [-convert] [-silent] [-w workers][-b bandwith]\n type          \"full\" to create a full backup image;\n               \"incremental\" to create an incremental backup image\n  backup_root_path   The full root path to store the backup image,\n                    the prefix can be hdfs, webhdfs or gpfs\n Options:\n  tables      If no tables (\"\") are specified, all tables are backed up. Otherwise it is a\n               comma separated list of tables.\n -w          number of parallel workers.\n -b          bandwith per one worker (in MB sec)\n -set        name of backup set";
    private static final String PROGRESS_CMD_USAGE = "Usage: hbase backup progress <backupId>\n backupId      backup image id;\n";
    private static final String DESCRIBE_CMD_USAGE = "Usage: hbase backup decsribe <backupId>\n backupId      backup image id\n";
    private static final String HISTORY_CMD_USAGE = "Usage: hbase backup history [-n N]\n -n N     show up to N last backup sessions, default - 10;\n";
    private static final String DELETE_CMD_USAGE = "Usage: hbase backup delete <backupId>\n backupId      backup image id;\n";
    private static final String CANCEL_CMD_USAGE = "Usage: hbase backup cancel <backupId>\n backupId      backup image id;\n";
    private static final String SET_CMD_USAGE = "Usage: hbase backup set COMMAND [name] [tables]\n name       Backup set name\n tables      If no tables (\"\") are specified, all tables will belong to the set. Otherwise it is a\n               comma separated list of tables.\nwhere COMMAND is one of:\n  add      add tables to a set, crete set if needed\n  remove   remove tables from set\n  list     list all sets\n  describe describes set\n  delete   delete backup set\n";

    private BackupCommands() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    public static Command createCommand(Configuration conf, BackupRestoreConstants.BackupCommand type, CommandLine cmdline) {
        Command cmd = null;
        switch (type) {
            case CREATE: {
                cmd = new CreateCommand(conf, cmdline);
                break;
            }
            case DESCRIBE: {
                cmd = new DescribeCommand(conf, cmdline);
                break;
            }
            case PROGRESS: {
                cmd = new ProgressCommand(conf, cmdline);
                break;
            }
            case DELETE: {
                cmd = new DeleteCommand(conf, cmdline);
                break;
            }
            case CANCEL: {
                cmd = new CancelCommand(conf, cmdline);
                break;
            }
            case HISTORY: {
                cmd = new HistoryCommand(conf, cmdline);
                break;
            }
            case SET: {
                cmd = new BackupSetCommand(conf, cmdline);
                break;
            }
            default: {
                cmd = new HelpCommand(conf, cmdline);
            }
        }
        return cmd;
    }

    private static class BackupSetCommand
    extends Command {
        private static final String SET_ADD_CMD = "add";
        private static final String SET_REMOVE_CMD = "remove";
        private static final String SET_DELETE_CMD = "delete";
        private static final String SET_DESCRIBE_CMD = "describe";
        private static final String SET_LIST_CMD = "list";
        CommandLine cmdline;

        BackupSetCommand(Configuration conf, CommandLine cmdline) {
            super(conf);
            this.cmdline = cmdline;
        }

        @Override
        public void execute() throws IOException {
            if (this.cmdline == null || this.cmdline.getArgs() == null || this.cmdline.getArgs().length < 2) {
                throw new IOException("command line format");
            }
            String[] args = this.cmdline.getArgs();
            String cmdStr = args[1];
            BackupRestoreConstants.BackupCommand cmd = this.getCommand(cmdStr);
            switch (cmd) {
                case SET_ADD: {
                    this.processSetAdd(args);
                    break;
                }
                case SET_REMOVE: {
                    this.processSetRemove(args);
                    break;
                }
                case SET_DELETE: {
                    this.processSetDelete(args);
                    break;
                }
                case SET_DESCRIBE: {
                    this.processSetDescribe(args);
                    break;
                }
                case SET_LIST: {
                    this.processSetList(args);
                    break;
                }
            }
        }

        private void processSetList(String[] args) throws IOException {
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                List<BackupSet> list = admin.listBackupSets();
                for (BackupSet bs : list) {
                    System.out.println(bs);
                }
            }
        }

        private void processSetDescribe(String[] args) throws IOException {
            if (args == null || args.length != 3) {
                throw new RuntimeException("Wrong number of args: " + args.length);
            }
            String setName = args[2];
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                BackupSet set = admin.getBackupSet(setName);
                if (set == null) {
                    System.out.println("Set '" + setName + "' does not exist.");
                } else {
                    System.out.println(set);
                }
            }
        }

        private void processSetDelete(String[] args) throws IOException {
            if (args == null || args.length != 3) {
                throw new RuntimeException("Wrong number of args");
            }
            String setName = args[2];
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                boolean result = admin.deleteBackupSet(setName);
                if (result) {
                    System.out.println("Delete set " + setName + " OK.");
                } else {
                    System.out.println("Set " + setName + " does not exist");
                }
            }
        }

        private void processSetRemove(String[] args) throws IOException {
            if (args == null || args.length != 4) {
                throw new RuntimeException("Wrong args");
            }
            String setName = args[2];
            String[] tables = args[3].split(",");
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                admin.removeFromBackupSet(setName, tables);
            }
        }

        private void processSetAdd(String[] args) throws IOException {
            if (args == null || args.length != 4) {
                throw new RuntimeException("Wrong args");
            }
            String setName = args[2];
            String[] tables = args[3].split(",");
            TableName[] tableNames = new TableName[tables.length];
            for (int i = 0; i < tables.length; ++i) {
                tableNames[i] = TableName.valueOf((String)tables[i]);
            }
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                admin.addToBackupSet(setName, tableNames);
            }
        }

        private BackupRestoreConstants.BackupCommand getCommand(String cmdStr) throws IOException {
            if (cmdStr.equals(SET_ADD_CMD)) {
                return BackupRestoreConstants.BackupCommand.SET_ADD;
            }
            if (cmdStr.equals(SET_REMOVE_CMD)) {
                return BackupRestoreConstants.BackupCommand.SET_REMOVE;
            }
            if (cmdStr.equals(SET_DELETE_CMD)) {
                return BackupRestoreConstants.BackupCommand.SET_DELETE;
            }
            if (cmdStr.equals(SET_DESCRIBE_CMD)) {
                return BackupRestoreConstants.BackupCommand.SET_DESCRIBE;
            }
            if (cmdStr.equals(SET_LIST_CMD)) {
                return BackupRestoreConstants.BackupCommand.SET_LIST;
            }
            throw new IOException("Unknown command for 'set' :" + cmdStr);
        }
    }

    private static class HistoryCommand
    extends Command {
        CommandLine cmdline;
        private static final int DEFAULT_HISTORY_LENGTH = 10;

        HistoryCommand(Configuration conf, CommandLine cmdline) {
            super(conf);
            this.cmdline = cmdline;
        }

        @Override
        public void execute() throws IOException {
            int n = this.parseHistoryLength();
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                List<BackupInfo> history = admin.getHistory(n);
                for (BackupInfo info : history) {
                    System.out.println(info.getShortDescription());
                }
            }
        }

        private int parseHistoryLength() {
            String value = this.cmdline.getOptionValue("n");
            if (value == null) {
                return 10;
            }
            return Integer.parseInt(value);
        }
    }

    private static class CancelCommand
    extends Command {
        CommandLine cmdline;

        CancelCommand(Configuration conf, CommandLine cmdline) {
            super(conf);
            this.cmdline = cmdline;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws IOException {
            String[] args;
            if (this.cmdline == null || this.cmdline.getArgs() == null || this.cmdline.getArgs().length < 2) {
                System.out.println("No backup id(s) was specified, will use the most recent one");
            }
            String backupId = (args = this.cmdline.getArgs()) == null || args.length == 0 ? null : args[1];
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);){
                BackupAdmin admin = conn.getAdmin().getBackupAdmin();
                Throwable throwable = null;
                if (admin != null) {
                    if (throwable != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
    }

    private static class DeleteCommand
    extends Command {
        CommandLine cmdline;

        DeleteCommand(Configuration conf, CommandLine cmdline) {
            super(conf);
            this.cmdline = cmdline;
        }

        @Override
        public void execute() throws IOException {
            if (this.cmdline == null || this.cmdline.getArgs() == null || this.cmdline.getArgs().length < 2) {
                System.out.println("No backup id(s) was specified");
                System.out.println(BackupCommands.PROGRESS_CMD_USAGE);
                System.exit(-1);
            }
            String[] args = this.cmdline.getArgs();
            String[] backupIds = new String[args.length - 1];
            System.arraycopy(args, 1, backupIds, 0, backupIds.length);
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                int deleted = admin.deleteBackups(args);
                System.out.println("Deleted " + deleted + " backups. Total requested: " + args.length);
            }
        }
    }

    private static class ProgressCommand
    extends Command {
        CommandLine cmdline;

        ProgressCommand(Configuration conf, CommandLine cmdline) {
            super(conf);
            this.cmdline = cmdline;
        }

        @Override
        public void execute() throws IOException {
            String[] args;
            if (this.cmdline == null || this.cmdline.getArgs() == null || this.cmdline.getArgs().length != 2) {
                System.out.println("No backup id was specified, will retrieve the most recent (ongoing) sessions");
            }
            if ((args = this.cmdline.getArgs()).length > 2) {
                System.out.println("ERROR: wrong number of arguments: " + args.length);
                System.out.println(BackupCommands.PROGRESS_CMD_USAGE);
                System.exit(-1);
            }
            String backupId = args == null ? null : args[1];
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                int progress = admin.getProgress(backupId);
                if (progress < 0) {
                    System.out.println("No info was found for backup id: " + backupId);
                } else {
                    System.out.println(backupId + " progress=" + progress + "%");
                }
            }
        }
    }

    private static class DescribeCommand
    extends Command {
        CommandLine cmdline;

        DescribeCommand(Configuration conf, CommandLine cmdline) {
            super(conf);
            this.cmdline = cmdline;
        }

        @Override
        public void execute() throws IOException {
            String[] args;
            if (this.cmdline == null || this.cmdline.getArgs() == null) {
                System.out.println("ERROR: missing arguments");
                System.out.println(BackupCommands.DESCRIBE_CMD_USAGE);
                System.exit(-1);
            }
            if ((args = this.cmdline.getArgs()).length != 2) {
                System.out.println("ERROR: wrong number of arguments");
                System.out.println(BackupCommands.DESCRIBE_CMD_USAGE);
                System.exit(-1);
            }
            String backupId = args[1];
            Configuration conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            try (Connection conn = ConnectionFactory.createConnection(conf);
                 BackupAdmin admin = conn.getAdmin().getBackupAdmin();){
                BackupInfo info = admin.getBackupInfo(backupId);
                System.out.println(info.getShortDescription());
            }
        }
    }

    private static class HelpCommand
    extends Command {
        CommandLine cmdline;

        HelpCommand(Configuration conf, CommandLine cmdline) {
            super(conf);
            this.cmdline = cmdline;
        }

        @Override
        public void execute() throws IOException {
            String[] args;
            if (this.cmdline == null) {
                System.out.println(BackupCommands.USAGE);
                System.exit(0);
            }
            if ((args = this.cmdline.getArgs()) == null || args.length == 0) {
                System.out.println(BackupCommands.USAGE);
                System.exit(0);
            }
            if (args.length != 2) {
                System.out.println("Only support check help message of a single command type");
                System.out.println(BackupCommands.USAGE);
                System.exit(0);
            }
            String type = args[1];
            if (BackupRestoreConstants.BackupCommand.CREATE.name().equalsIgnoreCase(type)) {
                System.out.println(BackupCommands.CREATE_CMD_USAGE);
            } else if (BackupRestoreConstants.BackupCommand.DESCRIBE.name().equalsIgnoreCase(type)) {
                System.out.println(BackupCommands.DESCRIBE_CMD_USAGE);
            } else if (BackupRestoreConstants.BackupCommand.HISTORY.name().equalsIgnoreCase(type)) {
                System.out.println(BackupCommands.HISTORY_CMD_USAGE);
            } else if (BackupRestoreConstants.BackupCommand.PROGRESS.name().equalsIgnoreCase(type)) {
                System.out.println(BackupCommands.PROGRESS_CMD_USAGE);
            } else if (BackupRestoreConstants.BackupCommand.DELETE.name().equalsIgnoreCase(type)) {
                System.out.println(BackupCommands.DELETE_CMD_USAGE);
            } else if (BackupRestoreConstants.BackupCommand.CANCEL.name().equalsIgnoreCase(type)) {
                System.out.println(BackupCommands.CANCEL_CMD_USAGE);
            } else if (BackupRestoreConstants.BackupCommand.SET.name().equalsIgnoreCase(type)) {
                System.out.println(BackupCommands.SET_CMD_USAGE);
            } else {
                System.out.println("Unknown command : " + type);
                System.out.println(BackupCommands.USAGE);
            }
            System.exit(0);
        }
    }

    public static class CreateCommand
    extends Command {
        CommandLine cmdline;

        CreateCommand(Configuration conf, CommandLine cmdline) {
            super(conf);
            this.cmdline = cmdline;
        }

        @Override
        public void execute() throws IOException {
            Configuration conf;
            String[] args;
            if (this.cmdline == null || this.cmdline.getArgs() == null) {
                System.out.println("ERROR: missing arguments");
                System.out.println(BackupCommands.CREATE_CMD_USAGE);
                System.exit(-1);
            }
            if ((args = this.cmdline.getArgs()).length < 3 || args.length > 4) {
                System.out.println("ERROR: wrong number of arguments");
                System.out.println(BackupCommands.CREATE_CMD_USAGE);
                System.exit(-1);
            }
            if (!BackupType.FULL.toString().equalsIgnoreCase(args[1]) && !BackupType.INCREMENTAL.toString().equalsIgnoreCase(args[1])) {
                System.out.println("ERROR: invalid backup type");
                System.out.println(BackupCommands.CREATE_CMD_USAGE);
                System.exit(-1);
            }
            String tables = null;
            Configuration configuration = conf = this.getConf() != null ? this.getConf() : HBaseConfiguration.create();
            if (this.cmdline.hasOption("set")) {
                String setName = this.cmdline.getOptionValue("set");
                tables = this.getTablesForSet(setName, conf);
                if (tables == null) {
                    throw new IOException("Backup set '" + setName + "' is either empty or does not exist");
                }
            } else {
                tables = args.length == 4 ? args[3] : null;
            }
            int bandwidth = this.cmdline.hasOption('b') ? Integer.parseInt(this.cmdline.getOptionValue('b')) : -1;
            int workers = this.cmdline.hasOption('w') ? Integer.parseInt(this.cmdline.getOptionValue('w')) : -1;
            try (Connection conn = ConnectionFactory.createConnection(this.getConf());
                 Admin admin = conn.getAdmin();
                 BackupAdmin backupAdmin = admin.getBackupAdmin();){
                BackupRequest request = new BackupRequest();
                request.setBackupType(BackupType.valueOf((String)args[1].toUpperCase())).setTableList(tables != null ? Lists.newArrayList((Object[])BackupClientUtil.parseTableNames(tables)) : null).setTargetRootDir(args[2]).setWorkers(workers).setBandwidth(bandwidth);
                String backupId = backupAdmin.backupTables(request);
                System.out.println("Backup session " + backupId + " finished. Status: SUCCESS");
            }
            catch (IOException e) {
                System.out.println("Backup session finished. Status: FAILURE");
                throw e;
            }
        }

        /*
         * Exception decompiling
         */
        private String getTablesForSet(String name, Configuration conf) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static abstract class Command
    extends Configured {
        Command(Configuration conf) {
            super(conf);
        }

        public abstract void execute() throws IOException;
    }
}

