/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.BackupInfo;
import org.apache.hadoop.hbase.backup.impl.BackupSystemTableHelper;
import org.apache.hadoop.hbase.backup.util.BackupClientUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.BackupProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class BackupSystemTable
implements Closeable {
    private static final Log LOG = LogFactory.getLog(BackupSystemTable.class);
    private static final TableName tableName = TableName.BACKUP_TABLE_NAME;
    static final byte[] SESSIONS_FAMILY = "session".getBytes();
    static final byte[] META_FAMILY = "meta".getBytes();
    private final Connection connection;

    public BackupSystemTable(Connection conn) throws IOException {
        this.connection = conn;
    }

    @Override
    public void close() {
    }

    public void updateBackupInfo(BackupInfo context) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("update backup status in hbase:backup for: " + context.getBackupId() + " set status=" + (Object)((Object)context.getState())));
        }
        try (Table table = this.connection.getTable(tableName);){
            Put put = BackupSystemTableHelper.createPutForBackupContext(context);
            table.put(put);
        }
    }

    public void deleteBackupInfo(String backupId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("delete backup status in hbase:backup for " + backupId));
        }
        try (Table table = this.connection.getTable(tableName);){
            Delete del = BackupSystemTableHelper.createDeleteForBackupInfo(backupId);
            table.delete(del);
        }
    }

    public BackupInfo readBackupInfo(String backupId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("read backup status from hbase:backup for: " + backupId));
        }
        try (Table table = this.connection.getTable(tableName);){
            Get get = BackupSystemTableHelper.createGetForBackupContext(backupId);
            Result res = table.get(get);
            if (res.isEmpty()) {
                BackupInfo backupInfo = null;
                return backupInfo;
            }
            BackupInfo backupInfo = BackupSystemTableHelper.resultToBackupInfo(res);
            return backupInfo;
        }
    }

    public String readBackupStartCode(String backupRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"read backup start code from hbase:backup");
        }
        try (Table table = this.connection.getTable(tableName);){
            Get get = BackupSystemTableHelper.createGetForStartCode(backupRoot);
            Result res = table.get(get);
            if (res.isEmpty()) {
                String string = null;
                return string;
            }
            Cell cell = res.listCells().get(0);
            byte[] val = CellUtil.cloneValue((Cell)cell);
            if (val.length == 0) {
                String string = null;
                return string;
            }
            String string = new String(val);
            return string;
        }
    }

    public void writeBackupStartCode(Long startCode, String backupRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("write backup start code to hbase:backup " + startCode));
        }
        try (Table table = this.connection.getTable(tableName);){
            Put put = BackupSystemTableHelper.createPutForStartCode(startCode.toString(), backupRoot);
            table.put(put);
        }
    }

    /*
     * Exception decompiling
     */
    public HashMap<String, Long> readRegionServerLastLogRollResult(String backupRoot) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeRegionServerLastLogRollResult(String server, Long ts, String backupRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"write region server last roll log result to hbase:backup");
        }
        try (Table table = this.connection.getTable(tableName);){
            Put put = BackupSystemTableHelper.createPutForRegionServerLastLogRollResult(server, ts, backupRoot);
            table.put(put);
        }
    }

    public ArrayList<BackupInfo> getBackupHistory(boolean onlyCompleted) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"get backup history from hbase:backup");
        }
        BackupInfo.BackupState state = onlyCompleted ? BackupInfo.BackupState.COMPLETE : BackupInfo.BackupState.ANY;
        ArrayList<BackupInfo> list = this.getBackupContexts(state);
        return BackupClientUtil.sortHistoryListDesc(list);
    }

    public ArrayList<BackupInfo> getBackupHistory() throws IOException {
        return this.getBackupHistory(false);
    }

    /*
     * Exception decompiling
     */
    public ArrayList<BackupInfo> getBackupContexts(BackupInfo.BackupState status) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void writeRegionServerLogTimestamp(Set<TableName> tables, HashMap<String, Long> newTimestamps, String backupRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("write RS log time stamps to hbase:backup for tables [" + StringUtils.join(tables, (String)",") + "]"));
        }
        ArrayList<Put> puts = new ArrayList<Put>();
        for (TableName table : tables) {
            byte[] smapData = this.toTableServerTimestampProto(table, newTimestamps).toByteArray();
            Put put = BackupSystemTableHelper.createPutForWriteRegionServerLogTimestamp(table, smapData, backupRoot);
            puts.add(put);
        }
        try (Table table = this.connection.getTable(tableName);){
            table.put(puts);
        }
    }

    /*
     * Exception decompiling
     */
    public HashMap<TableName, HashMap<String, Long>> readLogTimestampMap(String backupRoot) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BackupProtos.TableServerTimestamp toTableServerTimestampProto(TableName table, Map<String, Long> map) {
        BackupProtos.TableServerTimestamp.Builder tstBuilder = BackupProtos.TableServerTimestamp.newBuilder();
        tstBuilder.setTable(ProtobufUtil.toProtoTableName(table));
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            BackupProtos.ServerTimestamp.Builder builder = BackupProtos.ServerTimestamp.newBuilder();
            builder.setServer(entry.getKey());
            builder.setTimestamp(entry.getValue().longValue());
            tstBuilder.addServerTimestamp(builder.build());
        }
        return tstBuilder.build();
    }

    private HashMap<String, Long> fromTableServerTimestampProto(BackupProtos.TableServerTimestamp proto) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        List list = proto.getServerTimestampList();
        for (BackupProtos.ServerTimestamp st : list) {
            map.put(st.getServer(), st.getTimestamp());
        }
        return map;
    }

    public Set<TableName> getIncrementalBackupTableSet(String backupRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"get incr backup table set from hbase:backup");
        }
        TreeSet<TableName> set = new TreeSet<TableName>();
        try (Table table = this.connection.getTable(tableName);){
            Get get = BackupSystemTableHelper.createGetForIncrBackupTableSet(backupRoot);
            Result res = table.get(get);
            if (res.isEmpty()) {
                TreeSet<TableName> treeSet = set;
                return treeSet;
            }
            List<Cell> cells = res.listCells();
            for (Cell cell : cells) {
                set.add(TableName.valueOf((byte[])CellUtil.cloneQualifier((Cell)cell)));
            }
            TreeSet<TableName> treeSet = set;
            return treeSet;
        }
    }

    public void addIncrementalBackupTableSet(Set<TableName> tables, String backupRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Add incremental backup table set to hbase:backup. ROOT=" + backupRoot + " tables [" + StringUtils.join(tables, (String)" ") + "]"));
            for (TableName table : tables) {
                LOG.debug((Object)table);
            }
        }
        try (Table table = this.connection.getTable(tableName);){
            Put put = BackupSystemTableHelper.createPutForIncrBackupTableSet(tables, backupRoot);
            table.put(put);
        }
    }

    public void addWALFiles(List<String> files, String backupId, String backupRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("add WAL files to hbase:backup: " + backupId + " " + backupRoot + " files [" + StringUtils.join(files, (String)",") + "]"));
            for (String f : files) {
                LOG.debug((Object)("add :" + f));
            }
        }
        try (Table table = this.connection.getTable(tableName);){
            List<Put> puts = BackupSystemTableHelper.createPutsForAddWALFiles(files, backupId, backupRoot);
            table.put(puts);
        }
    }

    public Iterator<WALItem> getWALFilesIterator(String backupRoot) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"get WAL files from hbase:backup");
        }
        final Table table = this.connection.getTable(tableName);
        Scan scan = BackupSystemTableHelper.createScanForGetWALs(backupRoot);
        final ResultScanner scanner = table.getScanner(scan);
        final Iterator it = scanner.iterator();
        return new Iterator<WALItem>(){

            @Override
            public boolean hasNext() {
                boolean next = it.hasNext();
                if (!next) {
                    try {
                        scanner.close();
                        table.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Close WAL Iterator", (Throwable)e);
                    }
                }
                return next;
            }

            @Override
            public WALItem next() {
                Result next = (Result)it.next();
                List<Cell> cells = next.listCells();
                byte[] buf = cells.get(0).getValueArray();
                int len = cells.get(0).getValueLength();
                int offset = cells.get(0).getValueOffset();
                String backupId = new String(buf, offset, len);
                buf = cells.get(1).getValueArray();
                len = cells.get(1).getValueLength();
                offset = cells.get(1).getValueOffset();
                String walFile = new String(buf, offset, len);
                buf = cells.get(2).getValueArray();
                len = cells.get(2).getValueLength();
                offset = cells.get(2).getValueOffset();
                String backupRoot = new String(buf, offset, len);
                return new WALItem(backupId, walFile, backupRoot);
            }

            @Override
            public void remove() {
                throw new RuntimeException("remove is not supported");
            }
        };
    }

    public boolean isWALFileDeletable(String file) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Check if WAL file has been already backed up in hbase:backup " + file));
        }
        try (Table table = this.connection.getTable(tableName);){
            Get get = BackupSystemTableHelper.createGetForCheckWALFile(file);
            Result res = table.get(get);
            if (res.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean hasBackupSessions() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listBackupSets() throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)" Backup set list");
        }
        ArrayList<String> list = new ArrayList<String>();
        Table table = null;
        ResultScanner scanner = null;
        try {
            table = this.connection.getTable(tableName);
            Scan scan = BackupSystemTableHelper.createScanForBackupSetList();
            scan.setMaxVersions(1);
            scanner = table.getScanner(scan);
            Result res = null;
            while ((res = scanner.next()) != null) {
                res.advance();
                list.add(BackupSystemTableHelper.cellKeyToBackupSetName(res.current()));
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableName> describeBackupSet(String name) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" Backup set describe: " + name));
        }
        try (Table table = null;){
            table = this.connection.getTable(tableName);
            Get get = BackupSystemTableHelper.createGetForBackupSet(name);
            Result res = table.get(get);
            if (res.isEmpty()) {
                List<TableName> list = null;
                return list;
            }
            res.advance();
            String[] tables = BackupSystemTableHelper.cellValueToBackupSet(res.current());
            List<TableName> list = this.toList(tables);
            return list;
        }
    }

    private List<TableName> toList(String[] tables) {
        ArrayList<TableName> list = new ArrayList<TableName>(tables.length);
        for (String name : tables) {
            list.add(TableName.valueOf((String)name));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToBackupSet(String name, String[] newTables) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Backup set add: " + name + " tables [" + StringUtils.join((Object[])newTables, (String)" ") + "]"));
        }
        String[] union = null;
        try (Table table = null;){
            table = this.connection.getTable(tableName);
            Get get = BackupSystemTableHelper.createGetForBackupSet(name);
            Result res = table.get(get);
            if (res.isEmpty()) {
                union = newTables;
            } else {
                res.advance();
                String[] tables = BackupSystemTableHelper.cellValueToBackupSet(res.current());
                union = this.merge(tables, newTables);
            }
            Put put = BackupSystemTableHelper.createPutForBackupSet(name, union);
            table.put(put);
        }
    }

    private String[] merge(String[] tables, String[] newTables) {
        ArrayList<String> list = new ArrayList<String>();
        for (String t : tables) {
            list.add(t);
        }
        for (String nt : newTables) {
            if (list.contains(nt)) continue;
            list.add(nt);
        }
        String[] arr = new String[list.size()];
        list.toArray(arr);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromBackupSet(String name, String[] toRemove) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" Backup set remove from : " + name + " tables [" + StringUtils.join((Object[])toRemove, (String)" ") + "]"));
        }
        String[] disjoint = null;
        try (Table table = null;){
            table = this.connection.getTable(tableName);
            Get get = BackupSystemTableHelper.createGetForBackupSet(name);
            Result res = table.get(get);
            if (res.isEmpty()) {
                LOG.warn((Object)("Backup set '" + name + "' not found."));
                return;
            }
            res.advance();
            String[] tables = BackupSystemTableHelper.cellValueToBackupSet(res.current());
            disjoint = this.disjoin(tables, toRemove);
            if (disjoint.length > 0) {
                Put put = BackupSystemTableHelper.createPutForBackupSet(name, disjoint);
                table.put(put);
            } else {
                LOG.warn((Object)("Backup set '" + name + "' does not contain tables [" + StringUtils.join((Object[])toRemove, (String)" ") + "]"));
            }
        }
    }

    private String[] disjoin(String[] tables, String[] toRemove) {
        ArrayList<String> list = new ArrayList<String>();
        for (String t : tables) {
            list.add(t);
        }
        for (String nt : toRemove) {
            if (!list.contains(nt)) continue;
            list.remove(nt);
        }
        String[] arr = new String[list.size()];
        list.toArray(arr);
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBackupSet(String name) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(" Backup set delete: " + name));
        }
        try (Table table = null;){
            table = this.connection.getTable(tableName);
            Delete del = BackupSystemTableHelper.createDeleteForBackupSet(name);
            table.delete(del);
        }
    }

    public static HTableDescriptor getSystemTableDescriptor() {
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        HColumnDescriptor colSessionsDesc = new HColumnDescriptor(SESSIONS_FAMILY);
        colSessionsDesc.setMaxVersions(1);
        Configuration config = HBaseConfiguration.create();
        int ttl = config.getInt("hbase.backup.system.ttl", Integer.MAX_VALUE);
        colSessionsDesc.setTimeToLive(ttl);
        tableDesc.addFamily(colSessionsDesc);
        HColumnDescriptor colMetaDesc = new HColumnDescriptor(META_FAMILY);
        tableDesc.addFamily(colMetaDesc);
        return tableDesc;
    }

    public static String getTableNameAsString() {
        return tableName.getNameAsString();
    }

    public static TableName getTableName() {
        return tableName;
    }

    static class WALItem {
        String backupId;
        String walFile;
        String backupRoot;

        WALItem(String backupId, String walFile, String backupRoot) {
            this.backupId = backupId;
            this.walFile = walFile;
            this.backupRoot = backupRoot;
        }

        public String getBackupId() {
            return this.backupId;
        }

        public String getWalFile() {
            return this.walFile;
        }

        public String getBackupRoot() {
            return this.backupRoot;
        }

        public String toString() {
            return "/" + this.backupRoot + "/" + this.backupId + "/" + this.walFile;
        }
    }
}

