/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.command.coord.CoordChangeXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.StatusUtils;

public class BundleJobChangeXCommand
extends XCommand<Void> {
    private String jobId;
    private String changeValue;
    private List<BundleActionBean> bundleActions;
    private BundleJobBean bundleJob;
    private Date newPauseTime = null;
    private Date newEndTime = null;
    boolean isChangePauseTime = false;
    boolean isChangeEndTime = false;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
    private static final Set<String> ALLOWED_CHANGE_OPTIONS = new HashSet<String>();

    public BundleJobChangeXCommand(String id, String changeValue) throws CommandException {
        super("bundle_change", "bundle_change", 1);
        this.jobId = ParamChecker.notEmpty(id, "id");
        this.changeValue = ParamChecker.notEmpty(changeValue, "changeValue");
    }

    private void checkPauseTime(Date newPauseTime) throws CommandException {
        Date d = new Date();
        if (newPauseTime.before(d)) {
            throw new CommandException(ErrorCode.E1317, newPauseTime, "must be a non-past time");
        }
    }

    private void checkEndTime(Date newEndTime) throws CommandException {
        Date startTime = this.bundleJob.getKickoffTime();
        if (startTime != null && newEndTime.before(startTime)) {
            throw new CommandException(ErrorCode.E1317, newEndTime, "must be greater then kickoff time");
        }
    }

    private void validateChangeValue(String changeValue) throws CommandException {
        String value;
        Map<String, String> map = JobUtils.parseChangeValue(changeValue);
        if (map.size() > ALLOWED_CHANGE_OPTIONS.size() || !map.containsKey("pausetime") && !map.containsKey("endtime")) {
            throw new CommandException(ErrorCode.E1317, changeValue, "can only change pausetime or end time");
        }
        if (map.containsKey("pausetime")) {
            this.isChangePauseTime = true;
        } else if (map.containsKey("endtime")) {
            this.isChangeEndTime = true;
        } else {
            throw new CommandException(ErrorCode.E1317, changeValue, "should change pausetime or endtime");
        }
        if (this.isChangePauseTime) {
            String value2 = map.get("pausetime");
            if (!value2.equals("")) {
                try {
                    this.newPauseTime = DateUtils.parseDateOozieTZ(value2);
                }
                catch (Exception ex) {
                    throw new CommandException(ErrorCode.E1317, value2, "is not a valid date");
                }
                this.checkPauseTime(this.newPauseTime);
            }
        } else if (this.isChangeEndTime && !(value = map.get("endtime")).equals("")) {
            try {
                this.newEndTime = DateUtils.parseDateOozieTZ(value);
            }
            catch (Exception ex) {
                throw new CommandException(ErrorCode.E1317, value, "is not a valid date");
            }
            this.checkEndTime(this.newEndTime);
        }
    }

    @Override
    protected Void execute() throws CommandException {
        StringBuffer changeReport = new StringBuffer();
        try {
            if (this.isChangePauseTime || this.isChangeEndTime) {
                if (this.isChangePauseTime) {
                    this.bundleJob.setPauseTime(this.newPauseTime);
                } else if (this.isChangeEndTime) {
                    this.bundleJob.setEndTime(this.newEndTime);
                    if (this.bundleJob.getStatus() == Job.Status.SUCCEEDED) {
                        this.bundleJob.setStatus(Job.Status.RUNNING);
                    }
                    if (this.bundleJob.getStatus() == Job.Status.DONEWITHERROR || this.bundleJob.getStatus() == Job.Status.FAILED) {
                        this.bundleJob.setStatus(StatusUtils.getStatusIfBackwardSupportTrue(Job.Status.RUNNINGWITHERROR));
                    }
                }
                for (BundleActionBean action : this.bundleActions) {
                    if (action.getStatus() != Job.Status.KILLED && action.getCoordId() != null) {
                        try {
                            new CoordChangeXCommand(action.getCoordId(), this.changeValue).call();
                        }
                        catch (Exception e) {
                            String errorMsg = action.getCoordId() + " : " + e.getMessage();
                            this.LOG.info("Change command failed " + errorMsg);
                            changeReport.append("[ ").append(errorMsg).append(" ]");
                        }
                        continue;
                    }
                    String errorMsg = action.getCoordId() + " : Coord is in killed state";
                    this.LOG.info("Change command failed " + errorMsg);
                    changeReport.append("[ ").append(errorMsg).append(" ]");
                }
                this.updateList.add(new BatchQueryExecutor.UpdateEntry<BundleJobQueryExecutor.BundleJobQuery>(BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PAUSE_ENDTIME, this.bundleJob));
                BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
            }
            if (!changeReport.toString().isEmpty()) {
                throw new CommandException(ErrorCode.E1320, changeReport.toString());
            }
            return null;
        }
        catch (XException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, this.bundleJob.getId());
            this.bundleActions = BundleActionQueryExecutor.getInstance().getList(BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_ACTIONS_STATUS_UNIGNORED_FOR_BUNDLE, this.bundleJob.getId());
        }
        catch (JPAExecutorException Ex) {
            throw new CommandException(ErrorCode.E1311, this.jobId);
        }
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        try {
            this.bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, this.jobId);
            LogUtils.setLogInfo(this.bundleJob);
        }
        catch (JPAExecutorException ex) {
            throw new CommandException(ex);
        }
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        this.validateChangeValue(this.changeValue);
        if (this.bundleJob == null) {
            this.LOG.info("BundleChangeCommand not succeeded - job " + this.jobId + " does not exist");
            throw new PreconditionException(ErrorCode.E1314, this.jobId);
        }
        if (this.isChangePauseTime) {
            if (this.bundleJob.getStatus() == Job.Status.SUCCEEDED || this.bundleJob.getStatus() == Job.Status.FAILED || this.bundleJob.getStatus() == Job.Status.KILLED || this.bundleJob.getStatus() == Job.Status.DONEWITHERROR) {
                this.LOG.info("BundleChangeCommand not succeeded for changing pausetime- job " + this.jobId + " finished, status is " + this.bundleJob.getStatusStr());
                throw new PreconditionException(ErrorCode.E1312, this.jobId, this.bundleJob.getStatus().toString());
            }
        } else if (this.isChangeEndTime && this.bundleJob.getStatus() == Job.Status.KILLED) {
            this.LOG.info("BundleChangeCommand not succeeded for changing endtime- job " + this.jobId + " finished, status is " + this.bundleJob.getStatusStr());
            throw new PreconditionException(ErrorCode.E1312, this.jobId, this.bundleJob.getStatus().toString());
        }
    }

    static {
        ALLOWED_CHANGE_OPTIONS.add("pausetime");
        ALLOWED_CHANGE_OPTIONS.add("endtime");
    }
}

