/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.wf.WorkflowNotificationXCommand;
import org.apache.oozie.command.wf.WorkflowXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionRetryManualGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;

public class SuspendXCommand
extends WorkflowXCommand<Void> {
    private final String wfid;
    private WorkflowJobBean wfJobBean;
    private JPAService jpaService;
    private List<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();

    public SuspendXCommand(String id) {
        super("suspend", "suspend", 1);
        this.wfid = ParamChecker.notEmpty(id, "wfid");
    }

    @Override
    protected void setLogInfo() {
        LogUtils.setLogInfo(this.wfid);
    }

    @Override
    protected Void execute() throws CommandException {
        InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
        try {
            SuspendXCommand.suspendJob(this.jpaService, this.wfJobBean, this.wfid, null, this.updateList);
            this.wfJobBean.setLastModifiedTime(new Date());
            this.updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowJobQueryExecutor.WorkflowJobQuery>(WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, this.wfJobBean));
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(null, this.updateList, null);
            this.queue(new WorkflowNotificationXCommand(this.wfJobBean));
            this.suspendParentWorkFlow();
        }
        catch (WorkflowException e) {
            throw new CommandException(e);
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
        finally {
            this.updateParentIfNecessary(this.wfJobBean);
        }
        return null;
    }

    private void suspendParentWorkFlow() throws CommandException {
        if (this.wfJobBean.getParentId() != null && this.wfJobBean.getParentId().contains("-W")) {
            new SuspendXCommand(this.wfJobBean.getParentId()).call();
        } else {
            this.updateParentIfNecessary(this.wfJobBean);
        }
    }

    public static void suspendJob(JPAService jpaService, WorkflowJobBean workflow, String id, String actionId, List<BatchQueryExecutor.UpdateEntry> updateList) throws WorkflowException, CommandException {
        if (workflow.getStatus() == WorkflowJob.Status.RUNNING) {
            workflow.getWorkflowInstance().suspend();
            WorkflowInstance wfInstance = workflow.getWorkflowInstance();
            ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.SUSPENDED);
            workflow.setStatus(WorkflowJob.Status.SUSPENDED);
            workflow.setWorkflowInstance(wfInstance);
            SuspendXCommand.setPendingFalseForActions(jpaService, id, actionId, updateList);
            if (EventHandlerService.isEnabled()) {
                SuspendXCommand.generateEvent(workflow);
            }
        }
    }

    private static void setPendingFalseForActions(JPAService jpaService, String id, String actionId, List<BatchQueryExecutor.UpdateEntry> updateList) throws CommandException {
        try {
            List<WorkflowActionBean> actions = jpaService.execute(new WorkflowActionRetryManualGetJPAExecutor(id));
            for (WorkflowActionBean action : actions) {
                if (actionId != null && actionId.equals(action.getId())) continue;
                action.resetPendingOnly();
                if (updateList == null) continue;
                updateList.add(new BatchQueryExecutor.UpdateEntry<WorkflowActionQueryExecutor.WorkflowActionQuery>(WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_STATUS_PENDING, action));
            }
        }
        catch (JPAExecutorException je) {
            throw new CommandException(je);
        }
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        try {
            this.jpaService = Services.get().get(JPAService.class);
            this.wfJobBean = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_STATUS, this.wfid);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
        LogUtils.setLogInfo(this.wfJobBean);
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        if (this.wfJobBean.getStatus() != WorkflowJob.Status.RUNNING) {
            throw new PreconditionException(ErrorCode.E0727, this.wfJobBean.getId(), this.wfJobBean.getStatus());
        }
    }

    @Override
    public String getEntityKey() {
        return this.wfid;
    }

    @Override
    public String getKey() {
        return this.getName() + "_" + this.wfid;
    }

    @Override
    protected boolean isLockRequired() {
        return true;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.wfJobBean = WorkflowJobQueryExecutor.getInstance().get(WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_SUSPEND, this.wfid);
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E0603, ex.getMessage(), ex);
        }
        LogUtils.setLogInfo(this.wfJobBean);
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
        this.eagerVerifyPrecondition();
    }
}

