/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.NotificationXCommand;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;

public class WorkflowNotificationXCommand
extends NotificationXCommand {
    private static final String STATUS_PATTERN = "\\$status";
    private static final String JOB_ID_PATTERN = "\\$jobId";
    private static final String NODE_NAME_PATTERN = "\\$nodeName";

    public WorkflowNotificationXCommand(WorkflowJobBean workflow) {
        super("job.notification", "job.notification", 0);
        ParamChecker.notNull(workflow, "workflow");
        this.jobId = workflow.getId();
        this.url = workflow.getWorkflowInstance().getConf().get("oozie.wf.workflow.notification.url");
        if (this.url != null) {
            this.url = this.url.replaceAll(JOB_ID_PATTERN, workflow.getId());
            this.url = this.url.replaceAll(STATUS_PATTERN, workflow.getStatus().toString());
            this.proxyConf = workflow.getWorkflowInstance().getConf().get("oozie.wf.workflow.notification.proxy", ConfigurationService.get("oozie.notification.proxy"));
            this.LOG.debug("Proxy :" + this.proxyConf);
        }
    }

    public WorkflowNotificationXCommand(WorkflowJobBean workflow, WorkflowActionBean action) {
        super("action.notification", "job.notification", 0);
        ParamChecker.notNull(workflow, "workflow");
        ParamChecker.notNull(action, "action");
        this.jobId = action.getId();
        this.url = workflow.getWorkflowInstance().getConf().get("oozie.wf.action.notification.url");
        if (this.url != null) {
            this.url = this.url.replaceAll(JOB_ID_PATTERN, workflow.getId());
            this.url = this.url.replaceAll(NODE_NAME_PATTERN, action.getName());
            this.url = action.isComplete() ? this.url.replaceAll(STATUS_PATTERN, "T:" + action.getTransition()) : this.url.replaceAll(STATUS_PATTERN, "S:" + action.getStatus().toString());
            this.proxyConf = workflow.getWorkflowInstance().getConf().get("oozie.wf.workflow.notification.proxy", ConfigurationService.get("oozie.notification.proxy"));
            this.LOG.debug("Proxy :" + this.proxyConf);
        }
    }

    @Override
    protected void loadState() throws CommandException {
        LogUtils.setLogInfo(this.jobId);
    }
}

