/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.DateUtils;

public class WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor
implements JPAExecutor<List<WorkflowJobBean>> {
    private String parentId;
    private int limit;
    private int offset;

    public WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor(String parentId, int limit) {
        this(parentId, 0, limit);
    }

    public WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor(String parentId, int offset, int limit) {
        this.parentId = parentId;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor";
    }

    @Override
    public List<WorkflowJobBean> execute(EntityManager em) throws JPAExecutorException {
        try {
            Query jobQ = em.createNamedQuery("GET_WORKFLOWS_BASIC_INFO_BY_COORD_PARENT_ID");
            jobQ.setParameter("parentId", (Object)(this.parentId + "%"));
            jobQ.setMaxResults(this.limit);
            jobQ.setFirstResult(this.offset);
            return this.getBeanFromArray(jobQ.getResultList());
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }

    private List<WorkflowJobBean> getBeanFromArray(List resultList) {
        ArrayList<WorkflowJobBean> wfActionBeanList = new ArrayList<WorkflowJobBean>();
        for (Object element : resultList) {
            WorkflowJobBean wfBean = new WorkflowJobBean();
            Object[] arr = (Object[])element;
            if (arr[0] != null) {
                wfBean.setId((String)arr[0]);
            }
            if (arr[1] != null) {
                wfBean.setStatus(WorkflowJob.Status.valueOf((String)((String)arr[1])));
            }
            if (arr[2] != null) {
                wfBean.setEndTime(DateUtils.toDate((Timestamp)arr[2]));
            }
            wfActionBeanList.add(wfBean);
        }
        return wfActionBeanList;
    }
}

