/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XLog;

public class SparkConfigurationService
implements Service {
    private static XLog LOG = XLog.getLog(SparkConfigurationService.class);
    public static final String SPARK_CONFIGURATION = "oozie.service.SparkConfigurationService.spark.configurations";
    private Map<String, Map<String, String>> sparkConfigs;
    private static final String SPARK_CONFIG_FILE = "spark-defaults.conf";

    @Override
    public void init(Services services) throws ServiceException {
        this.loadSparkConfigs();
    }

    @Override
    public void destroy() {
        this.sparkConfigs.clear();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return SparkConfigurationService.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSparkConfigs() throws ServiceException {
        this.sparkConfigs = new HashMap<String, Map<String, String>>();
        File configDir = new File(ConfigurationService.getConfigurationDirectory());
        String[] confDefs = ConfigurationService.getStrings(SPARK_CONFIGURATION);
        if (confDefs != null) {
            for (String confDef : confDefs) {
                if (confDef.trim().length() <= 0) continue;
                String[] parts = confDef.split("=");
                if (parts.length == 2) {
                    String hostPort = parts[0];
                    String confDir = parts[1];
                    File dir = new File(confDir);
                    if (!dir.isAbsolute()) {
                        dir = new File(configDir, confDir);
                    }
                    if (dir.exists()) {
                        File file = new File(dir, SPARK_CONFIG_FILE);
                        if (file.exists()) {
                            Properties props = new Properties();
                            FileReader fr = null;
                            try {
                                fr = new FileReader(file);
                                props.load(fr);
                                fr.close();
                                this.sparkConfigs.put(hostPort, this.propsToMap(props));
                                LOG.info("Loaded Spark Configuration: {0}={1}", hostPort, file.getAbsolutePath());
                            }
                            catch (IOException ioe) {
                                try {
                                    LOG.warn("Spark Configuration could not be loaded for {0}: {1}", hostPort, ioe.getMessage(), ioe);
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeSafely(fr);
                                    throw throwable;
                                }
                                IOUtils.closeSafely(fr);
                                continue;
                            }
                            IOUtils.closeSafely(fr);
                            continue;
                        }
                        LOG.warn("Spark Configuration could not be loaded for {0}: {1} does not exist", hostPort, file.getAbsolutePath());
                        continue;
                    }
                    LOG.warn("Spark Configuration could not be loaded for {0}: {1} does not exist", hostPort, dir.getAbsolutePath());
                    continue;
                }
                LOG.warn("Spark Configuration could not be loaded: invalid value found: {0}", confDef);
            }
        } else {
            LOG.info("Spark Configuration(s) not specified");
        }
    }

    private Map<String, String> propsToMap(Properties props) {
        HashMap<String, String> map = new HashMap<String, String>(props.size());
        for (String key : props.stringPropertyNames()) {
            map.put(key, props.getProperty(key));
        }
        return map;
    }

    public Map<String, String> getSparkConfig(String resourceManagerHostPort) {
        resourceManagerHostPort = resourceManagerHostPort != null ? resourceManagerHostPort.toLowerCase() : null;
        Map<String, String> config = this.sparkConfigs.get(resourceManagerHostPort);
        if (config == null && (config = this.sparkConfigs.get("*")) == null) {
            config = new HashMap<String, String>();
        }
        return config;
    }
}

