/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.util.XLog;

public class XLogUtil {
    private String logPath;
    private String logFileName;
    private boolean isLogOverEnable = true;
    private int logRotation;
    public static XLog log = new XLog(LogFactory.getLog(XLogUtil.class));

    public XLogUtil(Configuration conf, String logType) {
        this.extractInfoForLogWebService(conf, logType);
    }

    private void extractInfoForLogWebService(Configuration conf, String logType) {
        String logFile = conf.get("log4j.appender." + logType + ".File");
        if (logFile == null) {
            log.warn("Oozie WS " + logType + " log will be disabled, missing property 'log4j.appender.oozie.File' for 'oozie' " + "appender");
            this.isLogOverEnable = false;
        } else {
            int i = (logFile = logFile.trim()).lastIndexOf("/");
            if (i == -1) {
                log.warn("Oozie WS " + logType + " log will be disabled, log file is not an absolute path [{0}] for 'oozie' appender", logFile);
                this.isLogOverEnable = false;
            } else {
                String appenderClass = conf.get("log4j.appender." + logType);
                if (appenderClass == null) {
                    log.warn("Oozie WS " + logType + " log will be disabled, missing property [log4j.appender.oozie]");
                    this.isLogOverEnable = false;
                } else if (appenderClass.equals("org.apache.log4j.DailyRollingFileAppender")) {
                    String pattern = conf.get("log4j.appender." + logType + ".DatePattern");
                    if (pattern == null) {
                        log.warn("Oozie WS " + logType + " log will be disabled, missing property [log4j.appender." + logType + ".DatePattern]");
                        this.isLogOverEnable = false;
                    } else {
                        if ((pattern = pattern.trim()).endsWith("HH")) {
                            this.logRotation = 3600;
                        } else if (pattern.endsWith("dd")) {
                            this.logRotation = 86400;
                        } else {
                            log.warn("Oozie WS " + logType + " log will be disabled, DatePattern [{0}] should end with 'HH' or 'dd'", pattern);
                            this.isLogOverEnable = false;
                        }
                        if (this.logRotation > 0) {
                            this.logPath = logFile.substring(0, i);
                            this.logFileName = logFile.substring(i + 1);
                        }
                    }
                } else if (appenderClass.equals("org.apache.log4j.rolling.RollingFileAppender")) {
                    String pattern = conf.get("log4j.appender." + logType + ".RollingPolicy.FileNamePattern");
                    if (pattern == null) {
                        log.warn("Oozie WS " + logType + " log will be disabled, missing property " + "[log4j.appender." + logType + ".RollingPolicy.FileNamePattern]");
                        this.isLogOverEnable = false;
                    } else {
                        if ((pattern = pattern.trim()).matches(Pattern.quote(logFile) + ".*-%d\\{yyyy-MM-dd-HH\\}(\\.gz)?")) {
                            this.logRotation = 3600;
                        } else {
                            log.warn("Oozie WS " + logType + " log will be disabled, RollingPolicy.FileNamePattern [{0}] should end with " + "'-%d{yyyy-MM-dd-HH}' or '-%d{yyyy-MM-dd-HH}.gz' and also start with the value of " + "log4j.appender." + logType + ".File [{1}]", pattern, logFile);
                            this.isLogOverEnable = false;
                        }
                        if (this.logRotation > 0) {
                            this.logPath = logFile.substring(0, i);
                            this.logFileName = logFile.substring(i + 1);
                        }
                    }
                } else {
                    log.warn("Oozie WS " + logType + " log will be disabled, log4j.appender.oozie [" + appenderClass + "] should be " + "either org.apache.log4j.DailyRollingFileAppender or org.apache.log4j.rolling.RollingFileAppender " + "to enable it");
                    this.isLogOverEnable = false;
                }
            }
        }
    }

    public String getLogPath() {
        return this.logPath;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public boolean isLogOverEnable() {
        return this.isLogOverEnable;
    }

    public int getLogRotation() {
        return this.logRotation;
    }
}

