/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.VisualizationImageServer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.util.ArrowFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections15.Transformer;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.util.XLog;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class GraphGenerator {
    private String xml;
    private WorkflowJobBean job;
    private boolean showKill = false;
    private final int actionsLimit = 25;

    public GraphGenerator(String xml, WorkflowJobBean job, boolean showKill) {
        if (job == null) {
            throw new IllegalArgumentException("JsonWorkflowJob can't be null");
        }
        this.xml = xml;
        this.job = job;
        this.showKill = showKill;
    }

    public GraphGenerator(String xml, WorkflowJobBean job) {
        this(xml, job, false);
    }

    public final void finalize() {
    }

    public void write(OutputStream out) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(new XMLParser(out));
        xmlReader.parse(new InputSource(new StringReader(this.xml)));
    }

    private class XMLParser
    extends DefaultHandler {
        private OutputStream out;
        private LinkedHashMap<String, OozieWFNode> tags;
        private String action = null;
        private String actionOK = null;
        private String actionErr = null;
        private String actionType = null;
        private String fork;
        private String decision;

        public XMLParser(OutputStream out) {
            this.out = out;
        }

        @Override
        public void startDocument() throws SAXException {
            this.tags = new LinkedHashMap();
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.tags.isEmpty()) {
                return;
            }
            int maxX = Integer.MIN_VALUE;
            int maxY = Integer.MIN_VALUE;
            int minX = Integer.MAX_VALUE;
            int currX = 45;
            int currY = 45;
            int xMargin = 205;
            int yMargin = 50;
            int xIncr = 215;
            int yIncr = 255;
            HashMap<String, WorkflowAction> actionMap = new HashMap<String, WorkflowAction>();
            boolean found = false;
            for (WorkflowAction wfAction : GraphGenerator.this.job.getActions()) {
                actionMap.put(wfAction.getName(), wfAction);
                if (found) continue;
                switch (wfAction.getStatus()) {
                    case KILLED: 
                    case ERROR: 
                    case FAILED: {
                        GraphGenerator.this.showKill = true;
                        found = true;
                    }
                }
            }
            DirectedSparseGraph dg = new DirectedSparseGraph();
            for (Map.Entry<String, OozieWFNode> entry : this.tags.entrySet()) {
                String name = entry.getKey();
                OozieWFNode node = entry.getValue();
                if (actionMap.containsKey(name)) {
                    node.setStatus(((WorkflowAction)actionMap.get(name)).getStatus());
                }
                if (node.getLocation().equals(new Point(0, 0))) {
                    node.setLocation(currX, currY);
                }
                float childStep = GraphGenerator.this.showKill ? -(((float)node.getArcs().size() - 1.0f) / 2.0f) : -((float)node.getArcs().size() / 2.0f - 1.0f);
                int nodeX = node.getLocation().x;
                int nodeY = node.getLocation().y;
                for (Map.Entry<String, Boolean> arc : node.getArcs().entrySet()) {
                    OozieWFNode child;
                    if (!GraphGenerator.this.showKill && arc.getValue().booleanValue() && this.tags.get(arc.getKey()).getType().equals("kill") || (child = this.tags.get(arc.getKey())) == null) continue;
                    dg.addEdge((Object)(name + "-->" + arc.getKey()), (Object)node, (Object)child);
                    int childX = (int)((float)nodeX + childStep * 215.0f);
                    int childY = nodeY + 255;
                    child.setLocation(childX, childY);
                    if (minX > childX) {
                        minX = childX;
                    }
                    if (maxX < childX) {
                        maxX = childX;
                    }
                    if (maxY < childY) {
                        maxY = childY;
                    }
                    childStep += 1.0f;
                }
                currY += 255;
                currX = nodeX;
                if (minX > nodeX) {
                    minX = nodeX;
                }
                if (maxX < nodeX) {
                    maxX = nodeX;
                }
                if (maxY >= nodeY) continue;
                maxY = nodeY;
            }
            final int padX = minX < 0 ? -minX : 0;
            Transformer<OozieWFNode, Point2D> locationInit = new Transformer<OozieWFNode, Point2D>(){

                public Point2D transform(OozieWFNode node) {
                    if (padX == 0) {
                        return node.getLocation();
                    }
                    return new Point(node.getLocation().x + padX + 205, node.getLocation().y);
                }
            };
            StaticLayout layout = new StaticLayout((Graph)dg, (Transformer)locationInit, new Dimension(maxX + padX + 205, maxY));
            layout.lock(true);
            VisualizationImageServer vis = new VisualizationImageServer((Layout)layout, new Dimension(maxX + padX + 410, maxY + 50));
            vis.getRenderContext().setEdgeArrowTransformer((Transformer)new ArrowShapeTransformer());
            vis.getRenderContext().setArrowDrawPaintTransformer((Transformer)new ArcPaintTransformer());
            vis.getRenderContext().setEdgeDrawPaintTransformer((Transformer)new ArcPaintTransformer());
            vis.getRenderContext().setEdgeStrokeTransformer((Transformer)new ArcStrokeTransformer());
            vis.getRenderContext().setVertexShapeTransformer((Transformer)new NodeShapeTransformer());
            vis.getRenderContext().setVertexFillPaintTransformer((Transformer)new NodePaintTransformer());
            vis.getRenderContext().setVertexStrokeTransformer((Transformer)new NodeStrokeTransformer());
            vis.getRenderContext().setVertexLabelTransformer((Transformer)new NodeLabelTransformer());
            vis.getRenderContext().setVertexFontTransformer((Transformer)new NodeFontTransformer());
            vis.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
            vis.setBackground(Color.WHITE);
            Dimension d = vis.getSize();
            BufferedImage img = new BufferedImage(d.width, d.height, 1);
            Graphics2D g = img.createGraphics();
            vis.paintAll((Graphics)g);
            try {
                ImageIO.write((RenderedImage)img, "png", this.out);
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
            finally {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    XLog.getLog(this.getClass()).trace("Exception while closing OutputStream");
                }
                this.out = null;
                img.flush();
                g.dispose();
                vis.removeAll();
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String name;
            if (localName.equalsIgnoreCase("start")) {
                String start = localName.toLowerCase();
                if (!this.tags.containsKey(start)) {
                    OozieWFNode v = new OozieWFNode(start, start);
                    v.addArc(atts.getValue("to"));
                    this.tags.put(start, v);
                }
            } else if (localName.equalsIgnoreCase("action")) {
                this.action = atts.getValue("name");
            } else if (this.action != null && this.actionType == null) {
                this.actionType = localName.toLowerCase();
            } else if (localName.equalsIgnoreCase("ok") && this.action != null && this.actionOK == null) {
                this.actionOK = atts.getValue("to");
            } else if (localName.equalsIgnoreCase("error") && this.action != null && this.actionErr == null) {
                this.actionErr = atts.getValue("to");
            } else if (localName.equalsIgnoreCase("fork")) {
                this.fork = atts.getValue("name");
                if (!this.tags.containsKey(this.fork)) {
                    this.tags.put(this.fork, new OozieWFNode(this.fork, localName.toLowerCase()));
                }
            } else if (localName.equalsIgnoreCase("path")) {
                this.tags.get(this.fork).addArc(atts.getValue("start"));
            } else if (localName.equalsIgnoreCase("join")) {
                String join = atts.getValue("name");
                if (!this.tags.containsKey(join)) {
                    OozieWFNode v = new OozieWFNode(join, localName.toLowerCase());
                    v.addArc(atts.getValue("to"));
                    this.tags.put(join, v);
                }
            } else if (localName.equalsIgnoreCase("decision")) {
                this.decision = atts.getValue("name");
                if (!this.tags.containsKey(this.decision)) {
                    this.tags.put(this.decision, new OozieWFNode(this.decision, localName.toLowerCase()));
                }
            } else if (localName.equalsIgnoreCase("case") || localName.equalsIgnoreCase("default")) {
                this.tags.get(this.decision).addArc(atts.getValue("to"));
            } else if ((localName.equalsIgnoreCase("kill") || localName.equalsIgnoreCase("end")) && !this.tags.containsKey(name = atts.getValue("name"))) {
                this.tags.put(name, new OozieWFNode(name, localName.toLowerCase()));
            }
            if (this.tags.size() > 25) {
                this.tags.clear();
                throw new SAXException("Can't display the graph. Number of actions are more than display limit 25");
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equalsIgnoreCase("action")) {
                this.tags.put(this.action, new OozieWFNode(this.action, this.actionType));
                this.tags.get(this.action).addArc(this.actionOK);
                this.tags.get(this.action).addArc(this.actionErr, true);
                this.action = null;
                this.actionOK = null;
                this.actionErr = null;
                this.actionType = null;
            }
        }

        private class ArcStrokeTransformer
        implements Transformer<String, Stroke> {
            private final Stroke stroke1 = new BasicStroke(2.0f);
            private final Stroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);

            private ArcStrokeTransformer() {
            }

            public Stroke transform(String arc) {
                int sep = arc.indexOf("-->");
                String source = arc.substring(0, sep);
                String target = arc.substring(sep + 3);
                OozieWFNode src = (OozieWFNode)XMLParser.this.tags.get(source);
                if (src.getArcs().get(target).booleanValue()) {
                    if (src.getStatus() == null) {
                        return this.dashed;
                    }
                    switch (src.getStatus()) {
                        case KILLED: 
                        case ERROR: 
                        case FAILED: {
                            return this.stroke1;
                        }
                    }
                    return this.dashed;
                }
                return this.stroke1;
            }
        }

        private class NodeShapeTransformer
        implements Transformer<OozieWFNode, Shape> {
            private final Ellipse2D.Double circle = new Ellipse2D.Double(-40.0, -40.0, 80.0, 80.0);
            private final Rectangle rect = new Rectangle(-100, -30, 200, 60);
            private final Polygon diamond = new Polygon(new int[]{-75, 0, 75, 0}, new int[]{0, 75, 0, -75}, 4);
            private final Polygon triangle = new Polygon(new int[]{-85, 85, 0}, new int[]{0, 0, -148}, 3);
            private final Polygon invtriangle = new Polygon(new int[]{-85, 85, 0}, new int[]{0, 0, 148}, 3);

            private NodeShapeTransformer() {
            }

            public Shape transform(OozieWFNode node) {
                if ("start".equals(node.getType()) || "end".equals(node.getType()) || "kill".equals(node.getType())) {
                    return this.circle;
                }
                if ("fork".equals(node.getType())) {
                    return this.triangle;
                }
                if ("join".equals(node.getType())) {
                    return this.invtriangle;
                }
                if ("decision".equals(node.getType())) {
                    return this.diamond;
                }
                return this.rect;
            }
        }

        private class NodePaintTransformer
        implements Transformer<OozieWFNode, Paint> {
            private NodePaintTransformer() {
            }

            public Paint transform(OozieWFNode node) {
                WorkflowJob.Status jobStatus = GraphGenerator.this.job.getStatus();
                if (node.getType().equals("start")) {
                    return Color.WHITE;
                }
                if (node.getType().equals("end")) {
                    if (jobStatus == WorkflowJob.Status.SUCCEEDED) {
                        return Color.GREEN;
                    }
                    return Color.BLACK;
                }
                if (node.getType().equals("kill")) {
                    if (jobStatus == WorkflowJob.Status.FAILED || jobStatus == WorkflowJob.Status.KILLED) {
                        return Color.RED;
                    }
                    return Color.WHITE;
                }
                WorkflowAction.Status status = node.getStatus();
                if (status == null) {
                    return Color.LIGHT_GRAY;
                }
                switch (status) {
                    case OK: 
                    case DONE: 
                    case END_RETRY: 
                    case END_MANUAL: {
                        return Color.GREEN;
                    }
                    case PREP: 
                    case RUNNING: 
                    case USER_RETRY: 
                    case START_RETRY: 
                    case START_MANUAL: {
                        return Color.YELLOW;
                    }
                    case KILLED: 
                    case ERROR: 
                    case FAILED: {
                        return Color.RED;
                    }
                }
                return Color.LIGHT_GRAY;
            }
        }

        private class NodeLabelTransformer
        implements Transformer<OozieWFNode, String> {
            private NodeLabelTransformer() {
            }

            public String transform(OozieWFNode node) {
                String name = node.getName();
                String type = node.getType();
                StringBuilder s = new StringBuilder();
                if (type.equals("decision")) {
                    if (name.length() <= 14) {
                        return name;
                    }
                    s.append("<html>").append(name.substring(0, 12)).append("-<br />");
                    if (name.substring(13).length() > 14) {
                        s.append(name.substring(12, 25)).append("...");
                    } else {
                        s.append(name.substring(12));
                    }
                    s.append("</html>");
                    return s.toString();
                }
                if (type.equals("fork")) {
                    if (name.length() <= 9) {
                        return "<html><br />" + name + "</html>";
                    }
                    s.append("<html><br />").append(name.substring(0, 7)).append("-<br />");
                    if (name.substring(8).length() > 9) {
                        s.append(name.substring(7, 15)).append("...");
                    } else {
                        s.append(name.substring(7));
                    }
                    s.append("</html>");
                    return s.toString();
                }
                if (type.equals("join")) {
                    if (name.length() <= 8) {
                        return "<html>" + name + "</html>";
                    }
                    s.append("<html>").append(name.substring(0, 6)).append("-<br />");
                    if (name.substring(7).length() > 8) {
                        s.append(name.substring(6, 13)).append("...");
                    } else {
                        s.append(name.substring(6));
                    }
                    s.append("</html>");
                    return s.toString();
                }
                if (type.equals("start") || type.equals("end") || type.equals("kill")) {
                    if (name.length() <= 8) {
                        return "<html>" + name + "</html>";
                    }
                    s.append("<html>").append(name.substring(0, 6)).append("-<br />");
                    if (name.substring(7).length() > 8) {
                        s.append(name.substring(6, 13)).append("...");
                    } else {
                        s.append(name.substring(6));
                    }
                    s.append("</html>");
                    return s.toString();
                }
                if (name.length() <= 20) {
                    return name;
                }
                s.append("<html>").append(name.substring(0, 18)).append("-<br />");
                if (name.substring(19).length() > 20) {
                    s.append(name.substring(18, 37)).append("...");
                } else {
                    s.append(name.substring(18));
                }
                s.append("</html>");
                return s.toString();
            }
        }

        private class NodeStrokeTransformer
        implements Transformer<OozieWFNode, Stroke> {
            private final Stroke stroke1 = new BasicStroke(2.0f);
            private final Stroke stroke2 = new BasicStroke(4.0f);

            private NodeStrokeTransformer() {
            }

            public Stroke transform(OozieWFNode node) {
                if (node.getType().equals("start") || node.getType().equals("end") || node.getType().equals("kill")) {
                    return this.stroke2;
                }
                return this.stroke1;
            }
        }

        private class ArcPaintTransformer
        implements Transformer<String, Paint> {
            private ArcPaintTransformer() {
            }

            public Paint transform(String arc) {
                int sep = arc.indexOf("-->");
                String source = arc.substring(0, sep);
                String target = arc.substring(sep + 3);
                OozieWFNode src = (OozieWFNode)XMLParser.this.tags.get(source);
                OozieWFNode tgt = (OozieWFNode)XMLParser.this.tags.get(target);
                if (src.getType().equals("start")) {
                    if (tgt.getStatus() == null) {
                        return Color.LIGHT_GRAY;
                    }
                    return Color.GREEN;
                }
                if (src.getArcs().get(target).booleanValue()) {
                    if (src.getStatus() == null) {
                        return Color.LIGHT_GRAY;
                    }
                    switch (src.getStatus()) {
                        case KILLED: 
                        case ERROR: 
                        case FAILED: {
                            return Color.RED;
                        }
                    }
                    return Color.LIGHT_GRAY;
                }
                if (src.getType().equals("decision")) {
                    if (tgt.getStatus() != null) {
                        return Color.GREEN;
                    }
                    return Color.LIGHT_GRAY;
                }
                if (src.getStatus() == null) {
                    return Color.LIGHT_GRAY;
                }
                switch (src.getStatus()) {
                    case OK: 
                    case DONE: 
                    case END_RETRY: 
                    case END_MANUAL: {
                        return Color.GREEN;
                    }
                }
                return Color.LIGHT_GRAY;
            }
        }

        private class ArrowShapeTransformer
        implements Transformer<Context<Graph<OozieWFNode, String>, String>, Shape> {
            private final Shape arrow = ArrowFactory.getWedgeArrow((float)10.0f, (float)20.0f);

            private ArrowShapeTransformer() {
            }

            public Shape transform(Context<Graph<OozieWFNode, String>, String> i) {
                return this.arrow;
            }
        }

        private class NodeFontTransformer
        implements Transformer<OozieWFNode, Font> {
            private final Font font = new Font("Default", 1, 15);

            private NodeFontTransformer() {
            }

            public Font transform(OozieWFNode node) {
                return this.font;
            }
        }

        private class OozieWFNode {
            private String name;
            private String type;
            private Point loc;
            private HashMap<String, Boolean> arcs;
            private WorkflowAction.Status status = null;

            public OozieWFNode(String name, String type, HashMap<String, Boolean> arcs, Point loc, WorkflowAction.Status status) {
                this.name = name;
                this.type = type;
                this.arcs = arcs;
                this.loc = loc;
                this.status = status;
            }

            public OozieWFNode(String name, String type, HashMap<String, Boolean> arcs) {
                this(name, type, arcs, new Point(0, 0), null);
            }

            public OozieWFNode(String name, String type) {
                this(name, type, new HashMap<String, Boolean>(), new Point(0, 0), null);
            }

            public OozieWFNode(String name, String type, WorkflowAction.Status status) {
                this(name, type, new HashMap<String, Boolean>(), new Point(0, 0), status);
            }

            public void addArc(String arc, boolean isError) {
                this.arcs.put(arc, isError);
            }

            public void addArc(String arc) {
                this.addArc(arc, false);
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setLocation(Point loc) {
                this.loc = loc;
            }

            public void setLocation(double x, double y) {
                this.loc.setLocation(x, y);
            }

            public void setStatus(WorkflowAction.Status status) {
                this.status = status;
            }

            public String getName() {
                return this.name;
            }

            public String getType() {
                return this.type;
            }

            public HashMap<String, Boolean> getArcs() {
                return this.arcs;
            }

            public Point getLocation() {
                return this.loc;
            }

            public WorkflowAction.Status getStatus() {
                return this.status;
            }

            public String toString() {
                StringBuilder s = new StringBuilder();
                s.append("Node: ").append(this.name).append("\t");
                s.append("Type: ").append(this.type).append("\t");
                s.append("Location: (").append(this.loc.getX()).append(", ").append(this.loc.getY()).append(")\t");
                s.append("Status: ").append(this.status).append("\n");
                for (Map.Entry<String, Boolean> entry : this.arcs.entrySet()) {
                    s.append("\t").append(entry.getKey());
                    if (entry.getValue().booleanValue()) {
                        s.append(" on error\n");
                        continue;
                    }
                    s.append("\n");
                }
                return s.toString();
            }
        }
    }
}

