/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.DatanodeLocalInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenSelector;
import org.apache.hadoop.hdfs.server.datanode.DiskBalancerWorkStatus;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@KerberosInfo(serverPrincipal="dfs.datanode.kerberos.principal")
@TokenInfo(value=BlockTokenSelector.class)
public interface ClientDatanodeProtocol {
    public static final long versionID = 9L;

    public long getReplicaVisibleLength(ExtendedBlock var1) throws IOException;

    public void refreshNamenodes() throws IOException;

    public void deleteBlockPool(String var1, boolean var2) throws IOException;

    public BlockLocalPathInfo getBlockLocalPathInfo(ExtendedBlock var1, Token<BlockTokenIdentifier> var2) throws IOException;

    public HdfsBlocksMetadata getHdfsBlocksMetadata(String var1, long[] var2, List<Token<BlockTokenIdentifier>> var3) throws IOException;

    public void shutdownDatanode(boolean var1) throws IOException;

    public DatanodeLocalInfo getDatanodeInfo() throws IOException;

    public void startReconfiguration() throws IOException;

    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException;

    public List<String> listReconfigurableProperties() throws IOException;

    public void triggerBlockReport(BlockReportOptions var1) throws IOException;

    public void submitDiskBalancerPlan(String var1, long var2, String var4, String var5, boolean var6) throws IOException;

    public void cancelDiskBalancePlan(String var1) throws IOException;

    public DiskBalancerWorkStatus queryDiskBalancerPlan() throws IOException;

    public String getDiskBalancerSetting(String var1) throws IOException;
}

