/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.namenode.Content;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeReference;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContentSummaryComputationContext {
    private FSDirectory dir = null;
    private FSNamesystem fsn = null;
    private Content.Counts counts = null;
    private Content.Counts snapshotCounts = null;
    private long nextCountLimit = 0L;
    private long limitPerRun = 0L;
    private long yieldCount = 0L;
    private long sleepMilliSec = 0L;
    private int sleepNanoSec = 0;
    private Set<INode> includedNodes = new HashSet<INode>();
    private Set<INode> deletedSnapshottedNodes = new HashSet<INode>();

    public ContentSummaryComputationContext(FSDirectory dir, FSNamesystem fsn, long limitPerRun, long sleepMicroSec) {
        this.dir = dir;
        this.fsn = fsn;
        this.limitPerRun = limitPerRun;
        this.nextCountLimit = limitPerRun;
        this.setCounts(Content.Counts.newInstance());
        this.snapshotCounts = Content.Counts.newInstance();
        this.setSnapshotCounts(this.snapshotCounts);
        this.sleepMilliSec = sleepMicroSec / 1000L;
        this.sleepNanoSec = (int)(sleepMicroSec % 1000L * 1000L);
    }

    public ContentSummaryComputationContext() {
        this(null, null, 0L, 1000L);
    }

    public long getYieldCount() {
        return this.yieldCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean yield() {
        if (this.limitPerRun <= 0L || this.dir == null || this.fsn == null) {
            return false;
        }
        Content.Counts counts = this.getCounts();
        long currentCount = counts.get(Content.FILE) + counts.get(Content.SYMLINK) + counts.get(Content.DIRECTORY) + counts.get(Content.SNAPSHOTTABLE_DIRECTORY);
        if (currentCount <= this.nextCountLimit) {
            return false;
        }
        this.nextCountLimit = currentCount + this.limitPerRun;
        boolean hadDirReadLock = this.dir.hasReadLock();
        boolean hadDirWriteLock = this.dir.hasWriteLock();
        boolean hadFsnReadLock = this.fsn.hasReadLock();
        boolean hadFsnWriteLock = this.fsn.hasWriteLock();
        if (!hadDirReadLock || !hadFsnReadLock || hadDirWriteLock || hadFsnWriteLock || this.dir.getReadHoldCount() != 1 || this.fsn.getReadHoldCount() != 1) {
            return false;
        }
        this.dir.readUnlock();
        this.fsn.readUnlock();
        try {
            Thread.sleep(this.sleepMilliSec, this.sleepNanoSec);
        }
        catch (InterruptedException ie) {
        }
        finally {
            this.fsn.readLock();
            this.dir.readLock();
        }
        ++this.yieldCount;
        return true;
    }

    public synchronized Content.Counts getCounts() {
        return this.counts;
    }

    private synchronized void setCounts(Content.Counts counts) {
        this.counts = counts;
    }

    public Content.Counts getSnapshotCounts() {
        return this.snapshotCounts;
    }

    private void setSnapshotCounts(Content.Counts snapshotCounts) {
        this.snapshotCounts = snapshotCounts;
    }

    private INode resolveINodeReference(INode node) {
        if (node.isReference() && node instanceof INodeReference) {
            return ((INodeReference)node).getReferredINode();
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nodeIncluded(INode node) {
        INode resolvedNode = this.resolveINodeReference(node);
        Set<INode> set = this.includedNodes;
        synchronized (set) {
            if (!this.includedNodes.contains(resolvedNode)) {
                this.includedNodes.add(resolvedNode);
                return false;
            }
        }
        return true;
    }

    public void reportDeletedSnapshottedNode(INode node) {
        this.deletedSnapshottedNodes.add(node);
    }

    public synchronized void tallyDeletedSnapshottedINodes() {
        Content.Counts originalCounts = this.getCounts();
        this.setCounts(Content.Counts.newInstance());
        for (INode node : this.deletedSnapshottedNodes) {
            if (this.nodeIncluded(node)) continue;
            node.computeContentSummary(0x7FFFFFFE, this);
        }
        originalCounts.add(this.getCounts());
        this.snapshotCounts.add(this.getCounts());
        this.setCounts(originalCounts);
    }
}

