/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import net.fortuna.mstor.connector.MessageDelegate;
import net.fortuna.mstor.tag.Taggable;
import net.fortuna.mstor.tag.Tags;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MStorMessage
extends MimeMessage
implements Serializable,
Taggable {
    private static final long serialVersionUID = 6413532435324648022L;
    private Log log = LogFactory.getLog(MStorMessage.class);
    private MessageDelegate delegate;
    private InputStream in;
    private boolean loaded;
    private Tags tags;

    public MStorMessage(Session session) {
        this(session, null);
    }

    public MStorMessage(Session session, InputStream in) {
        super(session);
        this.in = in;
        this.tags = new Tags(this.flags);
    }

    public MStorMessage(MimeMessage m) throws MessagingException {
        super(m);
        this.tags = new Tags(this.flags);
    }

    public MStorMessage(Folder folder, int msgnum) {
        this(folder, null, msgnum);
    }

    public MStorMessage(Folder folder, InputStream in, int msgnum) {
        this(folder, in, msgnum, null);
    }

    public MStorMessage(MessageDelegate delegate) {
        this(null, null, delegate.getMessageNumber(), delegate);
    }

    public MStorMessage(Folder folder, InputStream in, int msgnum, MessageDelegate delegate) {
        super(folder, msgnum);
        this.in = in != null ? in : delegate.getInputStream();
        this.delegate = delegate;
        this.tags = new Tags(this.flags);
        if (delegate != null) {
            try {
                super.setExpunged(delegate.isExpunged());
                super.setFlags(delegate.getFlags(), true);
            }
            catch (Exception e) {
                this.log.warn((Object)"Error syncing with delegate", (Throwable)e);
            }
        }
    }

    public MStorMessage(Folder folder, InternetHeaders headers, byte[] content, int msgnum) throws MessagingException {
        super(folder, headers, content, msgnum);
        this.tags = new Tags(this.flags);
    }

    private void checkParse() throws MessagingException {
        if (!this.loaded) {
            this.parse(this.in);
            this.loaded = true;
        }
    }

    public Enumeration<String> getAllHeaderLines() throws MessagingException {
        InternetHeaders headers = this.getHeaders();
        if (headers != null) {
            return headers.getAllHeaderLines();
        }
        this.checkParse();
        return super.getAllHeaderLines();
    }

    public Enumeration<Header> getAllHeaders() throws MessagingException {
        InternetHeaders headers = this.getHeaders();
        if (headers != null) {
            return headers.getAllHeaders();
        }
        this.checkParse();
        return super.getAllHeaders();
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        InternetHeaders headers = this.getHeaders();
        if (headers != null) {
            return headers.getHeader(name, delimiter);
        }
        this.checkParse();
        return super.getHeader(name, delimiter);
    }

    public String[] getHeader(String name) throws MessagingException {
        InternetHeaders headers = this.getHeaders();
        if (headers != null) {
            return headers.getHeader(name);
        }
        this.checkParse();
        return super.getHeader(name);
    }

    public Enumeration<String> getMatchingHeaderLines(String[] names) throws MessagingException {
        InternetHeaders headers = this.getHeaders();
        if (headers != null) {
            return headers.getMatchingHeaderLines(names);
        }
        this.checkParse();
        return super.getMatchingHeaderLines(names);
    }

    public Enumeration<Header> getMatchingHeaders(String[] names) throws MessagingException {
        InternetHeaders headers = this.getHeaders();
        if (headers != null) {
            return headers.getMatchingHeaders(names);
        }
        this.checkParse();
        return super.getMatchingHeaders(names);
    }

    public Enumeration<String> getNonMatchingHeaderLines(String[] names) throws MessagingException {
        InternetHeaders headers = this.getHeaders();
        if (headers != null) {
            return headers.getNonMatchingHeaderLines(names);
        }
        this.checkParse();
        return super.getNonMatchingHeaderLines(names);
    }

    public Enumeration<Header> getNonMatchingHeaders(String[] names) throws MessagingException {
        InternetHeaders headers = this.getHeaders();
        if (headers != null) {
            return headers.getNonMatchingHeaders(names);
        }
        this.checkParse();
        return super.getNonMatchingHeaders(names);
    }

    private InternetHeaders getHeaders() throws MessagingException {
        if (this.delegate != null) {
            try {
                return this.delegate.getHeaders();
            }
            catch (Exception e) {
                throw new MessagingException("Error retrieving headers", e);
            }
        }
        return null;
    }

    protected InputStream getContentStream() throws MessagingException {
        this.checkParse();
        return super.getContentStream();
    }

    protected void setExpunged(boolean expunged) {
        if (this.delegate != null) {
            try {
                this.delegate.setExpunged(expunged);
            }
            catch (Exception e) {
                this.log.error((Object)"Error updating expunged flag", (Throwable)e);
            }
        }
        super.setExpunged(expunged);
    }

    public Date getReceivedDate() throws MessagingException {
        if (this.delegate != null) {
            try {
                return this.delegate.getReceived();
            }
            catch (Exception e) {
                throw new MessagingException("Error retrieving received date", e);
            }
        }
        return super.getReceivedDate();
    }

    public synchronized void setFlags(Flags flags, boolean set) throws MessagingException {
        super.setFlags(flags, set);
        this.updateFlags();
    }

    public void setFlag(Flags.Flag flag, boolean set) throws MessagingException {
        super.setFlag(flag, set);
        this.updateFlags();
    }

    public void setHeader(String s, String s1) throws MessagingException {
        this.checkParse();
        super.setHeader(s, s1);
        this.updateHeaders(false);
    }

    public void addHeader(String s, String s1) throws MessagingException {
        super.addHeader(s, s1);
        this.updateHeaders(false);
    }

    public void removeHeader(String s) throws MessagingException {
        super.removeHeader(s);
        this.updateHeaders(false);
    }

    public void addHeaderLine(String s) throws MessagingException {
        super.addHeaderLine(s);
        this.updateHeaders(false);
    }

    @Override
    public void addTag(String tag) throws MessagingException {
        this.tags.add(tag);
        this.updateFlags();
    }

    @Override
    public void removeTag(String tag) throws MessagingException {
        this.tags.remove(tag);
        this.updateFlags();
    }

    public void saveChanges() throws MessagingException {
        super.saveChanges();
        if (this.delegate != null) {
            try {
                this.delegate.saveChanges();
            }
            catch (Exception e) {
                throw new MessagingException("Error updating message metadata", e);
            }
        }
    }

    protected void updateHeaders() throws MessagingException {
        this.updateHeaders(true);
    }

    private void updateHeaders(boolean includeDefaults) throws MessagingException {
        if (includeDefaults) {
            super.updateHeaders();
        }
        if (this.delegate != null) {
            try {
                this.delegate.setHeaders(this.headers);
            }
            catch (Exception e) {
                throw new MessagingException("Error updating headers", e);
            }
        }
    }

    private void updateFlags() throws MessagingException {
        if (this.delegate != null && !this.flags.equals((Object)this.delegate.getFlags())) {
            try {
                this.delegate.setFlags(this.flags);
            }
            catch (Exception e) {
                throw new MessagingException("Error updating flags", e);
            }
            this.saveChanges();
        }
    }

    @Override
    public Tags getTags() throws MessagingException {
        return new Tags(this.getFlags());
    }

    protected long getUid() {
        if (this.delegate != null) {
            try {
                return this.delegate.getUid();
            }
            catch (Exception e) {
                this.log.error((Object)"Error retrieving uid", (Throwable)e);
            }
        }
        return -1L;
    }

    public MStorMessage getInReplyTo() {
        if (this.delegate.getInReplyTo() != null) {
            return new MStorMessage(this.delegate.getInReplyTo());
        }
        return null;
    }

    public List<MStorMessage> getReferences() {
        ArrayList<MStorMessage> references = new ArrayList<MStorMessage>();
        for (MessageDelegate messageDelegate : this.delegate.getReferences()) {
            references.add(new MStorMessage(messageDelegate));
        }
        return Collections.unmodifiableList(references);
    }
}

