/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.jcr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;
import net.fortuna.mstor.MStorMessage;
import net.fortuna.mstor.connector.DelegateException;
import net.fortuna.mstor.connector.MessageDelegate;
import net.fortuna.mstor.connector.jcr.JcrMessageDao;
import net.fortuna.mstor.util.MessageUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jcrom.AbstractJcrEntity;
import org.jcrom.JcrDataProvider;
import org.jcrom.JcrDataProviderImpl;
import org.jcrom.JcrFile;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.annotations.JcrFileNode;
import org.jcrom.annotations.JcrProperty;
import org.jcrom.annotations.JcrReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrMessage
extends AbstractJcrEntity
implements MessageDelegate {
    private static final long serialVersionUID = 3832397825180707796L;
    @JcrProperty
    private Integer messageNumber;
    @JcrProperty
    private String messageId;
    @JcrProperty
    private Map<String, String> headers = new HashMap<String, String>();
    @JcrProperty
    private List<String> flags = new ArrayList<String>();
    @JcrProperty
    private Date received;
    @JcrProperty
    private Date replied;
    @JcrProperty
    private Date forwarded;
    @JcrProperty
    private Long uid;
    @JcrProperty
    private Boolean expunged;
    @JcrFileNode(lazy=true)
    private JcrFile content;
    @JcrChildNode(lazy=true)
    private List<JcrMessage> messages = new ArrayList<JcrMessage>();
    @JcrFileNode(lazy=true)
    private JcrFile body;
    @JcrFileNode(lazy=true)
    private List<JcrFile> attachments = new ArrayList<JcrFile>();
    @JcrReference(byPath=true, lazy=true)
    private JcrMessage inReplyTo;
    @JcrReference(byPath=true, lazy=true)
    private List<JcrMessage> references = new ArrayList<JcrMessage>();
    private JcrMessageDao messageDao;

    @Override
    public Flags getFlags() {
        Flags retVal = new Flags();
        for (String flag : this.flags) {
            Flags.Flag systemFlag = MessageUtils.getFlag(flag);
            if (systemFlag != null) {
                retVal.add(systemFlag);
                continue;
            }
            retVal.add(flag);
        }
        return retVal;
    }

    @Override
    public Date getForwarded() {
        return this.forwarded;
    }

    @Override
    public InternetHeaders getHeaders() {
        InternetHeaders retVal = new InternetHeaders();
        for (String name : this.headers.keySet()) {
            retVal.addHeader(name, this.headers.get(name));
        }
        return retVal;
    }

    @Override
    public int getMessageNumber() {
        return this.messageNumber;
    }

    @Override
    public Date getReceived() {
        return this.received;
    }

    @Override
    public Date getReplied() {
        return this.replied;
    }

    @Override
    public long getUid() {
        return this.uid;
    }

    @Override
    public boolean isExpunged() {
        return this.expunged;
    }

    @Override
    public void saveChanges() throws DelegateException {
        if (this.messageDao != null) {
            this.messageDao.update(this, "none", -1);
        }
    }

    public void setMessageNumber(Integer messageNumber) {
        this.messageNumber = messageNumber;
    }

    @Override
    public void setExpunged(boolean expunged) {
        this.expunged = expunged;
    }

    @Override
    public InputStream getInputStream() {
        return this.content.getDataProvider().getInputStream();
    }

    @Override
    public void setFlags(Flags flags) {
        this.flags.clear();
        for (Flags.Flag flag : flags.getSystemFlags()) {
            this.flags.add(MessageUtils.getFlagName(flag));
        }
        for (String string : flags.getUserFlags()) {
            this.flags.add(string);
        }
    }

    @Override
    public void setForwarded(Date forwarded) {
        this.forwarded = forwarded;
    }

    @Override
    public void setHeaders(InternetHeaders headers) {
        this.setHeaders(headers.getAllHeaders());
    }

    @Override
    public void setHeaders(Enumeration<Header> headers) {
        this.headers.clear();
        this.inReplyTo = null;
        this.getReferences().clear();
        while (headers.hasMoreElements()) {
            Header header = headers.nextElement();
            this.headers.put(header.getName(), header.getValue());
        }
    }

    @Override
    public void setReceived(Date received) {
        this.received = received;
    }

    @Override
    public void setReplied(Date replied) {
        this.replied = replied;
    }

    @Override
    public void setUid(long uid) {
        this.uid = uid;
    }

    public void setMessage(Message message) throws MessagingException, IOException {
        ByteArrayOutputStream mout = new ByteArrayOutputStream();
        message.writeTo((OutputStream)mout);
        this.content = new JcrFile();
        this.content.setName("data");
        this.content.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(JcrDataProvider.TYPE.BYTES, mout.toByteArray()));
        this.content.setMimeType(message.getContentType());
        this.content.setLastModified(Calendar.getInstance());
        this.messageId = MessageUtils.getMessageId(message);
        if (this.messageId != null) {
            this.setName(this.messageId);
        } else {
            this.setName("message");
        }
        if (message instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)message;
            this.messages.clear();
            this.attachments.clear();
            this.appendBody((Part)mimeMessage);
            this.appendAttachments((Part)mimeMessage);
        }
    }

    private void appendBody(Part part) throws MessagingException, IOException {
        if (part.isMimeType("text/html")) {
            this.body = this.createBody(part);
        } else if (part.isMimeType("text/plain") && this.body == null) {
            this.body = this.createBody(part);
        } else if (part.isMimeType("multipart/*")) {
            Multipart multi = (Multipart)part.getContent();
            for (int i = 0; i < multi.getCount(); ++i) {
                this.appendBody((Part)multi.getBodyPart(i));
            }
        }
    }

    JcrFile createBody(Part part) throws IOException, MessagingException {
        JcrFile body = new JcrFile();
        body.setName("part");
        ByteArrayOutputStream pout = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)part.getInputStream(), (OutputStream)pout);
        body.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(JcrDataProvider.TYPE.BYTES, pout.toByteArray()));
        body.setMimeType(part.getContentType());
        body.setLastModified(Calendar.getInstance());
        return body;
    }

    private void appendAttachments(Part part) throws MessagingException, IOException {
        if (part.isMimeType("message/*")) {
            JcrMessage jcrMessage = new JcrMessage();
            Object attachedMessage = null;
            attachedMessage = part.getContent() instanceof Message ? (Message)part.getContent() : new MStorMessage(null, (InputStream)part.getContent());
            jcrMessage.setFlags(attachedMessage.getFlags());
            jcrMessage.setHeaders(attachedMessage.getAllHeaders());
            jcrMessage.setReceived(attachedMessage.getReceivedDate());
            jcrMessage.setExpunged(attachedMessage.isExpunged());
            jcrMessage.setMessage((Message)attachedMessage);
            this.messages.add(jcrMessage);
        } else if (part.isMimeType("multipart/*")) {
            Multipart multi = (Multipart)part.getContent();
            for (int i = 0; i < multi.getCount(); ++i) {
                this.appendAttachments((Part)multi.getBodyPart(i));
            }
        } else if ("attachment".equalsIgnoreCase(part.getDisposition()) || StringUtils.isNotEmpty((String)part.getFileName())) {
            JcrFile attachment = new JcrFile();
            String name = null;
            if (StringUtils.isNotEmpty((String)part.getFileName())) {
                name = part.getFileName();
                for (JcrFile attach : this.attachments) {
                    if (!attach.getName().equals(name)) continue;
                    return;
                }
            } else {
                String[] contentId = part.getHeader("Content-Id");
                name = contentId != null && contentId.length > 0 ? contentId[0] : "attachment";
            }
            int count = 0;
            for (JcrFile attach : this.attachments) {
                if (!attach.getName().equals(name)) continue;
                ++count;
            }
            if (count > 0) {
                name = name + "_" + count;
            }
            attachment.setName(name);
            ByteArrayOutputStream pout = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)part.getInputStream(), (OutputStream)pout);
            attachment.setDataProvider((JcrDataProvider)new JcrDataProviderImpl(JcrDataProvider.TYPE.BYTES, pout.toByteArray()));
            attachment.setMimeType(part.getContentType());
            attachment.setLastModified(Calendar.getInstance());
            this.attachments.add(attachment);
        }
    }

    @Override
    public final JcrMessage getInReplyTo() {
        return this.inReplyTo;
    }

    public final void setInReplyTo(JcrMessage inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public final List<JcrMessage> getReferences() {
        return this.references;
    }

    final void setMessageDao(JcrMessageDao messageDao) {
        this.messageDao = messageDao;
    }
}

