/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.mbox;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Random;
import javax.mail.Message;
import javax.mail.MessagingException;
import net.fortuna.mstor.connector.AbstractFolderDelegate;
import net.fortuna.mstor.connector.DelegateException;
import net.fortuna.mstor.connector.FolderDelegate;
import net.fortuna.mstor.connector.MessageDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetaFolder<T extends MessageDelegate>
extends AbstractFolderDelegate<T> {
    private static final Random UID_VALIDITY_GENERATOR = new Random();
    private File file;
    private FolderDelegate<MessageDelegate> delegate;

    public AbstractMetaFolder(FolderDelegate<MessageDelegate> delegate) {
        this.file = this.getMetaFile(delegate);
        this.delegate = delegate;
    }

    @Override
    public final int getType() {
        return this.delegate.getType();
    }

    @Override
    public final String getFolderName() {
        return this.delegate.getFolderName();
    }

    @Override
    public final String getFullName() {
        return this.delegate.getFullName();
    }

    @Override
    public final boolean exists() {
        return this.delegate.exists();
    }

    @Override
    public final boolean delete() {
        return this.delegate.delete() && this.file.delete();
    }

    @Override
    public final boolean renameTo(String name) {
        return this.delegate.renameTo(name) && (!this.file.exists() || this.file.renameTo(new File(this.file.getParent(), name + this.getFileExtension())));
    }

    @Override
    public final void open(int mode) {
        this.delegate.open(mode);
    }

    @Override
    public final void close() throws MessagingException {
        this.delegate.close();
    }

    @Override
    public final char getSeparator() {
        return this.delegate.getSeparator();
    }

    @Override
    public final int getMessageCount() throws MessagingException {
        return this.delegate.getMessageCount();
    }

    @Override
    public final InputStream getMessageAsStream(int index) throws IOException {
        return this.delegate.getMessageAsStream(index);
    }

    @Override
    public final void appendMessages(Message[] messages) throws MessagingException {
        try {
            Date received = new Date();
            for (int i = 0; i < messages.length; ++i) {
                Object md = this.getMessage(messages[i].getMessageNumber());
                md.setReceived(received);
                md.setFlags(messages[i].getFlags());
                md.setHeaders(messages[i].getAllHeaders());
                this.allocateUid((MessageDelegate)md);
            }
            this.delegate.appendMessages(messages);
            this.save();
        }
        catch (DelegateException de) {
            throw new MessagingException("Error saving changes", (Exception)de);
        }
    }

    @Override
    public final boolean create(int type) throws MessagingException {
        return this.delegate.create(type);
    }

    @Override
    public final void expunge(Message[] deleted) throws MessagingException {
        this.delegate.expunge(deleted);
        this.removeMessages(deleted);
        try {
            this.save();
        }
        catch (DelegateException de) {
            throw new MessagingException("Error saving changes", (Exception)de);
        }
    }

    protected int newUidValidity() {
        return UID_VALIDITY_GENERATOR.nextInt(Integer.MAX_VALUE);
    }

    protected final File getFile() {
        return this.file;
    }

    protected final FolderDelegate<MessageDelegate> getDelegate() {
        return this.delegate;
    }

    protected abstract String getFileExtension();

    protected abstract T[] removeMessages(Message[] var1);

    protected abstract void save() throws DelegateException;

    private File getMetaFile(FolderDelegate<MessageDelegate> delegate) {
        return new File(delegate.getFullName() + this.getFileExtension());
    }

    @Override
    public final long getLastModified() throws UnsupportedOperationException {
        return this.delegate.getLastModified();
    }
}

