/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.connector.mbox;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.mail.Message;
import javax.mail.MessagingException;
import net.fortuna.mstor.connector.AbstractFolderDelegate;
import net.fortuna.mstor.connector.DelegateException;
import net.fortuna.mstor.connector.FolderDelegate;
import net.fortuna.mstor.connector.MessageDelegate;
import net.fortuna.mstor.data.MboxFile;
import net.fortuna.mstor.util.CapabilityHints;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MboxFolder
extends AbstractFolderDelegate<MessageDelegate> {
    static final String DIR_EXTENSION = ".sbd";
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final FileFilter SUBFOLDER_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            if (pathname.getName().endsWith(".emf") || pathname.getName().endsWith(".yml")) {
                return false;
            }
            if (pathname.getName().endsWith(MboxFolder.DIR_EXTENSION)) {
                return false;
            }
            return pathname.isDirectory() || pathname.getName().startsWith(".") || pathname.length() < 0L || MboxFile.isValid(pathname);
        }
    };
    private Log log = LogFactory.getLog(MboxFolder.class);
    private File file;
    private MboxFile mbox;
    private int type;

    public MboxFolder(File file) {
        this.file = file;
        this.type = file.isDirectory() ? 2 : 3;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final String getFolderName() {
        return this.file.getName();
    }

    @Override
    public final String getFullName() {
        return this.file.getPath();
    }

    @Override
    public final FolderDelegate<MessageDelegate> getParent() {
        return new MboxFolder(this.file.getParentFile());
    }

    @Override
    public final FolderDelegate<MessageDelegate> getFolder(String name) {
        File file = null;
        file = name.startsWith("/") ? new File(name) : ((this.getType() & 1) == 0 ? new File(this.file, name) : new File(this.file.getAbsolutePath() + DIR_EXTENSION, name));
        return new MboxFolder(file);
    }

    @Override
    public final FolderDelegate<MessageDelegate>[] list(String pattern) {
        ArrayList<MboxFolder> folders = new ArrayList<MboxFolder>();
        File[] files = null;
        files = this.file.isDirectory() ? this.file.listFiles(SUBFOLDER_FILTER) : new File(this.file.getAbsolutePath() + DIR_EXTENSION).listFiles(SUBFOLDER_FILTER);
        for (int i = 0; files != null && i < files.length; ++i) {
            folders.add(new MboxFolder(files[i]));
        }
        return folders.toArray(new MboxFolder[folders.size()]);
    }

    @Override
    public final boolean exists() {
        return this.file.exists();
    }

    @Override
    public final boolean delete() {
        return this.file.delete();
    }

    @Override
    public final boolean renameTo(String name) {
        return this.file.renameTo(new File(this.file.getParent(), name));
    }

    @Override
    public final void open(int mode) {
        if ((this.getType() & 1) > 0) {
            this.mbox = mode == 2 ? new MboxFile(this.file, "rw") : new MboxFile(this.file, "r");
        }
    }

    @Override
    public final void close() throws MessagingException {
        try {
            this.mbox.close();
        }
        catch (IOException ioe) {
            throw new MessagingException("Error ocurred closing mbox file", (Exception)ioe);
        }
        finally {
            this.mbox = null;
        }
    }

    @Override
    public final char getSeparator() {
        return File.separatorChar;
    }

    @Override
    public final int getMessageCount() throws MessagingException {
        try {
            return this.mbox.getMessageCount();
        }
        catch (IOException ioe) {
            throw new MessagingException("Error ocurred reading message count", (Exception)ioe);
        }
    }

    @Override
    public final InputStream getMessageAsStream(int index) throws IOException {
        return this.mbox.getMessageAsStream(index - 1);
    }

    @Override
    public final void appendMessages(Message[] messages) throws MessagingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        boolean folderClosed = false;
        if (this.mbox == null) {
            folderClosed = true;
            this.mbox = new MboxFile(this.file, "rw");
        }
        for (int i = 0; i < messages.length; ++i) {
            try {
                out.reset();
                if (CapabilityHints.isHintEnabled("mstor.mbox.mozillaCompatibility")) {
                    messages[i].setHeader("X-Mozilla-Status", "0000");
                    messages[i].setHeader("X-Mozilla-Status-2", "00000000");
                }
                messages[i].writeTo((OutputStream)out);
                this.mbox.appendMessage(out.toByteArray());
                messages[i] = null;
                continue;
            }
            catch (Exception e) {
                throw new MessagingException("Error appending message [" + i + "]", e);
            }
        }
        if (this.mbox != null && folderClosed) {
            try {
                this.mbox.close();
            }
            catch (IOException ioe) {
                throw new MessagingException("Error appending messages", (Exception)ioe);
            }
            finally {
                this.mbox = null;
            }
        }
    }

    @Override
    public final boolean create(int type) throws MessagingException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating folder [" + this.file.getAbsolutePath() + "]"));
        }
        boolean created = false;
        if ((type & 1) > 0) {
            this.type = type;
            try {
                this.file.getParentFile().mkdirs();
                created = this.file.createNewFile();
            }
            catch (IOException ioe) {
                throw new MessagingException("Unable to create folder [" + this.file.getAbsolutePath() + "]", (Exception)ioe);
            }
        } else if ((type & 2) > 0) {
            this.type = type;
            created = this.file.mkdirs();
        } else {
            throw new MessagingException("Invalid folder type");
        }
        return created;
    }

    @Override
    public final void expunge(Message[] deleted) throws MessagingException {
        if (deleted.length == 0) {
            return;
        }
        int[] mboxIndices = new int[deleted.length];
        int[] metaIndices = new int[deleted.length];
        for (int i = 0; i < deleted.length; ++i) {
            mboxIndices[i] = deleted[i].getMessageNumber() - 1;
            metaIndices[i] = deleted[i].getMessageNumber();
        }
        try {
            this.mbox.purge(mboxIndices);
        }
        catch (IOException ioe) {
            throw new MessagingException("Error purging mbox file", (Exception)ioe);
        }
    }

    @Override
    protected MessageDelegate createMessage(int messageNumber) throws DelegateException {
        return null;
    }

    @Override
    public MessageDelegate getMessage(int messageNumber) throws DelegateException {
        return null;
    }

    @Override
    protected void setLastUid(long uid) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Mbox format does not support UID folders");
    }

    @Override
    public long getLastUid() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Mbox format does not support UID folders");
    }

    @Override
    public long getUidValidity() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Mbox format does not support UID folders");
    }

    @Override
    public long getLastModified() throws UnsupportedOperationException {
        return this.file.lastModified();
    }
}

