/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.tag;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import net.fortuna.mstor.tag.Taggable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tags
implements Set<String>,
Serializable {
    private static final long serialVersionUID = -4185780688194955112L;
    protected static final String TAG_PREFIX = "tag_";
    private Flags flags;

    public Tags() {
        this(new Flags());
    }

    public Tags(Flags flags) {
        this.flags = flags;
    }

    @Override
    public final int size() {
        int tagCount = 0;
        String[] userFlags = this.flags.getUserFlags();
        for (int i = 0; i < userFlags.length; ++i) {
            if (!userFlags[i].startsWith(TAG_PREFIX)) continue;
            ++tagCount;
        }
        return tagCount;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final boolean contains(Object tag) {
        if (tag instanceof String) {
            String flag = TAG_PREFIX + tag;
            String[] userFlags = this.flags.getUserFlags();
            for (int i = 0; i < userFlags.length; ++i) {
                if (!userFlags[i].equals(flag)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<String> getTagSet() {
        HashSet<String> tags = new HashSet<String>();
        String[] userFlags = this.flags.getUserFlags();
        for (int i = 0; i < userFlags.length; ++i) {
            if (!userFlags[i].startsWith(TAG_PREFIX)) continue;
            tags.add(userFlags[i].split(TAG_PREFIX)[1]);
        }
        return tags;
    }

    @Override
    public final Iterator<String> iterator() {
        return this.getTagSet().iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.getTagSet().toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.getTagSet().toArray(a);
    }

    @Override
    public final boolean add(String tag) {
        String flag = TAG_PREFIX + tag;
        if (!this.flags.contains(flag)) {
            this.flags.add(flag);
            return true;
        }
        return false;
    }

    @Override
    public final boolean remove(Object tag) {
        if (tag instanceof String) {
            this.flags.remove(TAG_PREFIX + tag);
            return true;
        }
        return false;
    }

    @Override
    public final boolean containsAll(Collection<?> arg0) {
        Iterator<?> i = arg0.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean addAll(Collection<? extends String> arg0) {
        Iterator<? extends String> i = arg0.iterator();
        while (i.hasNext()) {
            if (this.add(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean retainAll(Collection<?> arg0) {
        for (String tag : this) {
            if (arg0.contains(tag) || this.remove(tag)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean removeAll(Collection<?> arg0) {
        Iterator<?> i = arg0.iterator();
        while (i.hasNext()) {
            if (this.remove(i.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void clear() {
        Iterator<String> i = this.iterator();
        while (i.hasNext()) {
            this.remove(i.next());
        }
    }

    public static void addTag(String tag, Message message) throws MessagingException {
        if (message instanceof Taggable) {
            ((Taggable)message).addTag(tag);
            return;
        }
        throw new UnsupportedOperationException("Message is not taggable");
    }

    public static void removeTag(String tag, Message message) throws MessagingException {
        if (message instanceof Taggable) {
            ((Taggable)message).removeTag(tag);
            return;
        }
        throw new UnsupportedOperationException("Message is not taggable");
    }

    public static Tags getTags(Message message) throws MessagingException {
        if (message instanceof Taggable) {
            return ((Taggable)message).getTags();
        }
        throw new UnsupportedOperationException("Message is not taggable");
    }
}

