/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.dataservice.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataServiceConnectionInformation
implements ProvidesDatabaseConnectionInformation {
    public static final String KETTLE_THIN = "KettleThin";
    public static final String NATIVE = "native";
    private String dataServiceName;
    private Repository repository;
    private LogChannelInterface log;
    private static Class<?> PKG = DataServiceConnectionInformation.class;

    public DataServiceConnectionInformation(String dataService, Repository repository, LogChannelInterface log) {
        this.dataServiceName = dataService;
        this.repository = repository;
        this.log = log;
    }

    public DatabaseMeta getDatabaseMeta() {
        try {
            return this.isDIRepository() ? this.getRepositoryDatabaseMeta() : this.getLocalDatabaseMeta();
        }
        catch (KettleException e) {
            this.log.logDebug(e.getMessage());
            return this.getLocalDatabaseMeta();
        }
    }

    private boolean isDIRepository() {
        try {
            return this.repository != null && "PentahoEnterpriseRepository".equals(this.getRepositoryProperty("id"));
        }
        catch (KettleException e) {
            this.log.logDebug(e.getMessage());
            return false;
        }
    }

    private DatabaseMeta getRepositoryDatabaseMeta() throws KettleException {
        String repositoryUrl = this.getRepositoryProperty("repository_location_url");
        try {
            URI uri = new URI(repositoryUrl);
            DatabaseMeta databaseMeta = new DatabaseMeta(this.dataServiceName, KETTLE_THIN, NATIVE, uri.getHost(), KETTLE_THIN, Integer.toString(uri.getPort()), this.repository.getUserInfo().getLogin(), this.repository.getUserInfo().getPassword());
            databaseMeta.setDBName(uri.getPath().substring(1));
            return databaseMeta;
        }
        catch (URISyntaxException e) {
            throw new KettleException((Throwable)e);
        }
    }

    private String getRepositoryProperty(String nodeName) throws KettleException {
        String xml = this.repository.getRepositoryMeta().getXML();
        Document doc = XMLHandler.loadXMLString((String)xml);
        NodeList childNodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!nodeName.equals(item.getNodeName())) continue;
            return item.getTextContent();
        }
        throw new KettleException(BaseMessages.getString(PKG, (String)"BuildModelJob.Info.ElementNotFound", (String[])new String[]{nodeName}));
    }

    private DatabaseMeta getLocalDatabaseMeta() {
        DatabaseMeta databaseMeta = new DatabaseMeta(this.dataServiceName, KETTLE_THIN, NATIVE, null, KETTLE_THIN, null, null, null);
        databaseMeta.addExtraOption(KETTLE_THIN, "local", "true");
        return databaseMeta;
    }

    public String getTableName() {
        return this.dataServiceName;
    }

    public String getSchemaName() {
        return "Kettle";
    }

    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }
}

