/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageCredentialsAccountAndKey;
import com.microsoft.windowsazure.storage.StorageCredentialsSharedAccessSignature;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.core.Utility;
import com.microsoft.windowsazure.storage.queue.CloudQueueClient;
import com.microsoft.windowsazure.storage.table.CloudTableClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public final class CloudStorageAccount {
    protected static final String ACCOUNT_KEY_NAME = "AccountKey";
    protected static final String ACCOUNT_NAME_NAME = "AccountName";
    private static final String BLOB_BASE_DNS_NAME = "blob.core.windows.net";
    private static final String SECONDARY_LOCATION_ACCOUNT_SUFFIX = "-secondary";
    protected static final String BLOB_ENDPOINT_NAME = "BlobEndpoint";
    private static final String DEFAULT_ENDPOINTS_PROTOCOL_NAME = "DefaultEndpointsProtocol";
    private static final String DEVELOPMENT_STORAGE_PROXY_URI_NAME = "DevelopmentStorageProxyUri";
    private static final String DEVSTORE_ACCOUNT_KEY = "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static final String DEVSTORE_ACCOUNT_NAME = "devstoreaccount1";
    private static final String PRIMARY_ENDPOINT_FORMAT = "%s://%s.%s";
    private static final String SECONDARY_ENDPOINT_FORMAT = "%s://%s%s.%s";
    private static final String DEVSTORE_CREDENTIALS_IN_STRING = "AccountName=devstoreaccount1;AccountKey=Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==";
    private static CloudStorageAccount devStoreAccount;
    protected static final String QUEUE_BASE_DNS_NAME = "queue.core.windows.net";
    protected static final String QUEUE_ENDPOINT_NAME = "QueueEndpoint";
    protected static final String SHARED_ACCESS_SIGNATURE_NAME = "SharedAccessSignature";
    protected static final String TABLE_BASE_DNS_NAME = "table.core.windows.net";
    protected static final String TABLE_ENDPOINT_NAME = "TableEndpoint";
    private static final String USE_DEVELOPMENT_STORAGE_NAME = "UseDevelopmentStorage";
    private final StorageUri blobStorageUri;
    private final StorageUri queueStorageUri;
    private final StorageUri tableStorageUri;
    private StorageCredentials credentials;
    private boolean isBlobEndpointDefault = false;
    private boolean isQueueEndpointDefault = false;
    private boolean isTableEndpointDefault = false;

    private static StorageUri getDefaultBlobStorageUri(HashMap<String, String> settings) throws URISyntaxException {
        String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) : "http";
        String accountName = settings.get(ACCOUNT_NAME_NAME);
        return CloudStorageAccount.getDefaultBlobStorageUri(scheme, accountName);
    }

    private static StorageUri getDefaultBlobStorageUri(String scheme, String accountName) throws URISyntaxException {
        if (Utility.isNullOrEmpty(scheme)) {
            throw new IllegalArgumentException("The protocol to use is null. Please specify whether to use http or https.");
        }
        if (Utility.isNullOrEmpty(accountName)) {
            throw new IllegalArgumentException("The account name is null or empty.");
        }
        return new StorageUri(new URI(String.format(PRIMARY_ENDPOINT_FORMAT, scheme, accountName, BLOB_BASE_DNS_NAME)), new URI(String.format(SECONDARY_ENDPOINT_FORMAT, scheme, accountName, SECONDARY_LOCATION_ACCOUNT_SUFFIX, BLOB_BASE_DNS_NAME)));
    }

    private static StorageUri getDefaultQueueStorageUri(HashMap<String, String> settings) throws URISyntaxException {
        String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) : "http";
        String accountName = settings.get(ACCOUNT_NAME_NAME);
        return CloudStorageAccount.getDefaultQueueStorageUri(scheme, accountName);
    }

    private static StorageUri getDefaultQueueStorageUri(String scheme, String accountName) throws URISyntaxException {
        if (Utility.isNullOrEmpty(scheme)) {
            throw new IllegalArgumentException("The protocol to use is null. Please specify whether to use http or https.");
        }
        if (Utility.isNullOrEmpty(accountName)) {
            throw new IllegalArgumentException("The account name is null or empty.");
        }
        return new StorageUri(new URI(String.format(PRIMARY_ENDPOINT_FORMAT, scheme, accountName, QUEUE_BASE_DNS_NAME)), new URI(String.format(SECONDARY_ENDPOINT_FORMAT, scheme, accountName, SECONDARY_LOCATION_ACCOUNT_SUFFIX, QUEUE_BASE_DNS_NAME)));
    }

    private static StorageUri getDefaultTableStorageUri(HashMap<String, String> settings) throws URISyntaxException {
        String scheme = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) : "http";
        String accountName = settings.get(ACCOUNT_NAME_NAME);
        return CloudStorageAccount.getDefaultTableStorageUri(scheme, accountName);
    }

    private static StorageUri getDefaultTableStorageUri(String scheme, String accountName) throws URISyntaxException {
        if (Utility.isNullOrEmpty(scheme)) {
            throw new IllegalArgumentException("The protocol to use is null. Please specify whether to use http or https.");
        }
        if (Utility.isNullOrEmpty(accountName)) {
            throw new IllegalArgumentException("The account name is null or empty.");
        }
        return new StorageUri(new URI(String.format(PRIMARY_ENDPOINT_FORMAT, scheme, accountName, TABLE_BASE_DNS_NAME)), new URI(String.format(SECONDARY_ENDPOINT_FORMAT, scheme, accountName, SECONDARY_LOCATION_ACCOUNT_SUFFIX, TABLE_BASE_DNS_NAME)));
    }

    public static CloudStorageAccount getDevelopmentStorageAccount() {
        if (devStoreAccount == null) {
            try {
                devStoreAccount = CloudStorageAccount.getDevelopmentStorageAccount(new URI("http://127.0.0.1"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return devStoreAccount;
    }

    public static CloudStorageAccount getDevelopmentStorageAccount(URI proxyUri) throws URISyntaxException {
        if (proxyUri == null) {
            return CloudStorageAccount.getDevelopmentStorageAccount();
        }
        String prefix = proxyUri.getScheme().concat("://");
        prefix = prefix.concat(proxyUri.getHost());
        return new CloudStorageAccount((StorageCredentials)new StorageCredentialsAccountAndKey(DEVSTORE_ACCOUNT_NAME, DEVSTORE_ACCOUNT_KEY), new StorageUri(new URI(prefix.concat(":10000/devstoreaccount1"))), new StorageUri(new URI(prefix.concat(":10001/devstoreaccount1"))), new StorageUri(new URI(prefix.concat(":10002/devstoreaccount1"))));
    }

    public static CloudStorageAccount parse(String connectionString) throws URISyntaxException, InvalidKeyException {
        if (connectionString == null || connectionString.length() == 0) {
            throw new IllegalArgumentException("Invalid connection string.");
        }
        HashMap<String, String> settings = Utility.parseAccountString(connectionString);
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            if (entry.getValue() != null && !entry.getValue().equals("") || entry.getKey().equals(ACCOUNT_KEY_NAME)) continue;
            throw new IllegalArgumentException("Invalid connection string.");
        }
        CloudStorageAccount retVal = CloudStorageAccount.tryConfigureDevStore(settings);
        if (retVal != null) {
            return retVal;
        }
        retVal = CloudStorageAccount.tryConfigureServiceAccount(settings);
        if (retVal != null) {
            return retVal;
        }
        throw new IllegalArgumentException("Invalid connection string.");
    }

    private static CloudStorageAccount tryConfigureDevStore(HashMap<String, String> settings) throws URISyntaxException {
        if (settings.containsKey(USE_DEVELOPMENT_STORAGE_NAME)) {
            String useDevStoreSetting = settings.get(USE_DEVELOPMENT_STORAGE_NAME);
            URI devStoreProxyUri = null;
            if (!Boolean.parseBoolean(useDevStoreSetting)) {
                throw new IllegalArgumentException("Invalid connection string, the UseDevelopmentStorage key must always be paired with 'true'.  Remove the flag entirely otherwise.");
            }
            if (settings.containsKey(DEVELOPMENT_STORAGE_PROXY_URI_NAME)) {
                devStoreProxyUri = new URI(settings.get(DEVELOPMENT_STORAGE_PROXY_URI_NAME));
            }
            return CloudStorageAccount.getDevelopmentStorageAccount(devStoreProxyUri);
        }
        return null;
    }

    private static CloudStorageAccount tryConfigureServiceAccount(HashMap<String, String> settings) throws URISyntaxException, InvalidKeyException {
        String defaultEndpointSetting;
        if (settings.containsKey(USE_DEVELOPMENT_STORAGE_NAME)) {
            String useDevStoreSetting = settings.get(USE_DEVELOPMENT_STORAGE_NAME);
            if (!Boolean.parseBoolean(useDevStoreSetting)) {
                throw new IllegalArgumentException("Invalid connection string, the UseDevelopmentStorage key must always be paired with 'true'.  Remove the flag entirely otherwise.");
            }
            return null;
        }
        String string = defaultEndpointSetting = settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME) != null ? settings.get(DEFAULT_ENDPOINTS_PROTOCOL_NAME).toLowerCase() : null;
        if (defaultEndpointSetting != null && !defaultEndpointSetting.equals("http") && !defaultEndpointSetting.equals("https")) {
            return null;
        }
        StorageCredentials credentials = StorageCredentials.tryParseCredentials(settings);
        boolean isExplicitBlobEndpoint = settings.containsKey(BLOB_ENDPOINT_NAME);
        boolean isExplicitQueueEndpoint = settings.containsKey(QUEUE_ENDPOINT_NAME);
        boolean isExplicitTableEndpoint = settings.containsKey(TABLE_ENDPOINT_NAME);
        StorageUri blobURI = isExplicitBlobEndpoint ? new StorageUri(new URI(settings.get(BLOB_ENDPOINT_NAME))) : null;
        StorageUri queueURI = isExplicitQueueEndpoint ? new StorageUri(new URI(settings.get(QUEUE_ENDPOINT_NAME))) : null;
        StorageUri tableURI = isExplicitTableEndpoint ? new StorageUri(new URI(settings.get(TABLE_ENDPOINT_NAME))) : null;
        CloudStorageAccount retVal = null;
        if (defaultEndpointSetting != null && settings.containsKey(ACCOUNT_NAME_NAME) && settings.containsKey(ACCOUNT_KEY_NAME)) {
            retVal = new CloudStorageAccount(credentials, isExplicitBlobEndpoint ? blobURI : CloudStorageAccount.getDefaultBlobStorageUri(settings), isExplicitQueueEndpoint ? queueURI : CloudStorageAccount.getDefaultQueueStorageUri(settings), isExplicitTableEndpoint ? tableURI : CloudStorageAccount.getDefaultTableStorageUri(settings));
            retVal.isBlobEndpointDefault = !isExplicitBlobEndpoint;
            retVal.isQueueEndpointDefault = !isExplicitQueueEndpoint;
            retVal.isTableEndpointDefault = !isExplicitTableEndpoint;
        } else if (isExplicitBlobEndpoint || isExplicitQueueEndpoint || isExplicitTableEndpoint) {
            retVal = new CloudStorageAccount(credentials, blobURI, queueURI, tableURI);
        }
        return retVal;
    }

    public CloudStorageAccount(StorageCredentials storageCredentials) throws URISyntaxException {
        Utility.assertNotNull("storageCredentials", storageCredentials);
        this.credentials = storageCredentials;
        this.isBlobEndpointDefault = true;
        this.isQueueEndpointDefault = true;
        this.isTableEndpointDefault = true;
        this.blobStorageUri = CloudStorageAccount.getDefaultBlobStorageUri("http", this.credentials.getAccountName());
        this.queueStorageUri = CloudStorageAccount.getDefaultQueueStorageUri("http", this.credentials.getAccountName());
        this.tableStorageUri = CloudStorageAccount.getDefaultTableStorageUri("http", this.credentials.getAccountName());
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, URI blobEndpoint, URI queueEndpoint, URI tableEndpoint) {
        this(storageCredentials, new StorageUri(blobEndpoint), new StorageUri(queueEndpoint), new StorageUri(tableEndpoint));
    }

    public CloudStorageAccount(StorageCredentials storageCredentials, StorageUri blobStorageUri, StorageUri queueStorageUri, StorageUri tableStorageUri) {
        this.credentials = storageCredentials;
        this.blobStorageUri = blobStorageUri;
        this.queueStorageUri = queueStorageUri;
        this.tableStorageUri = tableStorageUri;
    }

    public CloudStorageAccount(StorageCredentialsAccountAndKey storageCredentials, boolean useHttps) throws URISyntaxException {
        Utility.assertNotNull("storageCredentials", storageCredentials);
        this.credentials = storageCredentials;
        this.blobStorageUri = CloudStorageAccount.getDefaultBlobStorageUri(useHttps ? "https" : "http", storageCredentials.getAccountName());
        this.queueStorageUri = CloudStorageAccount.getDefaultQueueStorageUri(useHttps ? "https" : "http", storageCredentials.getAccountName());
        this.tableStorageUri = CloudStorageAccount.getDefaultTableStorageUri(useHttps ? "https" : "http", storageCredentials.getAccountName());
        this.isBlobEndpointDefault = true;
        this.isQueueEndpointDefault = true;
        this.isTableEndpointDefault = true;
    }

    public CloudBlobClient createCloudBlobClient() {
        if (this.getBlobStorageUri() == null) {
            throw new IllegalArgumentException("No blob endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!this.credentials.canCredentialsSignRequest()) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudBlobClient(this.getBlobStorageUri(), this.getCredentials());
    }

    public CloudQueueClient createCloudQueueClient() {
        if (this.getQueueStorageUri() == null) {
            throw new IllegalArgumentException("No queue endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!this.credentials.canCredentialsSignRequest()) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudQueueClient(this.getQueueStorageUri(), this.getCredentials());
    }

    public CloudTableClient createCloudTableClient() {
        if (this.getTableStorageUri() == null) {
            throw new IllegalArgumentException("No table endpoint configured.");
        }
        if (this.credentials == null) {
            throw new IllegalArgumentException("No credentials provided.");
        }
        if (!this.credentials.canCredentialsSignRequest()) {
            throw new IllegalArgumentException("CloudBlobClient, CloudQueueClient and CloudTableClient require credentials that can sign a request.");
        }
        return new CloudTableClient(this.getTableStorageUri(), this.getCredentials());
    }

    public URI getBlobEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.blobStorageUri == null) {
            return null;
        }
        return this.blobStorageUri.getPrimaryUri();
    }

    public StorageUri getBlobStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.blobStorageUri;
    }

    public StorageCredentials getCredentials() {
        return this.credentials;
    }

    public URI getQueueEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.queueStorageUri == null) {
            return null;
        }
        return this.queueStorageUri.getPrimaryUri();
    }

    public StorageUri getQueueStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.queueStorageUri;
    }

    public URI getTableEndpoint() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        if (this.tableStorageUri == null) {
            return null;
        }
        return this.tableStorageUri.getPrimaryUri();
    }

    public StorageUri getTableStorageUri() {
        if (this.getCredentials() instanceof StorageCredentialsSharedAccessSignature) {
            throw new IllegalArgumentException("Endpoint information not available for Account using Shared Access Credentials.");
        }
        return this.tableStorageUri;
    }

    protected void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean exportSecrets) {
        if (this.credentials != null && Utility.isNullOrEmpty(this.credentials.getAccountName())) {
            return this.credentials.toString(exportSecrets);
        }
        ArrayList<String> retVals = new ArrayList<String>();
        if (this == devStoreAccount) {
            retVals.add(String.format("%s=true", USE_DEVELOPMENT_STORAGE_NAME));
        } else if (this.credentials != null && DEVSTORE_ACCOUNT_NAME.equals(this.credentials.getAccountName()) && this.credentials.toString(true).equals(DEVSTORE_CREDENTIALS_IN_STRING) && this.getBlobStorageUri() != null && this.getTableStorageUri() != null && this.getQueueStorageUri() != null && this.getBlobEndpoint().getHost().equals(this.getQueueEndpoint().getHost()) && this.getQueueEndpoint().getHost().equals(this.getTableEndpoint().getHost()) && this.getBlobEndpoint().getScheme().equals(this.getQueueEndpoint().getScheme()) && this.getQueueEndpoint().getScheme().equals(this.getTableEndpoint().getScheme())) {
            retVals.add(String.format("%s=true", USE_DEVELOPMENT_STORAGE_NAME));
            retVals.add(String.format("%s=%s://%s/", DEVELOPMENT_STORAGE_PROXY_URI_NAME, this.getBlobEndpoint().getScheme(), this.getBlobEndpoint().getHost()));
        } else {
            boolean addDefault = false;
            if (this.getBlobStorageUri() != null) {
                if (this.isBlobEndpointDefault) {
                    addDefault = true;
                } else {
                    retVals.add(String.format("%s=%s", BLOB_ENDPOINT_NAME, this.getBlobEndpoint()));
                }
            }
            if (this.getQueueStorageUri() != null) {
                if (this.isQueueEndpointDefault) {
                    addDefault = true;
                } else {
                    retVals.add(String.format("%s=%s", QUEUE_ENDPOINT_NAME, this.getQueueEndpoint()));
                }
            }
            if (this.getTableStorageUri() != null) {
                if (this.isTableEndpointDefault) {
                    addDefault = true;
                } else {
                    retVals.add(String.format("%s=%s", TABLE_ENDPOINT_NAME, this.getTableEndpoint()));
                }
            }
            if (addDefault) {
                retVals.add(String.format("%s=%s", DEFAULT_ENDPOINTS_PROTOCOL_NAME, this.getBlobEndpoint().getScheme()));
            }
            if (this.getCredentials() != null) {
                retVals.add(this.getCredentials().toString(exportSecrets));
            }
        }
        StringBuilder returnString = new StringBuilder();
        for (String val : retVals) {
            returnString.append(val);
            returnString.append(';');
        }
        if (retVals.size() > 0) {
            returnString.deleteCharAt(returnString.length() - 1);
        }
        return returnString.toString();
    }
}

