/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.RequestCompletedEvent;
import com.microsoft.windowsazure.storage.RequestResult;
import com.microsoft.windowsazure.storage.ResponseReceivedEvent;
import com.microsoft.windowsazure.storage.RetryingEvent;
import com.microsoft.windowsazure.storage.SendingRequestEvent;
import com.microsoft.windowsazure.storage.StorageEvent;
import com.microsoft.windowsazure.storage.StorageEventMultiCaster;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OperationContext {
    public static final String defaultLoggerName = "ROOT";
    private static boolean enableLoggingByDefault = false;
    private long clientTimeInMs;
    private String clientRequestID;
    private Boolean enableLogging;
    private Logger logger;
    private final ArrayList<RequestResult> requestResults;
    private HashMap<String, String> userHeaders;
    private static StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> globalSendingRequestEventHandler = new StorageEventMultiCaster();
    private static StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> globalResponseReceivedEventHandler = new StorageEventMultiCaster();
    private static StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> globalRequestCompletedEventHandler = new StorageEventMultiCaster();
    private static StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> globalRetryingEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> sendingRequestEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> responseReceivedEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> requestCompletedEventHandler = new StorageEventMultiCaster();
    private StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> retryingEventHandler = new StorageEventMultiCaster();
    private HttpURLConnection currentRequestObject;

    public OperationContext() {
        this.clientRequestID = UUID.randomUUID().toString();
        this.requestResults = new ArrayList();
    }

    public String getClientRequestID() {
        return this.clientRequestID;
    }

    public long getClientTimeInMs() {
        return this.clientTimeInMs;
    }

    @Deprecated
    public HttpURLConnection getCurrentRequestObject() {
        return this.currentRequestObject;
    }

    public synchronized RequestResult getLastResult() {
        if (this.requestResults == null || this.requestResults.size() == 0) {
            return null;
        }
        return this.requestResults.get(this.requestResults.size() - 1);
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.setDefaultLoggerSynchronized();
        }
        return this.logger;
    }

    public HashMap<String, String> getUserHeaders() {
        return this.userHeaders;
    }

    private synchronized void setDefaultLoggerSynchronized() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)defaultLoggerName);
        }
    }

    public ArrayList<RequestResult> getRequestResults() {
        return this.requestResults;
    }

    public synchronized void appendRequestResult(RequestResult requestResult) {
        this.requestResults.add(requestResult);
    }

    public static StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> getGlobalSendingRequestEventHandler() {
        return globalSendingRequestEventHandler;
    }

    public static StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> getGlobalResponseReceivedEventHandler() {
        return globalResponseReceivedEventHandler;
    }

    public static StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> getGlobalRequestCompletedEventHandler() {
        return globalRequestCompletedEventHandler;
    }

    public static StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> getGlobalRetryingEventHandler() {
        return globalRetryingEventHandler;
    }

    public StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> getSendingRequestEventHandler() {
        return this.sendingRequestEventHandler;
    }

    public StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> getResponseReceivedEventHandler() {
        return this.responseReceivedEventHandler;
    }

    public StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> getRequestCompletedEventHandler() {
        return this.requestCompletedEventHandler;
    }

    public StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> getRetryingEventHandler() {
        return this.retryingEventHandler;
    }

    public void initialize() {
        this.setClientTimeInMs(0L);
        this.requestResults.clear();
        this.setCurrentRequestObject(null);
    }

    public boolean isLoggingEnabled() {
        if (this.enableLogging == null) {
            return enableLoggingByDefault;
        }
        return this.enableLogging;
    }

    public void setClientRequestID(String clientRequestID) {
        this.clientRequestID = clientRequestID;
    }

    public void setClientTimeInMs(long clientTimeInMs) {
        this.clientTimeInMs = clientTimeInMs;
    }

    @Deprecated
    public void setCurrentRequestObject(HttpURLConnection currentRequestObject) {
        this.currentRequestObject = currentRequestObject;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setUserHeaders(HashMap<String, String> userHeaders) {
        this.userHeaders = userHeaders;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.enableLogging = loggingEnabled;
    }

    public static void setGlobalSendingRequestEventHandler(StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> globalSendingRequestEventHandler) {
        OperationContext.globalSendingRequestEventHandler = globalSendingRequestEventHandler;
    }

    public static void setGlobalResponseReceivedEventHandler(StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> globalResponseReceivedEventHandler) {
        OperationContext.globalResponseReceivedEventHandler = globalResponseReceivedEventHandler;
    }

    public static void setGlobalRequestCompletedEventHandler(StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> globalRequestCompletedEventHandler) {
        OperationContext.globalRequestCompletedEventHandler = globalRequestCompletedEventHandler;
    }

    public static void setGlobalRetryingEventHandler(StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> globalRetryingEventHandler) {
        OperationContext.globalRetryingEventHandler = globalRetryingEventHandler;
    }

    public void setSendingRequestEventHandler(StorageEventMultiCaster<SendingRequestEvent, StorageEvent<SendingRequestEvent>> sendingRequestEventHandler) {
        this.sendingRequestEventHandler = sendingRequestEventHandler;
    }

    public void setResponseReceivedEventHandler(StorageEventMultiCaster<ResponseReceivedEvent, StorageEvent<ResponseReceivedEvent>> responseReceivedEventHandler) {
        this.responseReceivedEventHandler = responseReceivedEventHandler;
    }

    public void setRequestCompletedEventHandler(StorageEventMultiCaster<RequestCompletedEvent, StorageEvent<RequestCompletedEvent>> requestCompletedEventHandler) {
        this.requestCompletedEventHandler = requestCompletedEventHandler;
    }

    public void setRetryingEventHandler(StorageEventMultiCaster<RetryingEvent, StorageEvent<RetryingEvent>> retryingEventHandler) {
        this.retryingEventHandler = retryingEventHandler;
    }

    public static boolean isLoggingEnabledByDefault() {
        return enableLoggingByDefault;
    }

    public static void setLoggingEnabledByDefault(boolean enableLoggingByDefault) {
        OperationContext.enableLoggingByDefault = enableLoggingByDefault;
    }
}

