/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.LocationMode;
import com.microsoft.windowsazure.storage.RequestResult;
import com.microsoft.windowsazure.storage.StorageLocation;
import com.microsoft.windowsazure.storage.core.Utility;

public final class RetryContext {
    private final StorageLocation nextLocation;
    private final LocationMode locationMode;
    public final int currentRetryCount;
    public final RequestResult lastRequestResult;

    public RetryContext(int currentRetryCount, RequestResult lastRequestResult, StorageLocation nextLocation, LocationMode locationMode) {
        this.currentRetryCount = currentRetryCount;
        this.lastRequestResult = lastRequestResult;
        this.nextLocation = nextLocation;
        this.locationMode = locationMode;
    }

    public int getCurrentRetryCount() {
        return this.currentRetryCount;
    }

    public RequestResult getLastRequestResult() {
        return this.lastRequestResult;
    }

    public LocationMode getLocationMode() {
        return this.locationMode;
    }

    public StorageLocation getNextLocation() {
        return this.nextLocation;
    }

    public String toString() {
        return String.format(Utility.LOCALE_US, "(%s,%s)", new Object[]{this.currentRetryCount, this.locationMode});
    }
}

