/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.AuthenticationScheme;
import com.microsoft.windowsazure.storage.LocationMode;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.RetryExponentialRetry;
import com.microsoft.windowsazure.storage.RetryPolicyFactory;
import com.microsoft.windowsazure.storage.ServiceProperties;
import com.microsoft.windowsazure.storage.ServicePropertiesDeserializer;
import com.microsoft.windowsazure.storage.ServicePropertiesSerializer;
import com.microsoft.windowsazure.storage.ServiceStats;
import com.microsoft.windowsazure.storage.ServiceStatsDeserializer;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageCredentialsAnonymous;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.core.BaseRequest;
import com.microsoft.windowsazure.storage.core.RequestLocationMode;
import com.microsoft.windowsazure.storage.core.StorageRequest;
import com.microsoft.windowsazure.storage.core.StreamMd5AndLength;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import javax.xml.stream.XMLStreamException;

public abstract class ServiceClient {
    private StorageUri storageUri;
    private LocationMode locationMode;
    protected StorageCredentials credentials;
    private boolean usePathStyleUris;
    protected RetryPolicyFactory retryPolicyFactory = new RetryExponentialRetry();
    protected int timeoutInMs = 90000;
    private Integer maximumExecutionTimeInMs;
    protected AuthenticationScheme authenticationScheme = AuthenticationScheme.SHAREDKEYFULL;

    public ServiceClient(URI baseUri) {
        this(new StorageUri(baseUri), null);
    }

    public ServiceClient(URI baseUri, StorageCredentials credentials) {
        this(new StorageUri(baseUri), credentials);
    }

    public ServiceClient(StorageUri storageUri, StorageCredentials credentials) {
        Utility.assertNotNull("baseUri", storageUri);
        if (!storageUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address %s is a relative address. Only absolute addresses are permitted.", storageUri));
        }
        this.credentials = credentials == null ? StorageCredentialsAnonymous.ANONYMOUS : credentials;
        this.retryPolicyFactory = new RetryExponentialRetry();
        this.timeoutInMs = 90000;
        this.usePathStyleUris = Utility.determinePathStyleFromUri(storageUri.getPrimaryUri(), this.credentials.getAccountName());
        this.storageUri = storageUri;
        this.locationMode = LocationMode.PRIMARY_ONLY;
    }

    protected StorageRequest<ServiceClient, Void, ServiceProperties> downloadServicePropertiesImpl(final RequestOptions options, final boolean signAsTable) throws StorageException {
        StorageRequest<ServiceClient, Void, ServiceProperties> getRequest = new StorageRequest<ServiceClient, Void, ServiceProperties>(options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                return BaseRequest.getServiceProperties(client.getEndpoint(), options.getTimeoutIntervalInMs(), null, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                if (signAsTable) {
                    StorageRequest.signTableRequest(connection, client, -1L, null);
                } else {
                    StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
                }
            }

            @Override
            public ServiceProperties preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ServiceProperties postProcessResponse(HttpURLConnection connection, Void parentObject, ServiceClient client, OperationContext context, ServiceProperties storageObject) throws Exception {
                return ServicePropertiesDeserializer.readServicePropertiesFromStream(connection.getInputStream(), context);
            }
        };
        return getRequest;
    }

    protected StorageRequest<ServiceClient, Void, ServiceStats> getServiceStatsImpl(final RequestOptions options, final boolean signAsTable) throws StorageException {
        StorageRequest<ServiceClient, Void, ServiceStats> getRequest = new StorageRequest<ServiceClient, Void, ServiceStats>(options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.applyLocationModeToRequest();
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                return BaseRequest.getServiceStats(client.getStorageUri().getUri(this.getCurrentLocation()), options.getTimeoutIntervalInMs(), null, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                if (signAsTable) {
                    StorageRequest.signTableRequest(connection, client, -1L, null);
                } else {
                    StorageRequest.signBlobAndQueueRequest(connection, client, -1L, null);
                }
            }

            @Override
            public ServiceStats preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                }
                return null;
            }

            @Override
            public ServiceStats postProcessResponse(HttpURLConnection connection, Void parentObject, ServiceClient client, OperationContext context, ServiceStats storageObject) throws Exception {
                return ServiceStatsDeserializer.readServiceStatsFromStream(connection.getInputStream(), context);
            }
        };
        return getRequest;
    }

    public final StorageCredentials getCredentials() {
        return this.credentials;
    }

    public final AuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public final URI getEndpoint() {
        return this.storageUri.getPrimaryUri();
    }

    public final LocationMode getLocationMode() {
        return this.locationMode;
    }

    public final RetryPolicyFactory getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    public final int getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public Integer getMaximumExecutionTimeInMs() {
        return this.maximumExecutionTimeInMs;
    }

    public final boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    protected final void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    public void setLocationMode(LocationMode locationMode) {
        this.locationMode = locationMode;
    }

    protected final void setStorageUri(StorageUri storageUri) {
        this.usePathStyleUris = Utility.determinePathStyleFromUri(storageUri.getPrimaryUri(), this.credentials.getAccountName());
        this.storageUri = storageUri;
    }

    public final void setAuthenticationScheme(AuthenticationScheme scheme) {
        this.authenticationScheme = scheme;
    }

    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.retryPolicyFactory = retryPolicyFactory;
    }

    public final void setTimeoutInMs(int timeoutInMs) {
        this.timeoutInMs = timeoutInMs;
    }

    public void setMaximumExecutionTimeInMs(Integer maximumExecutionTimeInMs) {
        this.maximumExecutionTimeInMs = maximumExecutionTimeInMs;
    }

    protected StorageRequest<ServiceClient, Void, Void> uploadServicePropertiesImpl(ServiceProperties properties, final RequestOptions options, OperationContext opContext, final boolean signAsTable) throws StorageException {
        try {
            byte[] propertiesBytes = ServicePropertiesSerializer.serializeToByteArray(properties);
            final ByteArrayInputStream sendStream = new ByteArrayInputStream(propertiesBytes);
            final StreamMd5AndLength descriptor = Utility.analyzeStream(sendStream, -1L, -1L, true, true);
            StorageRequest<ServiceClient, Void, Void> putRequest = new StorageRequest<ServiceClient, Void, Void>(options, this.getStorageUri()){

                @Override
                public HttpURLConnection buildRequest(ServiceClient client, Void parentObject, OperationContext context) throws Exception {
                    this.setSendStream(sendStream);
                    this.setLength(descriptor.getLength());
                    return BaseRequest.setServiceProperties(client.getEndpoint(), options.getTimeoutIntervalInMs(), null, context);
                }

                @Override
                public void setHeaders(HttpURLConnection connection, Void parentObject, OperationContext context) {
                    connection.setRequestProperty("Content-MD5", descriptor.getMd5());
                }

                @Override
                public void signRequest(HttpURLConnection connection, ServiceClient client, OperationContext context) throws Exception {
                    if (signAsTable) {
                        StorageRequest.signTableRequest(connection, client, descriptor.getLength(), null);
                    } else {
                        StorageRequest.signBlobAndQueueRequest(connection, client, descriptor.getLength(), null);
                    }
                }

                @Override
                public Void preProcessResponse(Void parentObject, ServiceClient client, OperationContext context) throws Exception {
                    if (this.getResult().getStatusCode() != 202) {
                        this.setNonExceptionedRetryableFailure(true);
                    }
                    return null;
                }

                @Override
                public void recoveryAction(OperationContext context) throws IOException {
                    sendStream.reset();
                    sendStream.mark(0x4000000);
                }
            };
            return putRequest;
        }
        catch (IllegalArgumentException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (XMLStreamException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
        catch (IOException e) {
            StorageException translatedException = StorageException.translateException(null, e, null);
            throw translatedException;
        }
    }
}

