/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.CorsHttpMethods;
import com.microsoft.windowsazure.storage.CorsProperties;
import com.microsoft.windowsazure.storage.CorsRule;
import com.microsoft.windowsazure.storage.LoggingOperations;
import com.microsoft.windowsazure.storage.LoggingProperties;
import com.microsoft.windowsazure.storage.MetricsLevel;
import com.microsoft.windowsazure.storage.MetricsProperties;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.ServiceProperties;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class ServicePropertiesDeserializer {
    public static ServiceProperties readServicePropertiesFromStream(InputStream inStream, OperationContext opContext) throws XMLStreamException, StorageException {
        ServiceProperties retProps = new ServiceProperties();
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(inStream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "StorageServiceProperties");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals("Logging")) {
                    retProps.setLogging(ServicePropertiesDeserializer.readLoggingProperties(xmlr));
                    xmlr.require(2, null, "Logging");
                    continue;
                }
                if (name.equals("HourMetrics")) {
                    retProps.setHourMetrics(ServicePropertiesDeserializer.readMetricsProperties("HourMetrics", xmlr));
                    xmlr.require(2, null, "HourMetrics");
                    continue;
                }
                if (name.equals("MinuteMetrics")) {
                    retProps.setMinuteMetrics(ServicePropertiesDeserializer.readMetricsProperties("MinuteMetrics", xmlr));
                    xmlr.require(2, null, "MinuteMetrics");
                    continue;
                }
                if (name.equals("Cors")) {
                    retProps.setCors(ServicePropertiesDeserializer.readCorsProperties(xmlr));
                    xmlr.require(2, null, "Cors");
                    continue;
                }
                if (name.equals("DefaultServiceVersion")) {
                    retProps.setDefaultServiceVersion(DeserializationHelper.readElementFromXMLReader(xmlr, "DefaultServiceVersion"));
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            if (eventType != 2 || !xmlr.getName().toString().equals("StorageServiceProperties")) continue;
            break;
        }
        return retProps;
    }

    private static LoggingProperties readLoggingProperties(XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        xmlr.require(1, null, "Logging");
        int eventType = xmlr.getEventType();
        String tempParseString = null;
        LoggingProperties logging = new LoggingProperties();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals("Version")) {
                    logging.setVersion(DeserializationHelper.readElementFromXMLReader(xmlr, "Version"));
                    continue;
                }
                if (name.equals("Delete")) {
                    tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "Delete");
                    if (!Boolean.parseBoolean(tempParseString)) continue;
                    logging.getLogOperationTypes().add(LoggingOperations.DELETE);
                    continue;
                }
                if (name.equals("Read")) {
                    tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "Read");
                    if (!Boolean.parseBoolean(tempParseString)) continue;
                    logging.getLogOperationTypes().add(LoggingOperations.READ);
                    continue;
                }
                if (name.equals("Write")) {
                    tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "Write");
                    if (!Boolean.parseBoolean(tempParseString)) continue;
                    logging.getLogOperationTypes().add(LoggingOperations.WRITE);
                    continue;
                }
                if (name.equals("RetentionPolicy")) {
                    logging.setRetentionIntervalInDays(ServicePropertiesDeserializer.readRetentionPolicy(xmlr));
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            xmlr.require(2, null, "Logging");
            break;
        }
        return logging;
    }

    private static MetricsProperties readMetricsProperties(String metricsName, XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        xmlr.require(1, null, metricsName);
        int eventType = xmlr.getEventType();
        String tempParseString = null;
        MetricsProperties metrics = new MetricsProperties();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals("Version")) {
                    metrics.setVersion(DeserializationHelper.readElementFromXMLReader(xmlr, "Version"));
                    continue;
                }
                if (name.equals("Enabled")) {
                    tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "Enabled");
                    if (Boolean.parseBoolean(tempParseString)) {
                        metrics.setMetricsLevel(metrics.getMetricsLevel() != MetricsLevel.SERVICE_AND_API ? MetricsLevel.SERVICE : MetricsLevel.SERVICE_AND_API);
                        continue;
                    }
                    metrics.setMetricsLevel(MetricsLevel.DISABLED);
                    continue;
                }
                if (name.equals("IncludeAPIs")) {
                    tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "IncludeAPIs");
                    if (!Boolean.parseBoolean(tempParseString) || metrics.getMetricsLevel() == MetricsLevel.DISABLED) continue;
                    metrics.setMetricsLevel(MetricsLevel.SERVICE_AND_API);
                    continue;
                }
                if (name.equals("RetentionPolicy")) {
                    metrics.setRetentionIntervalInDays(ServicePropertiesDeserializer.readRetentionPolicy(xmlr));
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            xmlr.require(2, null, metricsName);
            break;
        }
        return metrics;
    }

    private static Integer readRetentionPolicy(XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        xmlr.require(1, null, "RetentionPolicy");
        Integer retVal = -1;
        int eventType = xmlr.getEventType();
        String tempParseString = null;
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals("Days")) {
                    tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "Days");
                    if (retVal == null) continue;
                    retVal = Integer.parseInt(tempParseString);
                    continue;
                }
                if (name.equals("Enabled")) {
                    tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "Enabled");
                    if (Boolean.parseBoolean(tempParseString)) continue;
                    retVal = null;
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            xmlr.require(2, null, "RetentionPolicy");
            break;
        }
        return retVal;
    }

    private static CorsProperties readCorsProperties(XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        xmlr.require(1, null, "Cors");
        CorsProperties corsProperties = new CorsProperties();
        int eventType = xmlr.getEventType();
        String tempParseString = null;
        block0: while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                if (xmlr.getName().toString().equals("CorsRule")) {
                    CorsRule rule = new CorsRule();
                    while (xmlr.hasNext()) {
                        eventType = xmlr.next();
                        if (eventType == 1) {
                            String name = xmlr.getName().toString();
                            if (name.equals("AllowedOrigins")) {
                                tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "AllowedOrigins");
                                if (tempParseString == null) continue;
                                rule.setAllowedOrigins(ServicePropertiesDeserializer.splitToList(tempParseString, ","));
                                continue;
                            }
                            if (name.equals("AllowedMethods")) {
                                tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "AllowedMethods");
                                if (tempParseString == null) continue;
                                rule.setAllowedMethods(ServicePropertiesDeserializer.splitToEnumSet(tempParseString, ","));
                                continue;
                            }
                            if (name.equals("ExposedHeaders")) {
                                tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "ExposedHeaders");
                                if (tempParseString == null) continue;
                                rule.setExposedHeaders(ServicePropertiesDeserializer.splitToList(tempParseString, ","));
                                continue;
                            }
                            if (name.equals("AllowedHeaders")) {
                                tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "AllowedHeaders");
                                if (tempParseString == null) continue;
                                rule.setAllowedHeaders(ServicePropertiesDeserializer.splitToList(tempParseString, ","));
                                continue;
                            }
                            if (name.equals("MaxAgeInSeconds")) {
                                tempParseString = DeserializationHelper.readElementFromXMLReader(xmlr, "MaxAgeInSeconds");
                                rule.setMaxAgeInSeconds(Integer.parseInt(tempParseString));
                                continue;
                            }
                            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                        }
                        xmlr.require(2, null, "CorsRule");
                        corsProperties.getCorsRules().add(rule);
                        continue block0;
                    }
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            xmlr.require(2, null, "Cors");
            break;
        }
        return corsProperties;
    }

    private static List<String> splitToList(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            list.add(st.nextToken());
        }
        return list;
    }

    private static EnumSet<CorsHttpMethods> splitToEnumSet(String str, String delimiter) throws StorageException {
        EnumSet<CorsHttpMethods> set = EnumSet.noneOf(CorsHttpMethods.class);
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreElements()) {
            set.add(CorsHttpMethods.valueOf(st.nextToken()));
        }
        return set;
    }
}

