/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.Credentials;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageCredentials;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageKey;
import com.microsoft.windowsazure.storage.core.Base64;
import com.microsoft.windowsazure.storage.core.BaseRequest;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.InvalidKeyException;

public final class StorageCredentialsAccountAndKey
extends StorageCredentials {
    private Credentials credentials;

    public StorageCredentialsAccountAndKey(String accountName, byte[] key) {
        this.credentials = new Credentials(accountName, key);
    }

    public StorageCredentialsAccountAndKey(String accountName, String key) {
        this(accountName, Base64.decode(key));
    }

    @Override
    public boolean canCredentialsComputeHmac() {
        return true;
    }

    @Override
    public boolean canCredentialsSignRequest() {
        return true;
    }

    @Override
    public boolean canCredentialsSignRequestLite() {
        return true;
    }

    @Override
    public String computeHmac256(String value) throws InvalidKeyException {
        return this.computeHmac256(value, null);
    }

    @Override
    public String computeHmac256(String value, OperationContext opContext) throws InvalidKeyException {
        return StorageKey.computeMacSha256(this.credentials.getKey(), value);
    }

    @Override
    public String computeHmac512(String value) throws InvalidKeyException {
        return this.computeHmac512(value, null);
    }

    @Override
    public String computeHmac512(String value, OperationContext opContext) throws InvalidKeyException {
        return StorageKey.computeMacSha512(this.credentials.getKey(), value);
    }

    @Override
    public boolean doCredentialsNeedTransformUri() {
        return false;
    }

    @Override
    public String getAccountName() {
        return this.credentials.getAccountName();
    }

    public String getAccountKeyName() {
        return this.credentials.getKeyName();
    }

    public void setSigningAccountName(String signingAccountName) {
        this.credentials.setSigningAccountName(signingAccountName);
    }

    protected String getBase64EncodedKey() {
        return this.credentials.getKey().getBase64EncodedKey();
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    @Deprecated
    public void signRequest(HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        this.signBlobAndQueueRequest(request, contentLength, null);
    }

    @Override
    @Deprecated
    public void signRequest(HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        opContext = opContext == null ? new OperationContext() : opContext;
        BaseRequest.signRequestForBlobAndQueue(request, this.credentials, contentLength, opContext);
    }

    @Override
    @Deprecated
    public void signRequestLite(HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        this.signTableRequestLite(request, contentLength, null);
    }

    @Override
    @Deprecated
    public void signRequestLite(HttpURLConnection request, long contentLength, OperationContext opContext) throws StorageException, InvalidKeyException {
        opContext = opContext == null ? new OperationContext() : opContext;
        BaseRequest.signRequestForTableSharedKeyLite(request, this.credentials, contentLength, opContext);
    }

    @Override
    public void signBlobAndQueueRequest(HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        this.signBlobAndQueueRequest(request, contentLength, null);
    }

    @Override
    public void signBlobAndQueueRequest(HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        opContext = opContext == null ? new OperationContext() : opContext;
        BaseRequest.signRequestForBlobAndQueue(request, this.credentials, contentLength, opContext);
    }

    @Override
    public void signBlobAndQueueRequestLite(HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        this.signBlobAndQueueRequestLite(request, contentLength, null);
    }

    @Override
    public void signBlobAndQueueRequestLite(HttpURLConnection request, long contentLength, OperationContext opContext) throws StorageException, InvalidKeyException {
        opContext = opContext == null ? new OperationContext() : opContext;
        BaseRequest.signRequestForBlobAndQueueSharedKeyLite(request, this.credentials, contentLength, opContext);
    }

    @Override
    public void signTableRequest(HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        this.signTableRequest(request, contentLength, null);
    }

    @Override
    public void signTableRequest(HttpURLConnection request, long contentLength, OperationContext opContext) throws InvalidKeyException, StorageException {
        opContext = opContext == null ? new OperationContext() : opContext;
        BaseRequest.signRequestForTableSharedKey(request, this.credentials, contentLength, opContext);
    }

    @Override
    public void signTableRequestLite(HttpURLConnection request, long contentLength) throws InvalidKeyException, StorageException {
        this.signTableRequestLite(request, contentLength, null);
    }

    @Override
    public void signTableRequestLite(HttpURLConnection request, long contentLength, OperationContext opContext) throws StorageException, InvalidKeyException {
        opContext = opContext == null ? new OperationContext() : opContext;
        BaseRequest.signRequestForTableSharedKeyLite(request, this.credentials, contentLength, opContext);
    }

    @Override
    public String toString(boolean exportSecrets) {
        return String.format("%s=%s;%s=%s", "AccountName", this.getAccountName(), "AccountKey", exportSecrets ? this.credentials.getKey().getBase64EncodedKey() : "[key hidden]");
    }

    @Override
    public URI transformUri(URI resourceUri) {
        return this.transformUri(resourceUri, null);
    }

    @Override
    public URI transformUri(URI resourceUri, OperationContext opContext) {
        return resourceUri;
    }
}

