/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.LeaseDuration;
import com.microsoft.windowsazure.storage.LeaseState;
import com.microsoft.windowsazure.storage.LeaseStatus;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.blob.BlobContainerAttributes;
import com.microsoft.windowsazure.storage.blob.BlobContainerProperties;
import com.microsoft.windowsazure.storage.blob.BlobProperties;
import com.microsoft.windowsazure.storage.blob.BlobType;
import com.microsoft.windowsazure.storage.blob.BlockEntry;
import com.microsoft.windowsazure.storage.blob.BlockSearchMode;
import com.microsoft.windowsazure.storage.blob.CloudBlob;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.blob.CloudBlobContainer;
import com.microsoft.windowsazure.storage.blob.CloudBlobDirectory;
import com.microsoft.windowsazure.storage.blob.CloudBlockBlob;
import com.microsoft.windowsazure.storage.blob.CloudPageBlob;
import com.microsoft.windowsazure.storage.blob.CopyState;
import com.microsoft.windowsazure.storage.blob.CopyStatus;
import com.microsoft.windowsazure.storage.blob.ListBlobItem;
import com.microsoft.windowsazure.storage.blob.PageRange;
import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import com.microsoft.windowsazure.storage.core.PathUtility;
import com.microsoft.windowsazure.storage.core.Utility;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class BlobDeserializationHelper {
    private static CloudBlob readBlob(XMLStreamReader xmlr, CloudBlobClient serviceClient, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Blob");
        String blobName = "";
        String snapshotID = null;
        HashMap<String, String> metadata = null;
        BlobProperties properties = null;
        int eventType = xmlr.getEventType();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Name")) {
                    blobName = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Name");
                    continue;
                }
                if (name.equals("Snapshot")) {
                    snapshotID = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Snapshot");
                    continue;
                }
                if (name.equals("Properties")) {
                    properties = BlobDeserializationHelper.readBlobProperties(xmlr);
                    xmlr.require(2, null, "Properties");
                    continue;
                }
                if (!name.equals("Metadata")) continue;
                metadata = DeserializationHelper.parseMetadateFromXML(xmlr);
                xmlr.require(2, null, "Metadata");
                continue;
            }
            if (eventType != 2 || !name.equals("Blob")) continue;
            break;
        }
        xmlr.require(2, null, "Blob");
        if (properties != null) {
            CloudBlob retBlob = null;
            StorageUri blobUri = serviceClient.getStorageUri();
            blobUri = PathUtility.appendPathToUri(blobUri, container.getName());
            blobUri = PathUtility.appendPathToUri(blobUri, blobName);
            if (properties.getBlobType() == BlobType.BLOCK_BLOB) {
                retBlob = new CloudBlockBlob(blobUri, serviceClient, container);
            } else if (properties.getBlobType() == BlobType.PAGE_BLOB) {
                retBlob = new CloudPageBlob(blobUri, serviceClient, container);
            } else {
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            retBlob.setStorageUri(blobUri);
            retBlob.snapshotID = snapshotID;
            retBlob.properties = properties;
            retBlob.metadata = metadata;
            return retBlob;
        }
        throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
    }

    public static ArrayList<BlockEntry> readBlobBlocks(XMLStreamReader xmlr, BlockSearchMode searchMode) throws XMLStreamException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<BlockEntry> retBlocks = new ArrayList<BlockEntry>();
        xmlr.require(1, null, "Block");
        while (xmlr.hasNext() && "Block".equals(xmlr.getName().toString())) {
            String blockName = null;
            long blockSize = -1L;
            while (xmlr.hasNext()) {
                eventType = xmlr.next();
                String name = xmlr.getName().toString();
                if (eventType == 1) {
                    if (name.equals("Name")) {
                        blockName = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Name");
                        continue;
                    }
                    if (name.equals("Size")) {
                        String sizeString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Size");
                        blockSize = Long.parseLong(sizeString);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (eventType != 2) continue;
                BlockEntry newBlock = new BlockEntry(blockName, searchMode);
                newBlock.setSize(blockSize);
                retBlocks.add(newBlock);
                break;
            }
            eventType = xmlr.next();
        }
        return retBlocks;
    }

    private static BlobContainerAttributes readBlobContainerAttributes(XMLStreamReader xmlr) throws XMLStreamException, ParseException, URISyntaxException {
        int eventType = xmlr.getEventType();
        BlobContainerAttributes attributes = new BlobContainerAttributes();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Name")) {
                    attributes.setName(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Name"));
                    continue;
                }
                if (name.equals("Properties")) {
                    attributes.setProperties(BlobDeserializationHelper.readBlobContainerProperties(xmlr));
                    xmlr.require(2, null, "Properties");
                    continue;
                }
                if (!name.equals("Metadata")) continue;
                attributes.setMetadata(DeserializationHelper.parseMetadateFromXML(xmlr));
                xmlr.require(2, null, "Metadata");
                continue;
            }
            if (eventType != 2 || !name.equals("Container")) continue;
            break;
        }
        return attributes;
    }

    private static BlobContainerProperties readBlobContainerProperties(XMLStreamReader xmlr) throws XMLStreamException, ParseException {
        xmlr.require(1, null, "Properties");
        int eventType = xmlr.getEventType();
        BlobContainerProperties properties = new BlobContainerProperties();
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                if (name.equals("Last-Modified")) {
                    properties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Last-Modified")));
                    continue;
                }
                if (name.equals("Etag")) {
                    properties.setEtag(Utility.readETagFromXMLReader((XMLStreamReader)xmlr));
                    continue;
                }
                if (name.equals("LeaseStatus")) {
                    properties.setLeaseStatus(LeaseStatus.parse(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"LeaseStatus")));
                    continue;
                }
                if (name.equals("LeaseState")) {
                    properties.setLeaseState(LeaseState.parse(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"LeaseState")));
                    continue;
                }
                if (!name.equals("LeaseDuration")) continue;
                properties.setLeaseDuration(LeaseDuration.parse(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"LeaseDuration")));
                continue;
            }
            xmlr.require(2, null, "Properties");
            break;
        }
        return properties;
    }

    public static ArrayList<ListBlobItem> readBlobItems(XMLStreamReader xmlr, CloudBlobClient serviceClient, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<ListBlobItem> retBlobs = new ArrayList<ListBlobItem>();
        xmlr.require(1, null, "Blobs");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType != 1) break;
            if (name.equals("Blob")) {
                retBlobs.add(BlobDeserializationHelper.readBlob(xmlr, serviceClient, container));
                continue;
            }
            if (name.equals("BlobPrefix")) {
                retBlobs.add(BlobDeserializationHelper.readDirectory(xmlr, container));
                continue;
            }
            throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
        }
        xmlr.require(2, null, "Blobs");
        return retBlobs;
    }

    private static BlobProperties readBlobProperties(XMLStreamReader xmlr) throws XMLStreamException, ParseException, StorageException, URISyntaxException {
        xmlr.require(1, null, "Properties");
        int eventType = xmlr.getEventType();
        BlobProperties properties = new BlobProperties();
        CopyState copyState = null;
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            String name = xmlr.getName().toString();
            if (eventType == 1) {
                String[] progressSequence;
                String tempString;
                if (name.equals("Last-Modified")) {
                    properties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Last-Modified")));
                    continue;
                }
                if (name.equals("Etag")) {
                    properties.setEtag(Utility.readETagFromXMLReader((XMLStreamReader)xmlr));
                    continue;
                }
                if (name.equals("Content-Length")) {
                    tempString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Content-Length");
                    properties.setLength(Long.parseLong(tempString));
                    continue;
                }
                if (name.equals("Content-Type")) {
                    properties.setContentType(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Content-Type"));
                    continue;
                }
                if (name.equals("Content-Encoding")) {
                    properties.setContentEncoding(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Content-Encoding"));
                    continue;
                }
                if (name.equals("Content-Language")) {
                    properties.setContentLanguage(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Content-Language"));
                    continue;
                }
                if (name.equals("Content-MD5")) {
                    properties.setContentMD5(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Content-MD5"));
                    continue;
                }
                if (name.equals("Cache-Control")) {
                    properties.setCacheControl(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Cache-Control"));
                    continue;
                }
                if (name.equals("Content-Disposition")) {
                    properties.setContentDisposition(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Content-Disposition"));
                    continue;
                }
                if (name.equals("x-ms-blob-sequence-number")) {
                    Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"x-ms-blob-sequence-number");
                    continue;
                }
                if (name.equals("BlobType")) {
                    tempString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"BlobType");
                    if (tempString.equals("BlockBlob")) {
                        properties.setBlobType(BlobType.BLOCK_BLOB);
                        continue;
                    }
                    if (tempString.equals("PageBlob")) {
                        properties.setBlobType(BlobType.PAGE_BLOB);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("LeaseStatus")) {
                    LeaseStatus tempStatus = LeaseStatus.parse(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"LeaseStatus"));
                    if (!tempStatus.equals((Object)LeaseStatus.UNSPECIFIED)) {
                        properties.setLeaseStatus(tempStatus);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("LeaseState")) {
                    LeaseState tempState = LeaseState.parse(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"LeaseState"));
                    if (!tempState.equals((Object)LeaseState.UNSPECIFIED)) {
                        properties.setLeaseState(tempState);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("LeaseDuration")) {
                    LeaseDuration tempDuration = LeaseDuration.parse(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"LeaseDuration"));
                    if (!tempDuration.equals((Object)LeaseDuration.UNSPECIFIED)) {
                        properties.setLeaseDuration(tempDuration);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (name.equals("CopyId")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCopyId(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyId"));
                    continue;
                }
                if (name.equals("CopyCompletionTime")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyCompletionTime")));
                    continue;
                }
                if (name.equals("CopyStatus")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setStatus(CopyStatus.parse(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyStatus")));
                    continue;
                }
                if (name.equals("CopySource")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setSource(new URI(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopySource")));
                    continue;
                }
                if (name.equals("CopyProgress")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    tempString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyProgress");
                    progressSequence = tempString.split("/");
                    copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                    copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
                    continue;
                }
                if (name.equals("CopyStatusDescription")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setStatusDescription(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyStatusDescription"));
                    continue;
                }
                if (name.equals("CopyId")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCopyId(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyId"));
                    continue;
                }
                if (name.equals("CopyCompletionTime")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyCompletionTime")));
                    continue;
                }
                if (name.equals("CopyStatus")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setStatus(CopyStatus.parse(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyStatus")));
                    continue;
                }
                if (name.equals("CopySource")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    copyState.setSource(new URI(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopySource")));
                    continue;
                }
                if (name.equals("CopyProgress")) {
                    if (copyState == null) {
                        copyState = new CopyState();
                    }
                    tempString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyProgress");
                    progressSequence = tempString.split("/");
                    copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                    copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
                    continue;
                }
                if (!name.equals("CopyStatusDescription")) continue;
                if (copyState == null) {
                    copyState = new CopyState();
                }
                copyState.setStatusDescription(Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"CopyStatusDescription"));
                continue;
            }
            if (eventType != 2) continue;
            xmlr.require(2, null, "Properties");
            break;
        }
        properties.setCopyState(copyState);
        return properties;
    }

    private static CloudBlobContainer readContainer(XMLStreamReader xmlr, CloudBlobClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "Container");
        BlobContainerAttributes attributes = BlobDeserializationHelper.readBlobContainerAttributes(xmlr);
        StorageUri containerUri = serviceClient.getStorageUri();
        containerUri = PathUtility.appendPathToUri(containerUri, attributes.getName());
        attributes.setStorageUri(containerUri);
        CloudBlobContainer retContainer = new CloudBlobContainer(attributes.getStorageUri(), serviceClient);
        retContainer.setMetadata(attributes.getMetadata());
        retContainer.setName(attributes.getName());
        retContainer.setProperties(attributes.getProperties());
        retContainer.setStorageUri(attributes.getStorageUri());
        xmlr.require(2, null, "Container");
        return retContainer;
    }

    public static ArrayList<CloudBlobContainer> readContainers(XMLStreamReader xmlr, CloudBlobClient serviceClient) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "Containers");
        ArrayList<CloudBlobContainer> containers = new ArrayList<CloudBlobContainer>();
        eventType = xmlr.next();
        while (eventType == 1 && xmlr.hasName() && "Container".equals(xmlr.getName().toString())) {
            containers.add(BlobDeserializationHelper.readContainer(xmlr, serviceClient));
            eventType = xmlr.next();
        }
        xmlr.require(2, null, "Containers");
        return containers;
    }

    private static CloudBlobDirectory readDirectory(XMLStreamReader xmlr, CloudBlobContainer container) throws XMLStreamException, ParseException, URISyntaxException, StorageException {
        xmlr.require(1, null, "BlobPrefix");
        xmlr.next();
        xmlr.require(1, null, "Name");
        String prefixName = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Name");
        xmlr.next();
        xmlr.require(2, null, "BlobPrefix");
        return container.getDirectoryReference(prefixName);
    }

    public static ArrayList<PageRange> readPageRanges(XMLStreamReader xmlr) throws XMLStreamException, StorageException {
        int eventType = xmlr.getEventType();
        ArrayList<PageRange> retRanges = new ArrayList<PageRange>();
        xmlr.require(1, null, "PageRange");
        while (xmlr.hasNext() && "PageRange".equals(xmlr.getName().toString())) {
            long startOffset = -1L;
            long endOffset = -1L;
            while (xmlr.hasNext()) {
                eventType = xmlr.next();
                String name = xmlr.getName().toString();
                if (eventType == 1) {
                    String sizeString;
                    if (name.equals("Start")) {
                        sizeString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"Start");
                        startOffset = Long.parseLong(sizeString);
                        continue;
                    }
                    if (name.equals("End")) {
                        sizeString = Utility.readElementFromXMLReader((XMLStreamReader)xmlr, (String)"End");
                        endOffset = Long.parseLong(sizeString);
                        continue;
                    }
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                if (eventType != 2) continue;
                if (startOffset == -1L || endOffset == -1L) {
                    throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
                }
                PageRange pageRef = new PageRange(startOffset, endOffset);
                retRanges.add(pageRef);
                break;
            }
            eventType = xmlr.next();
        }
        return retRanges;
    }

    private BlobDeserializationHelper() {
    }
}

