/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.AccessCondition;
import com.microsoft.windowsazure.storage.DoesServiceRequest;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlobRequestOptions;
import com.microsoft.windowsazure.storage.blob.BlobType;
import com.microsoft.windowsazure.storage.blob.BlockEntry;
import com.microsoft.windowsazure.storage.blob.BlockSearchMode;
import com.microsoft.windowsazure.storage.blob.CloudBlob;
import com.microsoft.windowsazure.storage.blob.CloudBlockBlob;
import com.microsoft.windowsazure.storage.blob.CloudPageBlob;
import com.microsoft.windowsazure.storage.core.Base64;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class BlobOutputStream
extends OutputStream {
    private static Random blockSequenceGenerator = new Random();
    private final CloudBlob parentBlobRef;
    private BlobType streamType = BlobType.UNSPECIFIED;
    volatile boolean streamFaulted;
    Object lastErrorLock = new Object();
    IOException lastError;
    OperationContext opContext;
    BlobRequestOptions options;
    private MessageDigest md5Digest;
    private long blockIdSequenceNumber = -1L;
    private ArrayList<BlockEntry> blockList;
    private long currentPageOffset;
    private ByteArrayOutputStream outBuffer;
    private int currentBufferedBytes;
    private int internalWriteThreshold = -1;
    private volatile int outstandingRequests;
    private final ExecutorService threadExecutor;
    private final ExecutorCompletionService<Void> completionService;
    AccessCondition accessCondition = null;

    protected BlobOutputStream(CloudBlob parentBlob, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.accessCondition = accessCondition;
        this.parentBlobRef = parentBlob;
        this.parentBlobRef.assertCorrectBlobType();
        this.options = new BlobRequestOptions(options);
        this.outBuffer = new ByteArrayOutputStream();
        this.opContext = opContext;
        this.streamFaulted = false;
        if (this.options.getConcurrentRequestCount() < 1) {
            throw new IllegalArgumentException("ConcurrentRequestCount");
        }
        if (this.options.getStoreBlobContentMD5().booleanValue()) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        this.threadExecutor = Executors.newFixedThreadPool(this.options.getConcurrentRequestCount());
        this.completionService = new ExecutorCompletionService(this.threadExecutor);
    }

    protected BlobOutputStream(CloudBlockBlob parentBlob, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this((CloudBlob)parentBlob, accessCondition, options, opContext);
        this.blockIdSequenceNumber = (long)blockSequenceGenerator.nextInt(Integer.MAX_VALUE) + (long)blockSequenceGenerator.nextInt(2147383647);
        this.blockList = new ArrayList();
        this.streamType = BlobType.BLOCK_BLOB;
        this.internalWriteThreshold = this.parentBlobRef.getStreamWriteSizeInBytes();
    }

    @DoesServiceRequest
    protected BlobOutputStream(CloudPageBlob parentBlob, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this(parentBlob, accessCondition, options, opContext);
        this.streamType = BlobType.PAGE_BLOB;
        this.internalWriteThreshold = (int)Math.min((long)this.parentBlobRef.getStreamWriteSizeInBytes(), length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStreamState() throws IOException {
        Object object = this.lastErrorLock;
        synchronized (object) {
            if (this.streamFaulted) {
                throw this.lastError;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DoesServiceRequest
    public void close() throws IOException {
        try {
            this.checkStreamState();
            this.flush();
            this.threadExecutor.shutdown();
            while (this.outstandingRequests > 0) {
                this.waitForTaskToComplete();
            }
            this.checkStreamState();
            try {
                this.commit();
            }
            catch (StorageException e) {
                throw Utility.initIOException(e);
            }
        }
        finally {
            Object object = this.lastErrorLock;
            synchronized (object) {
                this.streamFaulted = true;
                this.lastError = new IOException("Stream is already closed.");
            }
            if (!this.threadExecutor.isShutdown()) {
                this.threadExecutor.shutdownNow();
            }
        }
    }

    @DoesServiceRequest
    private void commit() throws StorageException {
        if (this.options.getStoreBlobContentMD5().booleanValue()) {
            this.parentBlobRef.getProperties().setContentMD5(Base64.encode(this.md5Digest.digest()));
        }
        if (this.streamType == BlobType.BLOCK_BLOB) {
            CloudBlockBlob blobRef = (CloudBlockBlob)this.parentBlobRef;
            blobRef.commitBlockList(this.blockList, this.accessCondition, this.options, this.opContext);
        } else if (this.streamType == BlobType.PAGE_BLOB) {
            this.parentBlobRef.uploadProperties(this.accessCondition, this.options, this.opContext);
        }
    }

    @DoesServiceRequest
    private synchronized void dispatchWrite(final int writeLength) throws IOException {
        if (writeLength == 0) {
            return;
        }
        Callable<Void> worker = null;
        if (this.outstandingRequests > this.options.getConcurrentRequestCount() * 2) {
            this.waitForTaskToComplete();
        }
        final ByteArrayInputStream bufferRef = new ByteArrayInputStream(this.outBuffer.toByteArray());
        if (this.streamType == BlobType.BLOCK_BLOB) {
            final CloudBlockBlob blobRef = (CloudBlockBlob)this.parentBlobRef;
            final String blockID = Base64.encode(Utility.getBytesFromLong(this.blockIdSequenceNumber++));
            this.blockList.add(new BlockEntry(blockID, BlockSearchMode.LATEST));
            worker = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        blobRef.uploadBlock(blockID, bufferRef, writeLength, BlobOutputStream.this.accessCondition, BlobOutputStream.this.options, BlobOutputStream.this.opContext);
                    }
                    catch (IOException e) {
                        Object object = BlobOutputStream.this.lastErrorLock;
                        synchronized (object) {
                            BlobOutputStream.this.streamFaulted = true;
                            BlobOutputStream.this.lastError = e;
                        }
                    }
                    catch (StorageException e) {
                        Object object = BlobOutputStream.this.lastErrorLock;
                        synchronized (object) {
                            BlobOutputStream.this.streamFaulted = true;
                            BlobOutputStream.this.lastError = Utility.initIOException(e);
                        }
                    }
                    return null;
                }
            };
        } else if (this.streamType == BlobType.PAGE_BLOB) {
            long tempLength;
            final CloudPageBlob blobRef = (CloudPageBlob)this.parentBlobRef;
            long tempOffset = this.currentPageOffset;
            final long opWriteLength = tempLength = (long)writeLength;
            final long opOffset = tempOffset;
            this.currentPageOffset += (long)writeLength;
            worker = new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() {
                    try {
                        blobRef.uploadPages(bufferRef, opOffset, opWriteLength, BlobOutputStream.this.accessCondition, BlobOutputStream.this.options, BlobOutputStream.this.opContext);
                    }
                    catch (IOException e) {
                        Object object = BlobOutputStream.this.lastErrorLock;
                        synchronized (object) {
                            BlobOutputStream.this.streamFaulted = true;
                            BlobOutputStream.this.lastError = e;
                        }
                    }
                    catch (StorageException e) {
                        Object object = BlobOutputStream.this.lastErrorLock;
                        synchronized (object) {
                            BlobOutputStream.this.streamFaulted = true;
                            BlobOutputStream.this.lastError = Utility.initIOException(e);
                        }
                    }
                    return null;
                }
            };
        }
        this.completionService.submit(worker);
        ++this.outstandingRequests;
        this.currentBufferedBytes = 0;
        this.outBuffer = new ByteArrayOutputStream();
    }

    @Override
    @DoesServiceRequest
    public synchronized void flush() throws IOException {
        this.checkStreamState();
        if (this.streamType == BlobType.PAGE_BLOB && this.currentBufferedBytes > 0 && this.currentBufferedBytes % 512 != 0) {
            throw new IOException(String.format("Page data must be a multiple of 512 bytes. Buffer currently contains %d bytes.", this.currentBufferedBytes));
        }
        this.dispatchWrite(this.currentBufferedBytes);
    }

    private void waitForTaskToComplete() throws IOException {
        try {
            Future<Void> future = this.completionService.take();
            future.get();
        }
        catch (InterruptedException e) {
            throw Utility.initIOException(e);
        }
        catch (ExecutionException e) {
            throw Utility.initIOException(e);
        }
        --this.outstandingRequests;
    }

    @Override
    @DoesServiceRequest
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    @DoesServiceRequest
    public void write(byte[] data, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.writeInternal(data, offset, length);
    }

    @DoesServiceRequest
    public void write(InputStream sourceStream, long writeLength) throws IOException, StorageException {
        Utility.writeToOutputStream(sourceStream, this, writeLength, false, false, this.opContext, this.options);
    }

    @Override
    @DoesServiceRequest
    public void write(int byteVal) throws IOException {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    @DoesServiceRequest
    private synchronized void writeInternal(byte[] data, int offset, int length) throws IOException {
        while (length > 0) {
            this.checkStreamState();
            int availableBufferBytes = this.internalWriteThreshold - this.currentBufferedBytes;
            int nextWrite = Math.min(availableBufferBytes, length);
            if (this.options.getStoreBlobContentMD5().booleanValue()) {
                this.md5Digest.update(data, offset, nextWrite);
            }
            this.outBuffer.write(data, offset, nextWrite);
            this.currentBufferedBytes += nextWrite;
            offset += nextWrite;
            length -= nextWrite;
            if (this.currentBufferedBytes != this.internalWriteThreshold) continue;
            this.dispatchWrite(this.internalWriteThreshold);
        }
    }
}

