/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.RequestOptions;
import com.microsoft.windowsazure.storage.blob.BlobType;
import com.microsoft.windowsazure.storage.blob.CloudBlobClient;
import com.microsoft.windowsazure.storage.core.Utility;

public final class BlobRequestOptions
extends RequestOptions {
    private Integer concurrentRequestCount = null;
    private Boolean useTransactionalContentMD5 = null;
    private Boolean storeBlobContentMD5 = null;
    private Boolean disableContentMD5Validation = null;
    private Integer singleBlobPutThresholdInBytes = null;

    public BlobRequestOptions() {
    }

    public BlobRequestOptions(BlobRequestOptions other) {
        super(other);
        if (other != null) {
            this.setConcurrentRequestCount(other.getConcurrentRequestCount());
            this.setUseTransactionalContentMD5(other.getUseTransactionalContentMD5());
            this.setStoreBlobContentMD5(other.getStoreBlobContentMD5());
            this.setDisableContentMD5Validation(other.getDisableContentMD5Validation());
            this.setSingleBlobPutThresholdInBytes(other.getSingleBlobPutThresholdInBytes());
        }
    }

    protected static final BlobRequestOptions applyDefaults(BlobRequestOptions options, BlobType blobType, CloudBlobClient client) {
        return BlobRequestOptions.applyDefaults(options, blobType, client, true);
    }

    protected static final BlobRequestOptions applyDefaults(BlobRequestOptions options, BlobType blobType, CloudBlobClient client, boolean setStartTime) {
        BlobRequestOptions modifiedOptions = new BlobRequestOptions(options);
        return BlobRequestOptions.applyDefaultsInternal(modifiedOptions, blobType, client, setStartTime);
    }

    private static final BlobRequestOptions applyDefaultsInternal(BlobRequestOptions modifiedOptions, BlobType blobtype, CloudBlobClient client, boolean setStartTime) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        RequestOptions.applyBaseDefaultsInternal(modifiedOptions, client, setStartTime);
        if (modifiedOptions.getConcurrentRequestCount() == null) {
            modifiedOptions.setConcurrentRequestCount(client.getConcurrentRequestCount());
        }
        if (modifiedOptions.getUseTransactionalContentMD5() == null) {
            modifiedOptions.setUseTransactionalContentMD5(false);
        }
        if (modifiedOptions.getStoreBlobContentMD5() == null) {
            modifiedOptions.setStoreBlobContentMD5(blobtype == BlobType.BLOCK_BLOB);
        }
        if (modifiedOptions.getDisableContentMD5Validation() == null) {
            modifiedOptions.setDisableContentMD5Validation(false);
        }
        if (modifiedOptions.getSingleBlobPutThresholdInBytes() == null) {
            modifiedOptions.setSingleBlobPutThresholdInBytes(client.getSingleBlobPutThresholdInBytes());
        }
        return modifiedOptions;
    }

    public Integer getConcurrentRequestCount() {
        return this.concurrentRequestCount;
    }

    public Boolean getUseTransactionalContentMD5() {
        return this.useTransactionalContentMD5;
    }

    public Boolean getStoreBlobContentMD5() {
        return this.storeBlobContentMD5;
    }

    protected Boolean getDisableContentMD5Validation() {
        return this.disableContentMD5Validation;
    }

    public Integer getSingleBlobPutThresholdInBytes() {
        return this.singleBlobPutThresholdInBytes;
    }

    public void setConcurrentRequestCount(Integer concurrentRequestCount) {
        this.concurrentRequestCount = concurrentRequestCount;
    }

    public void setUseTransactionalContentMD5(Boolean useTransactionalContentMD5) {
        this.useTransactionalContentMD5 = useTransactionalContentMD5;
    }

    public void setStoreBlobContentMD5(Boolean storeBlobContentMD5) {
        this.storeBlobContentMD5 = storeBlobContentMD5;
    }

    public void setDisableContentMD5Validation(Boolean disableContentMD5Validation) {
        this.disableContentMD5Validation = disableContentMD5Validation;
    }

    public void setSingleBlobPutThresholdInBytes(Integer singleBlobPutThresholdInBytes) {
        if (singleBlobPutThresholdInBytes != null && (singleBlobPutThresholdInBytes > 0x4000000 || singleBlobPutThresholdInBytes < 0x100000)) {
            throw new IllegalArgumentException(String.format(Utility.LOCALE_US, "The argument is out of range. Argument name: %s, Value passed: %s.", "singleBlobPutThresholdInBytes", singleBlobPutThresholdInBytes.toString()));
        }
        this.singleBlobPutThresholdInBytes = singleBlobPutThresholdInBytes;
    }
}

