/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.StorageUri;
import com.microsoft.windowsazure.storage.blob.BlobAttributes;
import com.microsoft.windowsazure.storage.blob.BlobProperties;
import com.microsoft.windowsazure.storage.blob.BlobType;
import com.microsoft.windowsazure.storage.blob.CopyState;
import com.microsoft.windowsazure.storage.blob.CopyStatus;
import com.microsoft.windowsazure.storage.core.BaseResponse;
import com.microsoft.windowsazure.storage.core.Utility;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

final class BlobResponse
extends BaseResponse {
    BlobResponse() {
    }

    public static BlobAttributes getAttributes(HttpURLConnection request, StorageUri resourceURI, String snapshotID) throws URISyntaxException, ParseException {
        String blobType = request.getHeaderField("x-ms-blob-type");
        BlobAttributes attributes = new BlobAttributes(BlobType.parse(blobType));
        BlobProperties properties = attributes.getProperties();
        properties.setCacheControl(request.getHeaderField("Cache-Control"));
        properties.setContentDisposition(request.getHeaderField("Content-Disposition"));
        properties.setContentEncoding(request.getHeaderField("Content-Encoding"));
        properties.setContentLanguage(request.getHeaderField("Content-Language"));
        properties.setContentMD5(request.getHeaderField("Content-MD5"));
        properties.setContentType(request.getHeaderField("Content-Type"));
        properties.setEtag(BaseResponse.getEtag(request));
        Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
        lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
        lastModifiedCalendar.setTime(new Date(request.getLastModified()));
        properties.setLastModified(lastModifiedCalendar.getTime());
        properties.setLeaseStatus(BaseResponse.getLeaseStatus(request));
        properties.setLeaseState(BaseResponse.getLeaseState(request));
        properties.setLeaseDuration(BaseResponse.getLeaseDuration(request));
        String rangeHeader = request.getHeaderField("Content-Range");
        String xContentLengthHeader = request.getHeaderField("x-ms-blob-content-length");
        if (!Utility.isNullOrEmpty(rangeHeader)) {
            properties.setLength(Long.parseLong(rangeHeader.split("/")[1]));
        } else if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            properties.setLength(Long.parseLong(xContentLengthHeader));
        } else {
            String contentLength = request.getHeaderField("Content-Length");
            if (!Utility.isNullOrEmpty(contentLength)) {
                properties.setLength(Long.parseLong(contentLength));
            }
        }
        attributes.setStorageUri(resourceURI);
        attributes.setSnapshotID(snapshotID);
        attributes.setMetadata(BaseResponse.getMetadata(request));
        properties.setCopyState(BlobResponse.getCopyState(request));
        attributes.setProperties(properties);
        return attributes;
    }

    public static CopyState getCopyState(HttpURLConnection request) throws URISyntaxException, ParseException {
        String copyStatusString = request.getHeaderField("x-ms-copy-status");
        if (!Utility.isNullOrEmpty(copyStatusString)) {
            String copyCompletionTimeString;
            String copySourceString;
            CopyState copyState = new CopyState();
            copyState.setStatus(CopyStatus.parse(copyStatusString));
            copyState.setCopyId(request.getHeaderField("x-ms-copy-id"));
            copyState.setStatusDescription(request.getHeaderField("x-ms-copy-status-description"));
            String copyProgressString = request.getHeaderField("x-ms-copy-progress");
            if (!Utility.isNullOrEmpty(copyProgressString)) {
                String[] progressSequence = copyProgressString.split("/");
                copyState.setBytesCopied(Long.parseLong(progressSequence[0]));
                copyState.setTotalBytes(Long.parseLong(progressSequence[1]));
            }
            if (!Utility.isNullOrEmpty(copySourceString = request.getHeaderField("x-ms-copy-source"))) {
                copyState.setSource(new URI(copySourceString));
            }
            if (!Utility.isNullOrEmpty(copyCompletionTimeString = request.getHeaderField("x-ms-copy-completion-time"))) {
                copyState.setCompletionTime(Utility.parseRFC1123DateFromStringInGMT(copyCompletionTimeString));
            }
            return copyState;
        }
        return null;
    }

    public static String getSnapshotTime(HttpURLConnection request) {
        return request.getHeaderField("x-ms-snapshot");
    }
}

