/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.blob;

import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.blob.BlockEntry;
import com.microsoft.windowsazure.storage.blob.BlockSearchMode;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class BlockEntryListSerializer {
    BlockEntryListSerializer() {
    }

    public static byte[] writeBlockListToStream(Iterable<BlockEntry> blockList, OperationContext opContext) throws XMLStreamException, StorageException {
        StringWriter outWriter = new StringWriter();
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outWriter);
        xmlw.writeStartDocument();
        xmlw.writeStartElement("BlockList");
        for (BlockEntry block : blockList) {
            if (block.searchMode == BlockSearchMode.COMMITTED) {
                xmlw.writeStartElement("Committed");
            } else if (block.searchMode == BlockSearchMode.UNCOMMITTED) {
                xmlw.writeStartElement("Uncommitted");
            } else if (block.searchMode == BlockSearchMode.LATEST) {
                xmlw.writeStartElement("Latest");
            }
            xmlw.writeCharacters(block.getId());
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
        try {
            return outWriter.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }
}

